/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.collections;

import com.spss.ac.acbase.collections.ArrayUtils;
import com.spss.ac.acbase.collections.Assignable;
import com.spss.math.MissingValue;
import java.util.Arrays;

public class VADouble
implements Assignable<VADouble>,
Cloneable {
    private double[] array = ArrayUtils.ZERO_DOUBLE_ARRAY;

    public VADouble() {
    }

    public VADouble(int n) {
        this(Double.NaN, n);
    }

    public VADouble(double iniVal, int n) {
        this.array = ArrayUtils.newArray(iniVal, n);
    }

    public VADouble(double[] data) {
        this.array = data != null ? (double[])data.clone() : ArrayUtils.ZERO_DOUBLE_ARRAY;
    }

    public void resize(int n) {
        this.resize(n, 0.0);
    }

    public void resize(int n, double value) {
        if (n != this.array.length) {
            double[] arr;
            double[] dArray = arr = n <= 0 ? ArrayUtils.ZERO_DOUBLE_ARRAY : ArrayUtils.newArray(value, n);
            if (this.array.length > 0 && n > 0) {
                System.arraycopy(this.array, 0, arr, 0, Math.min(n, this.array.length));
            }
            this.array = arr;
        }
    }

    @Override
    public VADouble assign(VADouble rhs) {
        if (this != rhs) {
            this.assign(rhs.array);
        }
        return this;
    }

    @Override
    public void assign(double[] arr) {
        if (arr != null) {
            if (this.array.length != arr.length) {
                this.array = (double[])arr.clone();
            } else {
                System.arraycopy(arr, 0, this.array, 0, arr.length);
            }
        } else {
            this.array = ArrayUtils.ZERO_DOUBLE_ARRAY;
        }
    }

    public void assign(int n, double value) {
        if (this.array.length != n) {
            this.array = ArrayUtils.newArray(value, n);
        } else {
            this.fill(value);
        }
    }

    public double[] toArray() {
        return this.array;
    }

    public double[] get() {
        return this.array;
    }

    public void clear() {
        this.array = ArrayUtils.ZERO_DOUBLE_ARRAY;
    }

    public double get(int index) {
        return this.array[index];
    }

    public double back() {
        return this.array.length > 0 ? this.array[this.array.length - 1] : Double.NaN;
    }

    public double front() {
        return this.array.length > 0 ? this.array[0] : Double.NaN;
    }

    public void set(int index, double val) {
        this.array[index] = val;
    }

    public void add(int index, double val) {
        int n = index;
        this.array[n] = this.array[n] + val;
    }

    public boolean isMissing(int index) {
        return MissingValue.isMissing((double)this.array[index]);
    }

    public void setMissing(int index) {
        this.array[index] = Double.NaN;
    }

    public void fill(double val) {
        Arrays.fill(this.array, val);
    }

    public void attach(double[] arr) {
        this.array = arr;
    }

    public double[] detach() {
        double[] arr = this.array;
        this.array = ArrayUtils.ZERO_DOUBLE_ARRAY;
        return arr;
    }

    public int size() {
        return this.array.length;
    }

    public double sum() {
        return ArrayUtils.sum(this.array);
    }

    public VADouble clone() {
        try {
            VADouble result = (VADouble)super.clone();
            if (this.array != null) {
                result.array = (double[])this.array.clone();
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void cshift(int shiftCount) {
        int len = this.array.length;
        if (shiftCount < 0) {
            shiftCount += (Math.abs(shiftCount) / len + 1) * len;
        }
        if ((shiftCount %= len) > 0) {
            int i;
            double[] newArr = new double[len];
            int ind = 0;
            for (i = shiftCount; i < len; ++i) {
                newArr[ind++] = this.array[i];
            }
            for (i = 0; i < shiftCount; ++i) {
                newArr[ind++] = this.array[i];
            }
            this.array = newArr;
        }
    }

    public String toString() {
        return "VADouble [array=" + Arrays.toString(this.array) + "]";
    }
}

