/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.collections;

import com.spss.ac.acbase.collections.ArrayUtils;
import com.spss.ac.acbase.collections.Assignable;
import java.util.Arrays;

public class VAInt
implements Assignable<VAInt>,
Cloneable {
    private int[] array = ArrayUtils.ZERO_INT_ARRAY;

    public VAInt() {
    }

    public VAInt(int n) {
        this(0, n);
    }

    public VAInt(int iniVal, int n) {
        this.array = ArrayUtils.newArray(iniVal, n);
    }

    public void resize(int n) {
        this.resize(n, 0);
    }

    public void resize(int n, int value) {
        if (n != this.array.length) {
            int[] arr;
            int[] nArray = arr = n <= 0 ? ArrayUtils.ZERO_INT_ARRAY : ArrayUtils.newArray(value, n);
            if (this.array.length > 0 && n > 0) {
                System.arraycopy(this.array, 0, arr, 0, Math.min(n, this.array.length));
            }
            this.array = arr;
        }
    }

    @Override
    public VAInt assign(VAInt rhs) {
        if (this != rhs) {
            this.assign(rhs.array);
        }
        return this;
    }

    @Override
    public void assign(int[] arr) {
        if (arr != null) {
            if (this.array.length != arr.length) {
                this.array = (int[])arr.clone();
            } else {
                System.arraycopy(arr, 0, this.array, 0, arr.length);
            }
        } else {
            this.array = ArrayUtils.ZERO_INT_ARRAY;
        }
    }

    public int[] get() {
        return this.array;
    }

    public int[] toArray() {
        return this.array;
    }

    public void clear() {
        this.array = ArrayUtils.ZERO_INT_ARRAY;
    }

    public int get(int index) {
        return this.array[index];
    }

    public int back() {
        return this.array.length > 0 ? this.array[this.array.length - 1] : 0;
    }

    public int front() {
        return this.array.length > 0 ? this.array[0] : 0;
    }

    public void set(int index, int val) {
        this.array[index] = val;
    }

    public void attach(int[] arr) {
        this.array = arr;
    }

    public int[] detach() {
        int[] arr = this.array;
        this.array = ArrayUtils.ZERO_INT_ARRAY;
        return arr;
    }

    public int size() {
        return this.array.length;
    }

    public int max() {
        return ArrayUtils.max(this.array);
    }

    public VAInt clone() {
        try {
            VAInt result = (VAInt)super.clone();
            if (this.array != null) {
                result.array = (int[])this.array.clone();
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return "VAInt [array=" + Arrays.toString(this.array) + "]";
    }
}

