/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.mr;

import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.utilities.functional.Tuple2;
import com.spss.utilities.i18n.LocMsgId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ACMapReduceUtils {
    public static Tuple2<String, InputStream> generateSharedData(String name, ACSerializable data) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(outStream);
        try {
            if (data != null) {
                data.writeObject(dataOutput);
            }
        }
        catch (IOException e) {
            throw new ACException((LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
        return new Tuple2((Object)name, (Object)inStream);
    }

    public static Map<String, ACSerializable> createResults(String name, ACSerializable serResult) {
        HashMap<String, ACSerializable> result = new HashMap<String, ACSerializable>();
        result.put(name, serResult);
        return result;
    }

    public static Integer getIntProperty(String name, Properties prop) {
        Object value;
        Integer result = null;
        if (prop != null && (value = prop.get(name)) != null) {
            if (value instanceof Number) {
                result = ((Number)value).intValue();
            } else if (value instanceof String) {
                result = Integer.parseInt((String)value);
            }
        }
        return result;
    }
}

