/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.parameter;

import com.spss.analyticframework.api.parameters.ParamType;
import com.spss.analyticframework.api.parameters.ParamValue;
import com.spss.analyticframework.api.parameters.Parameter;
import com.spss.analyticframework.api.parameters.Parameters;
import com.spss.analyticframework.api.parameters.values.IntParamValue;
import com.spss.analyticframework.api.parameters.values.RealParamValue;
import com.spss.analyticframework.api.parameters.values.types.RealParamType;
import com.spss.analyticframework.componentapi.expectedparams.ExpectBoolParam;
import com.spss.analyticframework.componentapi.expectedparams.ExpectIntParam;
import com.spss.analyticframework.componentapi.expectedparams.ExpectListParam;
import com.spss.analyticframework.componentapi.expectedparams.ExpectParam;
import com.spss.analyticframework.componentapi.expectedparams.ExpectParamValue;
import com.spss.analyticframework.componentapi.expectedparams.ExpectRealParam;
import com.spss.analyticframework.componentapi.expectedparams.ExpectStringParam;
import java.util.ArrayList;
import java.util.List;

public class ExpectParamGenerator {
    private List<Parameter> expectParams = new ArrayList<Parameter>();

    public void addBoolParam(String name, Boolean defaultValue) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectBoolParam(defaultValue)));
    }

    public void addIntParam(String name, Integer defaultValue) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectIntParam(defaultValue)));
    }

    public void addIntParam(String name, Integer defaultValue, final Integer minRange, final Integer maxRange) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectIntParam(defaultValue){
            {
                super(x0);
                this.minValue = minRange.longValue();
                this.maxValue = maxRange.longValue();
            }
        }));
    }

    public void addIntParam(String name, Integer defaultValue, final Integer minRange, final Integer maxRange, final boolean isLeftBorderClosed, final boolean isRightBorderClosed) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectIntParam(defaultValue){
            {
                super(x0);
                this.minValue = minRange.longValue();
                this.maxValue = maxRange.longValue();
                this.greaterThanOrEquals = isLeftBorderClosed;
                this.lessThanOrEquals = isRightBorderClosed;
            }
        }));
    }

    public void addLongParam(String name, Long defaultValue) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectIntParam(defaultValue)));
    }

    public void addLongParam(String name, Long defaultValue, final Long minRange, final Long maxRange) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectIntParam(defaultValue){
            {
                super(x0);
                this.minValue = minRange;
                this.maxValue = maxRange;
            }
        }));
    }

    public void addLongParam(String name, Long defaultValue, final Long minRange, final Long maxRange, final boolean isLeftBorderClosed, final boolean isRightBorderClosed) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectIntParam(defaultValue){
            {
                super(x0);
                this.minValue = minRange;
                this.maxValue = maxRange;
                this.greaterThanOrEquals = isLeftBorderClosed;
                this.lessThanOrEquals = isRightBorderClosed;
            }
        }));
    }

    public void addRealParam(String name, Double defaultValue) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectRealParam(defaultValue)));
    }

    public void addRealParam(String name, boolean optional) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectRealParam(), optional));
    }

    public void addRealParam(String name, Double defaultValue, final Double minRange, final Double maxRange) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectRealParam(defaultValue){
            {
                super(x0);
                this.minValue = minRange;
                this.maxValue = maxRange;
            }
        }));
    }

    public void addRealParam(String name, Double defaultValue, final Double minRange, final Double maxRange, final boolean isLeftBorderClosed, final boolean isRightBorderClosed) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectRealParam(defaultValue){
            {
                super(x0);
                this.minValue = minRange;
                this.maxValue = maxRange;
                this.greaterThanOrEquals = isLeftBorderClosed;
                this.lessThanOrEquals = isRightBorderClosed;
            }
        }));
    }

    public void addStringParam(String name, String defaultValue) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectStringParam(defaultValue, new String[0])));
    }

    public void addStringParam(String name, boolean optional) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectStringParam(), optional));
    }

    public void addStringParam(String name, String defaultValue, String ... valueBounds) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectStringParam(defaultValue, valueBounds)));
    }

    public void addIntListParam(String name, final Integer minRange, final Integer maxRange, Integer ... defaultValues) {
        if (defaultValues.length <= 0) {
            throw new IllegalArgumentException();
        }
        ParamValue[] paramValues = new ParamValue[defaultValues.length];
        for (int i = 0; i < defaultValues.length; ++i) {
            paramValues[i] = i == 0 ? new ExpectIntParam(defaultValues[i].longValue()){
                {
                    super(x0);
                    this.minValue = minRange.longValue();
                    this.maxValue = maxRange.longValue();
                }
            } : new IntParamValue(Long.valueOf(defaultValues[i].longValue()));
        }
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectListParam(paramValues)));
    }

    public void addRealListParam(String name, final Double minRange, final Double maxRange, Double ... defaultValues) {
        if (defaultValues.length <= 0) {
            throw new IllegalArgumentException();
        }
        ParamValue[] paramValues = new ParamValue[defaultValues.length];
        for (int i = 0; i < defaultValues.length; ++i) {
            paramValues[i] = i == 0 ? new ExpectRealParam(defaultValues[i]){
                {
                    super(x0);
                    this.minValue = minRange;
                    this.maxValue = maxRange;
                }
            } : new RealParamValue(defaultValues[i]);
        }
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectListParam(paramValues)));
    }

    public void addRealListParam(String name, boolean optional) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectListParam((ParamType)new RealParamType()), optional));
    }

    public void addStringListParam(String name, String ... strBounds) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectListParam(new ParamValue[]{new ExpectStringParam("", strBounds)})));
    }

    public void addStringListParam(String name, boolean optional) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectListParam(new ParamValue[]{new ExpectStringParam()}), optional));
    }

    public void addBooleanListParam(String name, boolean defaultValue) {
        this.expectParams.add((Parameter)new ExpectParam(name, (ExpectParamValue)new ExpectListParam(new ParamValue[]{new ExpectBoolParam(Boolean.valueOf(defaultValue))})));
    }

    public void addExpectParam(String name, ExpectParamValue paramValue) {
        this.expectParams.add((Parameter)new ExpectParam(name, paramValue));
    }

    public void addExpectParam(ExpectParam param) {
        this.expectParams.add((Parameter)param);
    }

    public void addParam(Parameter param) {
        this.expectParams.add(param);
    }

    public void addExpectParamList(List<Parameter> paramList) {
        this.expectParams.addAll(paramList);
    }

    public Parameters getParameters() {
        return new Parameters(this.expectParams);
    }

    public List<Parameter> getParameterList() {
        return this.expectParams;
    }
}

