/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.parameter;

import com.spss.analyticframework.api.ContextProperties;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class PropertiesParser {
    protected Hashtable<Object, Object> props;

    public PropertiesParser(Properties props) {
        this.props = props;
    }

    public PropertiesParser(ContextProperties comProps) {
        this.props = new Hashtable(comProps.size());
        for (Map.Entry entry : comProps.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.props.put(entry.getKey(), entry.getValue());
        }
    }

    public Hashtable<Object, Object> getProps() {
        return this.props;
    }

    public Integer getInt(String name, Integer defaultVal) {
        Object value;
        Integer result = defaultVal;
        if (this.props != null && (value = this.props.get(name)) != null) {
            if (value instanceof Number) {
                result = ((Number)value).intValue();
            } else if (value instanceof String) {
                result = Integer.parseInt((String)value);
            }
        }
        return result;
    }

    public Double getDouble(String name, Double defaultVal) {
        Object value;
        Double result = defaultVal;
        if (this.props != null && (value = this.props.get(name)) != null) {
            if (value instanceof Number) {
                result = ((Number)value).doubleValue();
            } else if (value instanceof String) {
                result = Double.parseDouble((String)value);
            }
        }
        return result;
    }

    public Long getLong(String name, Long defaultVal) {
        Object value;
        Long result = defaultVal;
        if (this.props != null && (value = this.props.get(name)) != null) {
            if (value instanceof Number) {
                result = ((Number)value).longValue();
            } else if (value instanceof String) {
                result = Long.parseLong((String)value);
            }
        }
        return result;
    }

    public String getString(String name, String defaultVal) {
        Object value;
        String result = defaultVal;
        if (this.props != null && (value = this.props.get(name)) != null) {
            result = value.toString();
        }
        return result;
    }
}

