/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.serialization;

import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acbase.serialization.BlockArrayInputStream;
import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.datamodel.DataModel;
import com.spss.datarecord.DataVal;
import com.spss.datarecord.DateVal;
import com.spss.datarecord.IntVal;
import com.spss.datarecord.ListVal;
import com.spss.datarecord.OpaqueVal;
import com.spss.datarecord.RealVal;
import com.spss.datarecord.Record;
import com.spss.datarecord.StringVal;
import com.spss.datarecord.TimeVal;
import com.spss.datarecord.TimestampVal;
import com.spss.math.matrix.DenseSymMatrix;
import com.spss.math.statistics.CCBitSet;
import com.spss.utilities.i18n.LocMsgId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ACSerializationUtils {
    public static <T extends ACSerializable> void writeObject(Class<? extends ACSerializable> clazz, T obj, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag(clazz.getSimpleName(), obj != null, dataOutput);
        if (obj != null) {
            obj.writeObject(dataOutput);
        }
    }

    public static <T extends ACSerializable> T readObject(Class<T> clazz, DataInput dataInput) throws IOException {
        ACSerializable obj = null;
        if (ACSerializationUtils.readObjectExistFlag(clazz.getSimpleName(), dataInput)) {
            try {
                obj = (ACSerializable)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new ACException((LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[]{e});
            }
            catch (IllegalAccessException e) {
                throw new ACException((LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[]{e});
            }
            obj.readObject(dataInput);
        }
        return (T)obj;
    }

    public static <T extends ACSerializable> void writeObjectList(Class<T> clazz, List<T> objList, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("List", objList != null, dataOutput);
        if (objList != null) {
            int size = objList.size();
            dataOutput.writeInt(size);
            for (int i = 0; i < size; ++i) {
                ACSerializationUtils.writeObject(clazz, (ACSerializable)objList.get(i), dataOutput);
            }
        }
    }

    public static <T extends ACSerializable> ArrayList<T> readObjectArrayList(Class<T> clazz, DataInput dataInput) throws IOException {
        ArrayList<T> objList = null;
        if (ACSerializationUtils.readObjectExistFlag("List", dataInput)) {
            int size = dataInput.readInt();
            objList = new ArrayList<T>(size);
            for (int i = 0; i < size; ++i) {
                objList.add(ACSerializationUtils.readObject(clazz, dataInput));
            }
        }
        return objList;
    }

    public static <T extends ACSerializable> LinkedList<T> readObjectLinkedList(Class<T> clazz, DataInput dataInput) throws IOException {
        LinkedList<T> objList = null;
        if (ACSerializationUtils.readObjectExistFlag("List", dataInput)) {
            int size = dataInput.readInt();
            objList = new LinkedList<T>();
            for (int i = 0; i < size; ++i) {
                objList.add(ACSerializationUtils.readObject(clazz, dataInput));
            }
        }
        return objList;
    }

    public static void writeDoubleList(List<Double> dList, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("dList", dList != null, dataOutput);
        if (dList != null) {
            dataOutput.writeInt(dList.size());
            for (Double d : dList) {
                dataOutput.writeDouble(d);
            }
        }
    }

    public static ArrayList<Double> readDoubleArrayList(DataInput dataInput) throws IOException {
        ArrayList<Double> dList = null;
        if (ACSerializationUtils.readObjectExistFlag("dList", dataInput)) {
            int size = dataInput.readInt();
            dList = new ArrayList<Double>(size);
            for (int i = 0; i < size; ++i) {
                dList.add(dataInput.readDouble());
            }
        }
        return dList;
    }

    public static LinkedList<Double> readDoubleLinkedList(DataInput dataInput) throws IOException {
        LinkedList<Double> dList = null;
        if (ACSerializationUtils.readObjectExistFlag("dList", dataInput)) {
            int size = dataInput.readInt();
            dList = new LinkedList<Double>();
            for (int i = 0; i < size; ++i) {
                dList.add(dataInput.readDouble());
            }
        }
        return dList;
    }

    public static void writeIntList(List<Integer> iList, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("iList", iList != null, dataOutput);
        if (iList != null) {
            dataOutput.writeInt(iList.size());
            for (Integer i : iList) {
                dataOutput.writeInt(i);
            }
        }
    }

    public static ArrayList<Integer> readIntArrayList(DataInput dataInput) throws IOException {
        ArrayList<Integer> iList = null;
        if (ACSerializationUtils.readObjectExistFlag("iList", dataInput)) {
            int size = dataInput.readInt();
            iList = new ArrayList<Integer>(size);
            for (int i = 0; i < size; ++i) {
                iList.add(dataInput.readInt());
            }
        }
        return iList;
    }

    public static void writeBoolList(List<Boolean> bList, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("bList", bList != null, dataOutput);
        if (bList != null) {
            dataOutput.writeInt(bList.size());
            for (Boolean i : bList) {
                dataOutput.writeBoolean(i);
            }
        }
    }

    public static ArrayList<Boolean> readBoolArrayList(DataInput dataInput) throws IOException {
        ArrayList<Boolean> bList = null;
        if (ACSerializationUtils.readObjectExistFlag("bList", dataInput)) {
            int size = dataInput.readInt();
            bList = new ArrayList<Boolean>(size);
            for (int i = 0; i < size; ++i) {
                bList.add(dataInput.readBoolean());
            }
        }
        return bList;
    }

    public static void writeString(String str, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("String", str != null, dataOutput);
        if (str != null) {
            dataOutput.writeUTF(str);
        }
    }

    public static String readString(DataInput dataInput) throws IOException {
        String str = null;
        if (ACSerializationUtils.readObjectExistFlag("String", dataInput)) {
            str = dataInput.readUTF();
        }
        return str;
    }

    public static void writeStringList(List<String> sList, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("sList", sList != null, dataOutput);
        if (sList != null) {
            dataOutput.writeInt(sList.size());
            for (String s : sList) {
                ACSerializationUtils.writeString(s, dataOutput);
            }
        }
    }

    public static ArrayList<String> readStringArrayList(DataInput dataInput) throws IOException {
        ArrayList<String> sList = null;
        if (ACSerializationUtils.readObjectExistFlag("sList", dataInput)) {
            int size = dataInput.readInt();
            sList = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                sList.add(ACSerializationUtils.readString(dataInput));
            }
        }
        return sList;
    }

    public static String[] readStringArray(DataInput dataInput) throws IOException {
        String[] result = null;
        if (ACSerializationUtils.readObjectExistFlag("sArr", dataInput)) {
            int size = dataInput.readInt();
            result = new String[size];
            for (int i = 0; i < size; ++i) {
                result[i] = ACSerializationUtils.readString(dataInput);
            }
        }
        return result;
    }

    public static void writeStringArray(String[] sArr, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("sArr", sArr != null, dataOutput);
        if (sArr != null) {
            dataOutput.writeInt(sArr.length);
            for (String s : sArr) {
                ACSerializationUtils.writeString(s, dataOutput);
            }
        }
    }

    public static <T extends ACSerializable> void writeObjectArray(Class<? extends ACSerializable> clazz, T[] array, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("oArr", array != null, dataOutput);
        if (array != null) {
            dataOutput.writeInt(array.length);
            for (T obj : array) {
                ACSerializationUtils.writeObject(clazz, obj, dataOutput);
            }
        }
    }

    public static <T extends ACSerializable> T[] readObjectArray(Class<T> clazz, DataInput dataInput) throws IOException {
        ACSerializable[] array = null;
        if (ACSerializationUtils.readObjectExistFlag("oArr", dataInput)) {
            int length = dataInput.readInt();
            array = (ACSerializable[])Array.newInstance(clazz, length);
            for (int i = 0; i < length; ++i) {
                array[i] = ACSerializationUtils.readObject(clazz, dataInput);
            }
        }
        return array;
    }

    public static void writeIntArray(int[] iArr, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("iArr", iArr != null, dataOutput);
        if (iArr != null) {
            dataOutput.writeInt(iArr.length);
            for (int i : iArr) {
                dataOutput.writeInt(i);
            }
        }
    }

    public static int[] readIntArray(DataInput dataInput) throws IOException {
        int[] iArr = null;
        if (ACSerializationUtils.readObjectExistFlag("iArr", dataInput)) {
            int length = dataInput.readInt();
            iArr = new int[length];
            for (int i = 0; i < length; ++i) {
                iArr[i] = dataInput.readInt();
            }
        }
        return iArr;
    }

    public static void writeLongArray(long[] lArr, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("lArr", lArr != null, dataOutput);
        if (lArr != null) {
            dataOutput.writeInt(lArr.length);
            for (long i : lArr) {
                dataOutput.writeLong(i);
            }
        }
    }

    public static long[] readLongArray(DataInput dataInput) throws IOException {
        long[] iArr = null;
        if (ACSerializationUtils.readObjectExistFlag("lArr", dataInput)) {
            int length = dataInput.readInt();
            iArr = new long[length];
            for (int i = 0; i < length; ++i) {
                iArr[i] = dataInput.readLong();
            }
        }
        return iArr;
    }

    public static void writeDoubleArray(double[] dArr, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("dArr", dArr != null, dataOutput);
        if (dArr != null) {
            dataOutput.writeInt(dArr.length);
            for (double d : dArr) {
                dataOutput.writeDouble(d);
            }
        }
    }

    public static double[] readDoubleArray(DataInput dataInput) throws IOException {
        double[] dArr = null;
        if (ACSerializationUtils.readObjectExistFlag("dArr", dataInput)) {
            int length = dataInput.readInt();
            dArr = new double[length];
            for (int i = 0; i < length; ++i) {
                dArr[i] = dataInput.readDouble();
            }
        }
        return dArr;
    }

    public static void writeObjectExistFlag(String ObjectSymbol, boolean isExist, DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(ObjectSymbol);
        dataOutput.writeBoolean(isExist);
    }

    public static boolean readObjectExistFlag(String objectSymbol, DataInput dataInput) throws IOException {
        String name = dataInput.readUTF();
        boolean isExist = dataInput.readBoolean();
        return name.equals(objectSymbol) && isExist;
    }

    public static void writeDataVal(DataVal obj, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("DataVal", obj != null, dataOutput);
        if (obj != null) {
            DataVal.DataType dt = obj.getDataType();
            dataOutput.writeByte(dt.toInt());
            obj.write(dataOutput);
        }
    }

    public static DataVal readDataVal(DataInput dataInput) throws IOException {
        IntVal data = null;
        if (ACSerializationUtils.readObjectExistFlag("DataVal", dataInput)) {
            byte fieldType = dataInput.readByte();
            DataVal.DataType dt = DataVal.DataType.fromInt((int)fieldType);
            switch (dt) {
                case INT: {
                    data = new IntVal().read(dataInput);
                    break;
                }
                case NULL_INT: {
                    data = IntVal.makeNull();
                    break;
                }
                case REAL: {
                    data = new RealVal().read(dataInput);
                    break;
                }
                case NULL_REAL: {
                    data = RealVal.makeNull();
                    break;
                }
                case STRING: {
                    data = new StringVal().read(dataInput);
                    break;
                }
                case NULL_STRING: {
                    data = StringVal.makeNull();
                    break;
                }
                case DATE: {
                    data = new DateVal().read(dataInput);
                    break;
                }
                case NULL_DATE: {
                    data = DateVal.makeNull();
                    break;
                }
                case TIME: {
                    data = new TimeVal().read(dataInput);
                    break;
                }
                case NULL_TIME: {
                    data = TimeVal.makeNull();
                    break;
                }
                case TIMESTAMP: {
                    data = new TimestampVal().read(dataInput);
                    break;
                }
                case NULL_TIMESTAMP: {
                    data = TimestampVal.makeNull();
                    break;
                }
                case OPAQUE: {
                    data = new OpaqueVal().read(dataInput);
                    break;
                }
                case NULL_OPAQUE: {
                    data = OpaqueVal.makeNull();
                    break;
                }
                case NULL_LIST: {
                    data = ListVal.makeNull();
                    break;
                }
                case LIST: {
                    data = new ListVal().read(dataInput);
                }
            }
        }
        return data;
    }

    public static void writeDataValList(List<DataVal> dataValList, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("DataValList", dataValList != null, dataOutput);
        if (dataValList != null) {
            dataOutput.writeInt(dataValList.size());
            for (DataVal data : dataValList) {
                ACSerializationUtils.writeDataVal(data, dataOutput);
            }
        }
    }

    public static ArrayList<DataVal> readDataValArrayList(DataInput dataInput) throws IOException {
        ArrayList<DataVal> dataValList = null;
        if (ACSerializationUtils.readObjectExistFlag("DataValList", dataInput)) {
            int len = dataInput.readInt();
            dataValList = new ArrayList<DataVal>(len);
            for (int i = 0; i < len; ++i) {
                dataValList.add(ACSerializationUtils.readDataVal(dataInput));
            }
        }
        return dataValList;
    }

    public static void writeHashMapByString2Integer(HashMap<String, Integer> hashMap, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("HashMapString2Integer", hashMap != null, dataOutput);
        if (hashMap != null) {
            dataOutput.writeInt(hashMap.size());
            for (Map.Entry<String, Integer> entry : hashMap.entrySet()) {
                ACSerializationUtils.writeString(entry.getKey(), dataOutput);
                dataOutput.writeInt(entry.getValue());
            }
        }
    }

    public static HashMap<String, Integer> readHashMapByString2Integer(DataInput dataInput) throws IOException {
        HashMap<String, Integer> hashMap = null;
        if (ACSerializationUtils.readObjectExistFlag("HashMapString2Integer", dataInput)) {
            int len = dataInput.readInt();
            hashMap = new HashMap<String, Integer>(len);
            for (int i = 0; i < len; ++i) {
                hashMap.put(ACSerializationUtils.readString(dataInput), dataInput.readInt());
            }
        }
        return hashMap;
    }

    public static void writeHashMapByDouble2Double(HashMap<Double, Double> hashMap, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("HashMapDouble2Double", hashMap != null, dataOutput);
        if (hashMap != null) {
            dataOutput.writeInt(hashMap.size());
            for (Map.Entry<Double, Double> entry : hashMap.entrySet()) {
                dataOutput.writeDouble(entry.getKey());
                dataOutput.writeDouble(entry.getValue());
            }
        }
    }

    public static HashMap<Double, Double> readHashMapByDouble2Double(DataInput dataInput) throws IOException {
        HashMap<Double, Double> hashMap = null;
        if (ACSerializationUtils.readObjectExistFlag("HashMapDouble2Double", dataInput)) {
            int len = dataInput.readInt();
            hashMap = new HashMap<Double, Double>(len);
            for (int i = 0; i < len; ++i) {
                hashMap.put(dataInput.readDouble(), dataInput.readDouble());
            }
        }
        return hashMap;
    }

    public static void writeHashMapByInteger2Integer(HashMap<Integer, Integer> hashMap, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("HashMapInteger2Integer", hashMap != null, dataOutput);
        if (hashMap != null) {
            dataOutput.writeInt(hashMap.size());
            for (Map.Entry<Integer, Integer> entry : hashMap.entrySet()) {
                dataOutput.writeInt(entry.getKey());
                dataOutput.writeInt(entry.getValue());
            }
        }
    }

    public static HashMap<Integer, Integer> readHashMapByInteger2Integer(DataInput dataInput) throws IOException {
        HashMap<Integer, Integer> hashMap = null;
        if (ACSerializationUtils.readObjectExistFlag("HashMapInteger2Integer", dataInput)) {
            int len = dataInput.readInt();
            hashMap = new HashMap<Integer, Integer>(len);
            for (int i = 0; i < len; ++i) {
                hashMap.put(dataInput.readInt(), dataInput.readInt());
            }
        }
        return hashMap;
    }

    public static void writeHashMapByDataVal2Integer(HashMap<DataVal, Integer> hashMap, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("HashMapDataVal2Integer", hashMap != null, dataOutput);
        if (hashMap != null) {
            dataOutput.writeInt(hashMap.size());
            for (Map.Entry<DataVal, Integer> entry : hashMap.entrySet()) {
                ACSerializationUtils.writeDataVal(entry.getKey(), dataOutput);
                dataOutput.writeInt(entry.getValue());
            }
        }
    }

    public static HashMap<DataVal, Integer> readHashMapByDataVal2Integer(DataInput dataInput) throws IOException {
        HashMap<DataVal, Integer> hashMap = null;
        if (ACSerializationUtils.readObjectExistFlag("HashMapDataVal2Integer", dataInput)) {
            int len = dataInput.readInt();
            hashMap = new HashMap<DataVal, Integer>(len);
            for (int i = 0; i < len; ++i) {
                hashMap.put(ACSerializationUtils.readDataVal(dataInput), dataInput.readInt());
            }
        }
        return hashMap;
    }

    public static void writeDenseSymMatrix(DenseSymMatrix matrix, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("DenseSymMatrix", matrix != null, dataOutput);
        if (matrix != null) {
            dataOutput.writeInt(matrix.getNRows());
            ACSerializationUtils.writeDoubleArray(matrix.getMatrix(), dataOutput);
        }
    }

    public static DenseSymMatrix readDenseSymMatrix(DataInput dataInput) throws IOException {
        DenseSymMatrix result = null;
        if (ACSerializationUtils.readObjectExistFlag("DenseSymMatrix", dataInput)) {
            result = new DenseSymMatrix(dataInput.readInt());
            double[] dArr = ACSerializationUtils.readDoubleArray(dataInput);
            if (dArr != null) {
                System.arraycopy(dArr, 0, result.getMatrix(), 0, result.getMatrix().length);
            }
        }
        return result;
    }

    public static void writeCCBitSet(CCBitSet bitSet, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("CCBitSet", bitSet != null, dataOutput);
        if (bitSet != null) {
            dataOutput.writeInt(bitSet.size());
            for (int i = 0; i < bitSet.size(); ++i) {
                dataOutput.writeBoolean(bitSet.isIn(i));
            }
        }
    }

    public static CCBitSet readCCBitSet(DataInput dataInput) throws IOException {
        CCBitSet result = null;
        if (ACSerializationUtils.readObjectExistFlag("CCBitSet", dataInput)) {
            result = new CCBitSet(dataInput.readInt());
            for (int i = 0; i < result.size(); ++i) {
                result.set(i, dataInput.readBoolean());
            }
        }
        return result;
    }

    public static Record readRecord(DataInput dataInput) throws IOException {
        final ArrayList<DataVal> dataValList = ACSerializationUtils.readDataValArrayList(dataInput);
        return new Record(){

            public DataVal getField(int arg0) {
                return (DataVal)dataValList.get(arg0);
            }

            public int getNumFields() {
                return dataValList.size();
            }
        };
    }

    public static void writeRecord(Record record, DataOutput dataOutput) throws IOException {
        int size = record.getNumFields();
        ArrayList<DataVal> dataValList = new ArrayList<DataVal>(size);
        for (int i = 0; i < size; ++i) {
            dataValList.add(record.getField(i));
        }
        ACSerializationUtils.writeDataValList(dataValList, dataOutput);
    }

    public static ArrayList<Record> readRecordList(DataInput dataInput) throws IOException {
        ArrayList<Record> recordList = null;
        if (ACSerializationUtils.readObjectExistFlag("RecordList", dataInput)) {
            int len = dataInput.readInt();
            recordList = new ArrayList<Record>(len);
            for (int i = 0; i < len; ++i) {
                recordList.add(ACSerializationUtils.readRecord(dataInput));
            }
        }
        return recordList;
    }

    public static void writeRecordList(List<Record> records, DataOutput dataOutput) throws IOException {
        ACSerializationUtils.writeObjectExistFlag("RecordList", records != null, dataOutput);
        if (records != null) {
            dataOutput.writeInt(records.size());
            for (Record a : records) {
                ACSerializationUtils.writeRecord(a, dataOutput);
            }
        }
    }

    public static <T extends ACSerializable> T readObjectDirect(Class<T> clazz, DataInput dataInput) {
        ACSerializable result = null;
        try {
            result = (ACSerializable)clazz.newInstance();
            result.readObject(dataInput);
        }
        catch (IllegalAccessException e) {
            throw new ACException((Throwable)e, (LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
        }
        catch (InstantiationException e) {
            throw new ACException((Throwable)e, (LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
        }
        catch (IOException e) {
            throw new ACException((Throwable)e, (LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
        }
        return (T)result;
    }

    public static <T extends ACSerializable> T readObject(Class<T> clazz, Record record) {
        T result = null;
        int numFields = record.getNumFields();
        ArrayList<byte[]> buffers = new ArrayList<byte[]>(numFields);
        for (int i = 0; i < numFields; ++i) {
            DataVal dataVal = record.getField(i);
            if (dataVal.getDataType() != DataVal.DataType.OPAQUE) continue;
            ByteBuffer byteBuff = ((OpaqueVal)dataVal).getVal();
            buffers.add(byteBuff.array());
        }
        result = ACSerializationUtils.readObjectDirect(clazz, new DataInputStream(new BlockArrayInputStream(buffers)));
        return result;
    }

    public static <T extends ACSerializable> T readObject(Class<T> clazz, DataVal dataVal) {
        T result = null;
        DataInput dataInput = ACSerializationUtils.createDataInput(dataVal);
        if (dataInput != null) {
            result = ACSerializationUtils.readObjectDirect(clazz, dataInput);
        }
        return result;
    }

    public static DataInput createDataInput(DataVal dataVal) {
        DataInputStream result = null;
        if (dataVal.getDataType() == DataVal.DataType.OPAQUE) {
            ByteBuffer byteBuff = ((OpaqueVal)dataVal).getVal();
            result = new DataInputStream(new ByteArrayInputStream(byteBuff.array()));
        }
        return result;
    }

    public static DataInput createDataInput(Record record) {
        DataInput result = null;
        int fields = record.getNumFields();
        if (fields > 0) {
            result = ACSerializationUtils.createDataInput(record.getField(0));
        }
        return result;
    }

    public static DataInput createDataInput(ACSerializable object) {
        DataInputStream result = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(outputStream);
        try {
            object.writeObject(dataOutput);
            result = new DataInputStream(new ByteArrayInputStream(outputStream.toByteArray()));
        }
        catch (IOException e) {
            throw new ACException((Throwable)e, (LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
        }
        return result;
    }

    public static DataModel readDataModel(Record record) {
        DataVal dataVal;
        DataModel result = null;
        int fields = record.getNumFields();
        if (fields > 0 && (dataVal = record.getField(0)).getDataType() == DataVal.DataType.OPAQUE) {
            ByteBuffer byteBuff = ((OpaqueVal)dataVal).getVal();
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader xmlReader = null;
            try {
                xmlReader = factory.createXMLStreamReader(new ByteArrayInputStream(byteBuff.array()), "UTF-8");
                result = new DataModel();
                result.read(xmlReader);
            }
            catch (Exception e) {
                result = null;
                throw new ACException((Throwable)e, (LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
            }
            finally {
                if (xmlReader != null) {
                    try {
                        xmlReader.close();
                    }
                    catch (XMLStreamException e) {
                        result = null;
                        throw new ACException((Throwable)e, (LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
                    }
                }
            }
        }
        return result;
    }
}

