/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.serialization;

import com.spss.ac.acbase.collections.ACUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class BlockArrayInputStream
extends InputStream {
    protected List<byte[]> buffers;
    protected byte[] buf;
    protected int pos;
    protected int mark = 0;
    protected int markOffset = 0;
    protected byte[] markBuf;
    protected int markBlockIndex = 0;
    protected int count;
    protected int offset;
    protected int blockIndex;

    public BlockArrayInputStream(List<byte[]> buffers) {
        if (buffers.size() == 0) {
            throw new IllegalArgumentException("size of buffers == 0");
        }
        this.buffers = buffers;
        this.pos = 0;
        this.count = ACUtils.deepSize(buffers);
        this.blockIndex = 0;
        this.switchBuffer();
        this.markBuf = this.buf;
    }

    private synchronized void switchBuffer() {
        this.buf = this.buffers.get(this.blockIndex++);
        this.offset = 0;
    }

    @Override
    public synchronized int read() {
        if (this.pos < this.count) {
            ++this.pos;
            if (this.offset >= this.buf.length) {
                this.switchBuffer();
            }
            return this.buf[this.offset++] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        int left = len;
        while (left > 0) {
            if (this.offset >= this.buf.length) {
                this.switchBuffer();
            }
            int copylen = Math.min(left, this.buf.length - this.offset);
            System.arraycopy(this.buf, this.offset, b, off, copylen);
            this.offset += copylen;
            left -= copylen;
            off += copylen;
        }
        this.pos += len;
        return len;
    }

    @Override
    public synchronized long skip(long n) {
        long copylen;
        if ((long)this.pos + n > (long)this.count) {
            n = this.count - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        for (long left = n; left > 0L; left -= copylen) {
            if (this.offset >= this.buf.length) {
                this.switchBuffer();
            }
            copylen = Math.min(left, (long)(this.buf.length - this.offset));
            this.offset = (int)((long)this.offset + copylen);
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public synchronized int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.pos;
        this.markOffset = this.offset;
        this.markBuf = this.buf;
        this.markBlockIndex = this.blockIndex;
    }

    @Override
    public synchronized void reset() {
        this.pos = this.mark;
        this.offset = this.markOffset;
        this.buf = this.markBuf;
        this.blockIndex = this.markBlockIndex;
    }

    @Override
    public void close() throws IOException {
    }
}

