/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.serialization;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class BlockArrayOutputStream
extends OutputStream {
    protected ArrayList<byte[]> buffers = new ArrayList();
    protected int count;
    protected transient byte[] buf;
    protected transient int offset;
    protected transient int minBlockSize;
    protected transient int maxBlockSize;

    public BlockArrayOutputStream() {
        this(0x400000);
    }

    public BlockArrayOutputStream(int minBlockSize, int maxBlockSize) {
        if (minBlockSize <= 0) {
            throw new IllegalArgumentException("Minimum Block size <= 0");
        }
        if (maxBlockSize <= 0) {
            throw new IllegalArgumentException("Maximum Block size <= 0");
        }
        this.minBlockSize = minBlockSize;
        this.maxBlockSize = maxBlockSize;
        this.buf = new byte[minBlockSize];
        this.buffers.add(this.buf);
    }

    public BlockArrayOutputStream(int size) {
        this(size, size);
    }

    private synchronized void allocBuffer() {
        this.buf = new byte[this.maxBlockSize];
        this.buffers.add(this.buf);
        this.offset = 0;
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity > this.maxBlockSize) {
            newCapacity = this.maxBlockSize;
        }
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity < 0) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
        this.buffers.set(0, this.buf);
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity <= this.maxBlockSize) {
            if (minCapacity - this.buf.length > 0) {
                this.grow(minCapacity);
            }
        } else if (this.offset >= this.buf.length) {
            this.allocBuffer();
        }
    }

    @Override
    public synchronized void write(int b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.offset++] = (byte)b;
        ++this.count;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.ensureCapacity(this.count + len);
        if (this.count + len < this.maxBlockSize) {
            System.arraycopy(b, off, this.buf, this.offset, len);
            this.offset += len;
            this.count += len;
        } else {
            int bytes = 0;
            while (len > 0) {
                this.ensureCapacity(this.count + len);
                bytes = this.offset + len < this.buf.length ? len : this.buf.length - this.offset;
                System.arraycopy(b, off, this.buf, this.offset, bytes);
                this.offset += bytes;
                len -= bytes;
                this.count += bytes;
                off += bytes;
            }
        }
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        for (int i = 0; i < this.buffers.size(); ++i) {
            if (i == this.buffers.size() - 1) {
                out.write(this.buffers.get(i), 0, this.offset);
                continue;
            }
            out.write(this.buffers.get(i), 0, this.buffers.get(i).length);
        }
    }

    public synchronized void reset() {
        this.count = 0;
        this.offset = 0;
        this.buffers.clear();
        this.buffers.add(this.buf);
    }

    public synchronized byte[] toByteArray() {
        byte[] result = null;
        if (this.buffers.size() == 1) {
            result = Arrays.copyOf(this.buf, this.count);
        } else {
            result = new byte[this.count];
            int start = 0;
            for (int i = 0; i < this.buffers.size(); ++i) {
                if (i == this.buffers.size() - 1) {
                    System.arraycopy(this.buffers.get(i), 0, result, start, this.offset);
                    continue;
                }
                System.arraycopy(this.buffers.get(i), 0, result, start, this.buffers.get(i).length);
                start += this.buffers.get(i).length;
            }
        }
        return result;
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized int blockCount() {
        return this.buffers.size();
    }

    public synchronized byte[] block(int index) {
        if (index == this.buffers.size() - 1) {
            return Arrays.copyOf(this.buffers.get(index), this.offset);
        }
        return this.buffers.get(index);
    }

    @Override
    public void close() throws IOException {
    }
}

