/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.serialization;

import com.spss.ac.acbase.serialization.ACSerializable;
import com.spss.ac.acbase.serialization.ACSerializationUtils;
import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.utilities.i18n.LocMsgId;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public class BlockID
implements ACSerializable {
    private static final int MAGIC = BlockID.class.getName().hashCode();
    protected String key;
    protected String uid;
    protected int blockCount;
    protected int index;

    public BlockID() {
    }

    public BlockID(String uid) {
        this.uid = uid;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getUID() {
        return this.uid;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public void setBlockCount(int blockCount) {
        this.blockCount = blockCount;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public byte[] write2ByteArray() {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(outStream);
        try {
            this.writeObject(dataOutput);
        }
        catch (IOException e) {
            throw new ACException((LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
        }
        return outStream.toByteArray();
    }

    @Override
    public Object readObject(DataInput dataInput) throws IOException {
        int m = dataInput.readInt();
        if (m != MAGIC) {
            throw new ACException((LocMsgId)ACMessages.SERIALIZATION_ERROR, new Object[0]);
        }
        this.key = ACSerializationUtils.readString(dataInput);
        this.uid = ACSerializationUtils.readString(dataInput);
        this.blockCount = dataInput.readInt();
        this.index = dataInput.readInt();
        return this;
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(MAGIC);
        ACSerializationUtils.writeString(this.key, dataOutput);
        ACSerializationUtils.writeString(this.uid, dataOutput);
        dataOutput.writeInt(this.blockCount);
        dataOutput.writeInt(this.index);
    }
}

