/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acbase.tuple;

import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.utilities.i18n.LocMsgId;

public class DDPair
implements Comparable<DDPair>,
Cloneable {
    public double first;
    public double second;

    public DDPair() {
    }

    public DDPair(double first, double second) {
        this.first = first;
        this.second = second;
    }

    public static DDPair newMissingPair() {
        return new DDPair(Double.NaN, Double.NaN);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.first);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.second);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public DDPair clone() {
        try {
            return (DDPair)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ACException((Throwable)e, (LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DDPair other = (DDPair)obj;
        if (Double.doubleToLongBits(this.first) != Double.doubleToLongBits(other.first)) {
            return false;
        }
        return Double.doubleToLongBits(this.second) == Double.doubleToLongBits(other.second);
    }

    public String toString() {
        return "DDPair [first=" + this.first + ", second=" + this.second + "]";
    }

    @Override
    public int compareTo(DDPair o) {
        int result = Double.compare(this.first, o.first);
        if (result == 0) {
            result = Double.compare(this.second, o.second);
        }
        return result;
    }
}

