/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice;

public final class Stopwatch {
    String label = null;
    long total = 0L;
    long begin = 0L;
    long end = 0L;

    public Stopwatch() {
    }

    public Stopwatch(boolean immediate) {
        if (immediate) {
            this.start();
        }
    }

    public Stopwatch(String label) {
        this.label = label;
    }

    public Stopwatch(String label, boolean immediate) {
        this.label = label;
        if (immediate) {
            this.start();
        }
    }

    public void start() {
        this.begin = System.currentTimeMillis();
    }

    public long stop() {
        this.end = System.currentTimeMillis();
        this.total += this.end - this.begin;
        return this.total;
    }

    public void cancel() {
        this.begin = 0L;
        this.end = 0L;
    }

    public void reset() {
        this.total = 0L;
        this.begin = 0L;
        this.end = 0L;
    }

    public long elapsed() {
        if (this.end != 0L) {
            return this.end - this.begin;
        }
        return System.currentTimeMillis() - this.begin;
    }

    public long total() {
        if (this.end != 0L) {
            return this.total;
        }
        return System.currentTimeMillis() - this.begin + this.total;
    }

    public String toString() {
        long sec;
        long min;
        long hour;
        long t = this.total();
        StringBuilder sb = new StringBuilder();
        if (this.label != null) {
            sb.append(this.label + ": ");
        }
        if ((hour = t / 3600000L) > 0L) {
            sb.append(hour + "h ");
            t %= 3600000L;
        }
        if ((min = t / 60000L) > 0L) {
            sb.append(min + "m ");
            t %= 60000L;
        }
        if ((sec = t / 1000L) > 0L) {
            sb.append(sec + "s ");
            t %= 1000L;
        }
        if (t > 0L) {
            sb.append(t + "ms");
        }
        return sb.toString();
    }
}

