/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.DBObserver;
import org.apache.xindice.core.DatabaseChangeObserver;
import org.apache.xindice.core.DatabaseShutdownHandler;
import org.apache.xindice.core.DocumentCache;
import org.apache.xindice.core.MetaSystemCollection;
import org.apache.xindice.core.SystemCollection;
import org.apache.xindice.core.query.QueryEngine;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.util.ConfigurationException;
import org.apache.xindice.util.Named;
import org.apache.xindice.util.XindiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class Database
extends Collection
implements Named {
    private static final Log log = LogFactory.getLog(Database.class);
    public static final String DBROOT = "dbroot";
    public static final String NAME = "name";
    private static final String QUERYENGINE = "queryengine";
    private static final String DATABASE = "database";
    private static final String METADATA = "use-metadata";
    public static final String DBROOT_DEFAULT = "./db/";
    private static final String COLKEY = "database.xml";
    private static final String METAKEY = "meta.xml";
    private static final Map databases = new HashMap();
    private static final DatabaseShutdownHandler shutdownHandler = new DatabaseShutdownHandler();
    private DocumentCache docCache = new DocumentCache();
    private QueryEngine engine = new QueryEngine(this);
    private boolean metaEnabled;
    private boolean metaInit;
    private MetaSystemCollection metaSystemCollection;
    private boolean sysInit;
    private SystemCollection systemCollection;
    private FileOutputStream lock;
    private boolean closed = true;
    private Timer timer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database getDatabase(Configuration config) {
        String name = config.getAttribute(NAME);
        if (name == null) {
            throw new ConfigurationException("Database configuration didn't contain a database name");
        }
        Database database = (Database)databases.get(name);
        if (database == null) {
            Map map = databases;
            synchronized (map) {
                database = (Database)databases.get(name);
                if (database == null) {
                    database = new Database();
                    try {
                        database.setConfig(config);
                    }
                    catch (XindiceException x) {
                        throw new ConfigurationException("XindiceException: " + x.getMessage(), x);
                    }
                    databases.put(database.getName(), database);
                }
            }
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database getDatabase(String name) {
        Database database = (Database)databases.get(name);
        if (database == null) {
            Map map = databases;
            synchronized (map) {
                database = (Database)databases.get(name);
            }
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] listDatabases() {
        Map map = databases;
        synchronized (map) {
            return databases.keySet().toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean close(boolean removeFromShutdown) throws DBException {
        if (removeFromShutdown) {
            shutdownHandler.removeDatabase(this);
        }
        if (!this.closed) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Shutting down database: '" + this.getName() + "'"));
            }
            this.flushConfig();
            super.close();
            try {
                this.lock.close();
                new File(this.getCollectionRoot(), "db.lock").delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lock = null;
            Map map = databases;
            synchronized (map) {
                databases.remove(this.getName());
            }
            this.timer.cancel();
            this.closed = true;
        }
        return true;
    }

    public boolean close() throws DBException {
        return this.close(true);
    }

    public void flushConfig() {
        Configuration config;
        if (this.getConfig().isDirty()) {
            try {
                Document d = this.getConfig().getElement().getOwnerDocument();
                this.systemCollection.getCollection("SysConfig").setDocument(COLKEY, d);
                this.getConfig().resetDirty();
            }
            catch (Exception e) {
                log.error((Object)("Error Writing Configuration 'database.xml', for database " + this.getName()), (Throwable)e);
            }
            DBObserver.getInstance().flushDatabaseConfig(this, this.getConfig());
        }
        if (this.isMetaEnabled() && (config = this.metaSystemCollection.getConfig()).isDirty()) {
            try {
                Document d = config.getElement().getOwnerDocument();
                this.systemCollection.getCollection("SysConfig").setDocument(METAKEY, d);
                config.resetDirty();
            }
            catch (Exception e) {
                log.error((Object)("Error writing configuration 'meta.xml', for database " + this.getName()), (Throwable)e);
            }
        }
    }

    public Database getDatabase() {
        return this;
    }

    public DocumentCache getDocumentCache() {
        return this.docCache;
    }

    public MetaSystemCollection getMetaSystemCollection() {
        return this.metaSystemCollection;
    }

    public QueryEngine getQueryEngine() {
        return this.engine;
    }

    public SystemCollection getSystemCollection() {
        return this.systemCollection;
    }

    protected Timer getTimer() {
        return this.timer;
    }

    public boolean isMetaEnabled() {
        return this.metaEnabled;
    }

    public void setConfig(Configuration config) throws XindiceException {
        Collection sysConfigCollection;
        block23: {
            block22: {
                super.setConfig(config);
                this.setCanonicalName('/' + this.getName());
                String dbroot = config.getAttribute(DBROOT);
                File dbrootDir = new File(dbroot);
                if (!dbrootDir.isAbsolute()) {
                    log.warn((Object)("The specified database root directory '" + dbroot + "' is relative. Using property " + "xindice.db.home" + " to resolve."));
                    String home = System.getProperty("xindice.db.home");
                    if (home == null) {
                        log.warn((Object)("The specified database root directory '" + dbroot + "' is relative and there was no " + "xindice.db.home" + " property set, so Xindice was unable to determine a database location. Database will be created relative to the current working directory."));
                        home = ".";
                    }
                    try {
                        dbrootDir = new File(home, dbroot).getCanonicalFile();
                    }
                    catch (IOException e) {
                        throw new XindiceException("Can't get canonical path", e);
                    }
                }
                this.setCollectionRoot(dbrootDir);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Database points to " + dbrootDir.getAbsolutePath()));
                }
                File lock = new File(this.getCollectionRoot(), "db.lock");
                try {
                    if (lock.exists() && !lock.delete()) {
                        throw new IOException("Could not delete lock file.");
                    }
                    this.lock = new FileOutputStream(lock);
                    this.lock.write(new Date().toString().getBytes());
                }
                catch (IOException e) {
                    throw new XindiceException("Unable to open lock file " + lock + ". Make sure database is not open by another process. Exception: " + e);
                }
                shutdownHandler.registerDatabase(this);
                this.timer = new Timer(false);
                this.closed = false;
                try {
                    Configuration queryCfg = config.getChild(QUERYENGINE);
                    if (queryCfg != null) {
                        this.engine.setConfig(queryCfg);
                    }
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block22;
                    log.warn((Object)"ignored exception", (Throwable)e);
                }
            }
            if (!this.sysInit) {
                this.systemCollection = new SystemCollection(this);
                this.systemCollection.init();
                super.addCollection(this.systemCollection);
                this.sysInit = true;
            }
            sysConfigCollection = this.systemCollection.getCollection("SysConfig");
            try {
                Document colDoc = sysConfigCollection.getDocument(COLKEY);
                if (colDoc == null) {
                    DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    colDoc = db.newDocument();
                    Element root = colDoc.createElement(DATABASE);
                    root.setAttribute(NAME, this.getName());
                    colDoc.appendChild(root);
                    sysConfigCollection.setDocument(COLKEY, colDoc);
                }
                super.setConfig(new Configuration(colDoc.getDocumentElement(), false));
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block23;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
        String metaCfg = config.getAttribute(METADATA);
        if (metaCfg.equalsIgnoreCase("on")) {
            this.metaEnabled = true;
        }
        if (this.metaEnabled && !this.metaInit) {
            try {
                this.metaSystemCollection = new MetaSystemCollection(this);
                Document colDoc = sysConfigCollection.getDocument(METAKEY);
                if (colDoc == null) {
                    this.metaSystemCollection.init();
                    Document metaConfig = this.metaSystemCollection.getConfig().getElement().getOwnerDocument();
                    sysConfigCollection.setDocument(METAKEY, metaConfig);
                } else {
                    this.metaSystemCollection.setConfig(new Configuration(colDoc, false));
                }
                super.addCollection(this.metaSystemCollection);
                this.metaInit = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Meta collection is initialized");
                }
            }
            catch (Exception e) {
                log.error((Object)"Meta collection was not initialized", (Throwable)e);
            }
        }
        DBObserver.getInstance().setDatabaseConfig(this, this.getCollections(), config);
    }

    static {
        DBObserver.setInstance(new DatabaseChangeObserver());
    }
}

