/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.DBObserver;
import org.apache.xindice.core.Database;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.Record;
import org.apache.xindice.util.Configuration;
import org.w3c.dom.Document;

public class DatabaseChangeObserver
extends DBObserver {
    private static final Log log = LogFactory.getLog(DatabaseChangeObserver.class);
    private Hashtable collectionDirtyFlags = new Hashtable();
    private Timer flushTimer = new Timer(true);
    private long FLUSH_PERIOD = 60000L;

    public DatabaseChangeObserver() {
        this.flushTimer.schedule((TimerTask)new FlushTask(), this.FLUSH_PERIOD, this.FLUSH_PERIOD);
    }

    public void dropDocument(Collection col, Key key) throws DBException {
        this.collectionDirtyFlags.put(col, Boolean.TRUE);
    }

    public void putDocument(Collection col, Key key, Document document, boolean create) throws DBException {
        this.collectionDirtyFlags.put(col, Boolean.TRUE);
    }

    public void createCollection(Collection col) throws DBException {
    }

    public void loadDocument(Collection col, Record record, Document document) throws DBException {
    }

    public void dropCollection(Collection col) throws DBException {
    }

    public void flushDatabaseConfig(Database db, Configuration cfg) {
    }

    public void setCollectionConfig(Collection col, Configuration cfg) {
    }

    public void setDatabaseConfig(Database db, Map collections, Configuration cfg) {
    }

    private class FlushTask
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Hashtable hashtable = DatabaseChangeObserver.this.collectionDirtyFlags;
            synchronized (hashtable) {
                Iterator collections = DatabaseChangeObserver.this.collectionDirtyFlags.entrySet().iterator();
                int flushCount = 0;
                while (collections.hasNext()) {
                    Map.Entry e = collections.next();
                    Collection c = (Collection)e.getKey();
                    try {
                        c.getFiler().flush();
                        ++flushCount;
                    }
                    catch (DBException ex) {
                        log.error((Object)("Couldn't flush collection: " + c.getName()), (Throwable)ex);
                    }
                }
                log.info((Object)("Successfully flushed " + flushCount + " collections out of " + DatabaseChangeObserver.this.collectionDirtyFlags.size()));
                DatabaseChangeObserver.this.collectionDirtyFlags.clear();
            }
        }
    }
}

