/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.indexer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.Stopwatch;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.RecordSet;
import org.apache.xindice.core.indexer.CannotCreateException;
import org.apache.xindice.core.indexer.DuplicateIndexException;
import org.apache.xindice.core.indexer.IndexPattern;
import org.apache.xindice.core.indexer.Indexer;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.util.ConfigurationCallback;
import org.apache.xindice.util.ObjectStack;
import org.apache.xindice.util.SimpleConfigurable;
import org.apache.xindice.util.XindiceException;
import org.apache.xindice.xml.SymbolTable;
import org.apache.xindice.xml.sax.CompressionHandler;
import org.apache.xindice.xml.sax.SAXEventGenerator;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

public final class IndexManager
extends SimpleConfigurable {
    private static final Log log = LogFactory.getLog(IndexManager.class);
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final IndexerInfo[] EMPTY_INDEXERS = new IndexerInfo[0];
    private static final String INDEX = "index";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final int STATUS_READY = 0;
    private static final int STATUS_BUSY = 1;
    private static final int ACTION_CREATE = 0;
    private static final int ACTION_UPDATE = 1;
    private static final int ACTION_DELETE = 2;
    private Map patternMap = new HashMap();
    private Map indexes = new HashMap();
    private Map bestIndexers = new HashMap();
    private IndexerInfo[] idxList = EMPTY_INDEXERS;
    private Collection collection;
    private Timer timer;
    private SymbolTable symbols;
    private final List newIndexers = new ArrayList();
    private int taskCount;
    private final Object lock = new Object();

    public IndexManager(Collection collection, Timer timer) throws DBException {
        this.collection = collection;
        this.symbols = collection.getSymbols();
        this.timer = timer;
    }

    public void setConfig(Configuration config) throws XindiceException {
        super.setConfig(config);
        config.processChildren(INDEX, new ConfigurationCallback(){

            public void process(Configuration cfg) {
                block2: {
                    String className = cfg.getAttribute(IndexManager.CLASS);
                    try {
                        IndexManager.this.register(Class.forName(className), cfg);
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block2;
                        log.warn((Object)("Failed to register index with class '" + className + "' for collection '" + IndexManager.this.collection.getCanonicalName() + "'"), (Throwable)e);
                    }
                }
            }
        });
    }

    public synchronized String[] list() {
        return this.indexes.keySet().toArray(EMPTY_STRINGS);
    }

    public synchronized boolean drop(final String name) {
        boolean res;
        block2: {
            Indexer idx = this.get(name);
            this.unregister(name);
            this.config.processChildren(INDEX, new ConfigurationCallback(){

                public void process(Configuration cfg) {
                    block3: {
                        try {
                            if (cfg.getAttribute(IndexManager.NAME).equals(name)) {
                                cfg.delete();
                            }
                        }
                        catch (Exception e) {
                            if (!log.isWarnEnabled()) break block3;
                            log.warn((Object)"ignored exception", (Throwable)e);
                        }
                    }
                }
            });
            res = false;
            try {
                res = idx.drop();
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
        return res;
    }

    public synchronized void drop() {
        IndexerInfo[] idx = this.idxList;
        for (int i = 0; i < idx.length; ++i) {
            this.drop(idx[i].name);
        }
    }

    public synchronized Indexer create(Configuration cfg) throws DBException {
        String name = cfg.getAttribute(NAME);
        try {
            Configuration[] cfgs = this.config.getChildren();
            for (int i = 0; i < cfgs.length; ++i) {
                if (!cfgs[i].getAttribute(NAME).equals(name)) continue;
                throw new DuplicateIndexException("Duplicate Index '" + name + "' in collection '" + this.collection.getCanonicalName() + "'");
            }
            String className = cfg.getAttribute(CLASS);
            Indexer idx = this.register(Class.forName(className), cfg);
            this.config.add(cfg);
            return idx;
        }
        catch (DBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CannotCreateException("Cannot create index '" + name + "' in " + this.collection.getCanonicalName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        Object object = this.lock;
        synchronized (object) {
            while (this.taskCount > 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        for (int i = 0; i < this.idxList.length; ++i) {
            try {
                this.idxList[i].indexer.close();
                continue;
            }
            catch (DBException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Failed to close indexer " + this.idxList[i].name + " on collection " + this.collection.getCanonicalName()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Indexer register(Class c, Configuration cfg) throws DBException {
        String name = null;
        try {
            Indexer idx = (Indexer)c.newInstance();
            this.initialize(idx, cfg);
            name = idx.getName();
            if (name == null || name.trim().equals("")) {
                throw new CannotCreateException("No name specified");
            }
            IndexPattern pattern = new IndexPattern(this.symbols, idx.getPattern(), null);
            String style = idx.getIndexStyle();
            IndexerInfo info = new IndexerInfo(name, style, pattern, idx);
            if (!idx.exists()) {
                idx.create();
                idx.open();
                info.status = 1;
                Object object = this.newIndexers;
                synchronized (object) {
                    this.newIndexers.add(info);
                }
                object = this.lock;
                synchronized (object) {
                    ++this.taskCount;
                    try {
                        this.timer.schedule((TimerTask)new PopulateIndexersTimerTask(), 0L);
                    }
                    catch (RuntimeException e) {
                        --this.taskCount;
                        throw e;
                    }
                    catch (Error e) {
                        --this.taskCount;
                        throw e;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Scheduled new task, count is " + this.taskCount));
                    }
                }
            }
            info.status = 0;
            idx.open();
            this.indexes.put(name, info);
            this.patternMap.put(pattern, info);
            Map tbl = (Map)this.bestIndexers.get(style);
            if (tbl != null) {
                tbl.clear();
            }
            this.idxList = this.indexes.values().toArray(EMPTY_INDEXERS);
            return idx;
        }
        catch (DBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CannotCreateException("Cannot create Index '" + name + "' in " + this.collection.getCanonicalName(), e);
        }
    }

    public synchronized void unregister(String name) {
        IndexerInfo idx = (IndexerInfo)this.indexes.remove(name);
        String style = idx.style;
        this.patternMap.remove(idx.pattern);
        Map tbl = (Map)this.bestIndexers.get(style);
        if (tbl != null) {
            tbl.clear();
        }
        this.idxList = this.indexes.values().toArray(EMPTY_INDEXERS);
    }

    private void initialize(Indexer idx, Configuration cfg) throws XindiceException {
        idx.setCollection(this.collection);
        idx.setConfig(cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateNewIndexers() throws DBException {
        IndexerInfo[] list;
        List list2 = this.newIndexers;
        synchronized (list2) {
            list = this.newIndexers.toArray(EMPTY_INDEXERS);
            this.newIndexers.clear();
        }
        if (list.length > 0) {
            int i;
            if (log.isTraceEnabled()) {
                for (int i2 = 0; i2 < list.length; ++i2) {
                    log.trace((Object)("Index Creation: " + list[i2].indexer.getName()));
                }
            }
            Stopwatch sw = new Stopwatch("Populated Indexes", true);
            RecordSet rs = this.collection.getFiler().getRecordSet();
            while (rs.hasMoreRecords()) {
                Key key = rs.getNextKey();
                Object value = this.collection.getEntry(key);
                if (!(value instanceof Document)) continue;
                try {
                    new SAXHandler(key, (Document)value, 0, list);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Failed to index document " + key), (Throwable)e);
                }
            }
            for (i = 0; i < list.length; ++i) {
                block14: {
                    try {
                        list[i].indexer.flush();
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block14;
                        log.warn((Object)"ignored exception", (Throwable)e);
                    }
                }
                list[i].status = 0;
            }
            sw.stop();
            if (log.isDebugEnabled()) {
                for (i = 0; i < list.length; ++i) {
                    log.debug((Object)("Index Complete: " + list[i].indexer.getName()));
                }
                log.debug((Object)sw.toString());
            }
        }
    }

    public synchronized Indexer get(String name) {
        IndexerInfo info = (IndexerInfo)this.indexes.get(name);
        return info != null ? info.indexer : null;
    }

    public Indexer getBestIndexer(String style, IndexPattern pattern) {
        Indexer idx;
        WeakHashMap<IndexPattern, Indexer> tbl = (WeakHashMap<IndexPattern, Indexer>)this.bestIndexers.get(style);
        if (tbl == null) {
            tbl = new WeakHashMap<IndexPattern, Indexer>();
            this.bestIndexers.put(style, tbl);
        }
        if ((idx = (Indexer)tbl.get(pattern)) == null) {
            int highScore = 0;
            for (IndexerInfo info : this.indexes.values()) {
                int score;
                if (info.status != 0 || !info.indexer.getIndexStyle().equals(style) || (score = pattern.getMatchLevel(info.pattern)) <= highScore) continue;
                idx = info.indexer;
                highScore = score;
            }
            tbl.put(pattern, idx);
        }
        return idx;
    }

    public void addDocument(Key key, Document doc) {
        if (this.idxList.length > 0) {
            new SAXHandler(key, doc, 0);
            for (int i = 0; i < this.idxList.length; ++i) {
                try {
                    this.idxList[i].indexer.flush();
                    continue;
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"ignored exception", (Throwable)e);
                }
            }
        }
    }

    public void removeDocument(Key key, Document doc) {
        if (this.idxList.length > 0) {
            new SAXHandler(key, doc, 2);
            for (int i = 0; i < this.idxList.length; ++i) {
                try {
                    this.idxList[i].indexer.flush();
                    continue;
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"ignored exception", (Throwable)e);
                }
            }
        }
    }

    private class PopulateIndexersTimerTask
    extends TimerTask {
        private PopulateIndexersTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                IndexManager.this.populateNewIndexers();
            }
            catch (DBException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"ignored exception", (Throwable)e);
                }
            }
            finally {
                Object object = IndexManager.this.lock;
                synchronized (object) {
                    IndexManager.this.taskCount--;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Task completed, count is " + IndexManager.this.taskCount));
                    }
                    if (IndexManager.this.taskCount == 0) {
                        IndexManager.this.lock.notifyAll();
                    }
                }
            }
        }
    }

    private class StackInfo {
        public short symbolID;
        public StringBuilder sb = null;
        public int pos = -1;
        public int len = -1;

        public StackInfo(short symbolID) {
            this.symbolID = symbolID;
        }
    }

    private class SAXHandler
    implements ContentHandler,
    CompressionHandler {
        private ObjectStack stack;
        private IndexerInfo[] list;
        public Key key;
        public Document doc;
        public int action;
        public StackInfo info;

        public SAXHandler(Key key, Document doc, int action, IndexerInfo[] list) {
            block3: {
                this.stack = new ObjectStack();
                this.list = list;
                this.key = key;
                this.doc = doc;
                this.action = action;
                try {
                    SAXEventGenerator events = new SAXEventGenerator(IndexManager.this.symbols, doc);
                    events.setContentHandler(this);
                    events.setProperty("CompressionHandler/1.0", this);
                    events.start();
                    if (action == 0 || action == 1) {
                        IndexManager.this.collection.flushSymbolTable();
                    }
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)"ignored exception", (Throwable)e);
                }
            }
        }

        public SAXHandler(Key key, Document doc, int action) {
            this(key, doc, action, indexManager.idxList);
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startPrefixMapping(String prefix, String uri) {
        }

        public void endPrefixMapping(String prefix) {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
        }

        public void processingInstruction(String target, String data) {
        }

        public void skippedEntity(String name) {
        }

        public void symbols(SymbolTable symbols) {
        }

        public void dataBytes(byte[] data) {
        }

        public void processEntry(IndexPattern pattern, String value, int pos, int len) {
            block6: for (int i = 0; i < this.list.length; ++i) {
                if (pattern.getMatchLevel(this.list[i].pattern) <= 0) continue;
                try {
                    switch (this.action) {
                        case 0: 
                        case 1: {
                            this.list[i].indexer.add(value, this.key, pos, len, pattern.getElementID(), pattern.getAttributeID());
                            break;
                        }
                        case 2: {
                            this.list[i].indexer.remove(value, this.key, pos, len, pattern.getElementID(), pattern.getAttributeID());
                            break;
                        }
                        default: {
                            if (!log.isWarnEnabled()) continue block6;
                            log.warn((Object)("invalid action : " + this.action));
                            break;
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"ignored exception", (Throwable)e);
                }
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            if (namespaceURI != null && namespaceURI.length() > 0) {
                String elemNSID = SymbolTable.getNormalizedLocalName(localName, namespaceURI);
                this.info.symbolID = IndexManager.this.symbols.getSymbol(elemNSID, namespaceURI, true);
            }
            int size = atts.getLength();
            for (int i = 0; i < size; ++i) {
                String nsURI = atts.getURI(i);
                if (nsURI != null && nsURI.length() > 0) {
                    String attrNSID = "ns" + Integer.toString(nsURI.hashCode()) + ":" + atts.getLocalName(i);
                    short id = IndexManager.this.symbols.getSymbol(attrNSID, nsURI, true);
                    this.processEntry(new IndexPattern(IndexManager.this.symbols, this.info.symbolID, id), atts.getValue(i), this.info.pos, this.info.len);
                    continue;
                }
                short id = IndexManager.this.symbols.getSymbol(atts.getQName(i));
                this.processEntry(new IndexPattern(IndexManager.this.symbols, this.info.symbolID, id), atts.getValue(i), this.info.pos, this.info.len);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            if (this.info.sb != null) {
                this.processEntry(new IndexPattern(IndexManager.this.symbols, this.info.symbolID), this.info.sb.toString(), this.info.pos, this.info.len);
            }
            this.info = (StackInfo)this.stack.pop();
        }

        public void characters(char[] ch, int start, int length) {
            String val = new String(ch).trim();
            if (this.info.sb == null) {
                this.info.sb = new StringBuilder(ch.length);
            } else if (this.info.sb.length() > 0) {
                this.info.sb.append(' ');
            }
            this.info.sb.append(val);
        }

        public void symbolID(short symbolID) {
            if (this.info != null) {
                this.stack.push(this.info);
            }
            this.info = new StackInfo(symbolID);
        }

        public void dataLocation(int pos, int len) {
            this.info.pos = pos;
            this.info.len = len;
        }
    }

    private class IndexerInfo {
        public String name;
        public String style;
        public IndexPattern pattern;
        public Indexer indexer;
        public int status;

        public IndexerInfo(String name, String style, IndexPattern pattern, Indexer indexer) {
            this.name = name;
            this.style = style;
            this.pattern = pattern;
            this.indexer = indexer;
        }
    }
}

