/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.server.rpc;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.server.rpc.RPCMessage;
import org.apache.xmlrpc.XmlRpcException;
import org.xmldb.api.base.XMLDBException;

public final class RPCMessageInterface {
    private static final Log log = LogFactory.getLog(Collection.class);
    public static final String MESSAGE_PARAM = "message";

    public Hashtable run(Hashtable message) throws Exception {
        String type = (String)message.get(MESSAGE_PARAM);
        try {
            RPCMessage handler = (RPCMessage)Class.forName("org.apache.xindice.server.rpc.messages." + type).newInstance();
            return handler.execute(message);
        }
        catch (XMLDBException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception while processing XmlRpc command " + type), (Throwable)e);
            }
            throw new XmlRpcException(e.errorCode * 10000 + e.vendorErrorCode, e.getMessage());
        }
        catch (DBException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception while processing XmlRpc command " + type), (Throwable)e);
            }
            throw new XmlRpcException(10000 + e.faultCode, e.getMessage());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception while processing XmlRpc command " + type), (Throwable)e);
            }
            throw e;
        }
    }
}

