/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.server.rpc.messages;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.server.rpc.RPCDefaultMessage;
import org.apache.xindice.util.SymbolSerializer;
import org.apache.xindice.xml.TextWriter;
import org.apache.xindice.xml.dom.CompressedDocument;
import org.w3c.dom.Document;

public class GetResource
extends RPCDefaultMessage {
    private static final Log log = LogFactory.getLog(GetResource.class);

    public Hashtable execute(Hashtable message) throws Exception {
        if (!message.containsKey("collection")) {
            throw new Exception("Required parameter 'collection' not found.");
        }
        if (!message.containsKey("name")) {
            throw new Exception("Required parameter 'name' not found.");
        }
        Collection col = this.getCollection((String)message.get("collection"));
        Object obj = col.getEntry(message.get("name"));
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        if (obj != null) {
            if (obj instanceof byte[]) {
                result.put("result", obj);
            } else if (message.containsKey("compressed")) {
                SymbolSerializer symbolSerializer;
                block11: {
                    symbolSerializer = null;
                    try {
                        symbolSerializer = new SymbolSerializer(col.getSymbols());
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block11;
                        log.warn((Object)"ignored exception", (Throwable)e);
                    }
                }
                long timestamp = 1L;
                Document doc = (Document)obj;
                if (symbolSerializer != null && ((CompressedDocument)doc).getDataBytes() != null) {
                    result.put("result", symbolSerializer.convertFromDocument(doc, timestamp));
                } else {
                    result.put("result", TextWriter.toString(doc));
                }
            } else {
                Document doc = (Document)obj;
                result.put("result", TextWriter.toString(doc));
            }
        }
        return result;
    }
}

