/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.tools.command;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Hashtable;
import org.apache.xindice.tools.command.Command;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class ExportTree
extends Command {
    public boolean execute(Hashtable table) throws Exception {
        Collection col = null;
        if (table.get("filePath").equals("")) {
            System.out.println("ERROR: Directory name and switch required");
            return false;
        }
        if (table.get("collection") == null) {
            System.out.println("ERROR : Collection name and switch required");
            return false;
        }
        File fp = new File((String)table.get("filePath"));
        System.out.println();
        if (table.get("collection") != null) {
            String parent = this.parentDir((String)table.get("collection"));
            File dir = new File(fp, parent);
            System.out.println("Creating directory " + dir.getPath());
            dir.mkdir();
            this.process(dir, table, col);
        }
        return true;
    }

    private String parentDir(String parent) {
        int idx = parent.lastIndexOf("/");
        if (idx != -1) {
            return parent.substring(idx + 1);
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean process(File directory, Hashtable table, Collection col) throws Exception {
        String collection;
        String[] list;
        block12: {
            list = null;
            collection = (String)table.get("collection");
            String colstring = this.normalizeCollectionURI((String)table.get("collection"), (String)table.get("local"));
            col = DatabaseManager.getCollection((String)colstring);
            if (col != null) break block12;
            System.out.println("ERROR : Collection not found!");
            boolean bl = false;
            Object var15_9 = null;
            if (col == null) return bl;
            col.close();
            return bl;
        }
        try {
            String[] files;
            block13: {
                files = null;
                try {
                    files = col.listResources();
                }
                catch (XMLDBException e) {
                    if (e.errorCode == 1) break block13;
                    throw e;
                }
            }
            if (files != null) {
                System.out.println("Extracting " + files.length + " files from " + table.get("collection"));
                for (int j = 0; j < files.length; ++j) {
                    Object var13_18;
                    Resource res = col.getResource(files[j]);
                    Object content = res.getContent();
                    FileOutputStream output = new FileOutputStream(new File(directory, files[j]));
                    try {
                        if (content instanceof String) {
                            output.write(((String)content).getBytes("utf-8"));
                        } else {
                            output.write((byte[])content);
                        }
                        var13_18 = null;
                    }
                    catch (Throwable throwable) {
                        var13_18 = null;
                        output.close();
                        throw throwable;
                    }
                    output.close();
                }
            }
            list = col.listChildCollections();
            for (int i = 0; i < list.length; ++i) {
                File file = new File(directory, list[i]);
                System.out.println("Creating directory " + file.getPath());
                file.mkdirs();
                table.put("collection", collection + "/" + file.getName());
                this.process(new File(directory + "//" + file.getName()), table, col);
            }
            Object var15_10 = null;
            if (col == null) return true;
        }
        catch (Throwable throwable) {
            Object var15_11 = null;
            if (col == null) throw throwable;
            col.close();
            throw throwable;
        }
        col.close();
        return true;
    }
}

