/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.tools.command;

import java.util.Hashtable;
import org.apache.xindice.tools.command.Command;
import org.apache.xindice.util.StringUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HelpCommand
extends Command {
    public boolean execute(Hashtable table) throws Exception {
        String cmdswitch;
        String desc;
        String helpClass;
        int i;
        NodeList list = (NodeList)table.get("__command_list__");
        System.out.println();
        System.out.println("Xindice Command Tools v1.1");
        System.out.println();
        System.out.println("Format: xindice action [switch] [parameter]");
        System.out.println();
        System.out.println("Switches:");
        System.out.println("    -c           Collection context (must always be specified),");
        System.out.println("                 can be either canonical name of the collection");
        System.out.println("                 or complete xmldb URL");
        System.out.println("    -e           File extension for multiple documents");
        System.out.println("    -f           File path for document retrieval and storage");
        System.out.println("    -n           Name");
        System.out.println("    -p           Index pattern");
        System.out.println("    -q           Query string");
        System.out.println("    -s           Semi-colon delimited list of namespaces for query in ");
        System.out.println("                 the form prefix=namespace-uri");
        System.out.println("    -l           Use a local database rather then going over the network.");
        System.out.println("                 Should be combined with -d to specify the configuration to use.");
        System.out.println("    -d           Path to the database configuration to use for the local ");
        System.out.println("                 database. Only applies if -l is specified.");
        System.out.println("    -t           Specify the data type in collection index");
        System.out.println("    -v           Verbose");
        System.out.println("    --pagesize   Page size for file pages (default: 4096)");
        System.out.println("    --maxkeysize The maximum size for file keys (default: 0=none)");
        System.out.println("    --pagecount  Number of pages in the primary storage (default: 1024)");
        System.out.println("    --filer      Collection filer, can be HashFiler or BTreeFiler (default: BTreeFiler)");
        System.out.println();
        System.out.println("Actions:");
        for (i = 0; i < list.getLength(); ++i) {
            helpClass = ((Element)list.item(i)).getAttribute("helpclass");
            if (!helpClass.equals("document")) continue;
            desc = ((Element)list.item(i)).getAttribute("description");
            cmdswitch = ((Element)list.item(i)).getAttribute("switch");
            System.out.println("    " + StringUtilities.leftJustify(cmdswitch, 13) + desc);
        }
        for (i = 0; i < list.getLength(); ++i) {
            helpClass = ((Element)list.item(i)).getAttribute("helpclass");
            if (!helpClass.equals("security")) continue;
            desc = ((Element)list.item(i)).getAttribute("description");
            cmdswitch = ((Element)list.item(i)).getAttribute("switch");
            System.out.println("    " + StringUtilities.leftJustify(cmdswitch, 13) + desc);
        }
        System.out.println();
        System.out.println("Examples:");
        System.out.println("    xindice ad -c /db/test -f /tmp/xmldocument -n myxmldocument");
        System.out.println("    xindice dd -c /db/test -n myxmldocument");
        System.out.println("    xindice rd -c /db/test/ocs -f a:\\file.xml -n file.xml");
        System.out.println("    xindice xpath -c /db/test/ocs -q test");
        System.out.println("    xindice xpath -c /db/test -s a=http://somedomain.com/schema.xsd -q /a:foo");
        System.out.println("    xindice xupdate -c /db/test -f /path/to/xupdate.xml");
        System.out.println("    xindice xupdate -c /db/test -n document-to-update.xml -f /path/to/xupdate.xml");
        System.out.println();
        System.out.println("For more information, please read the Xindice - Tools Reference Guide");
        System.out.println();
        return true;
    }
}

