/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.xindice.xml.NamespaceMap;
import org.apache.xindice.xml.XMLSerializable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SymbolTable
implements XMLSerializable {
    static final String SYMBOLS = "symbols";
    static final String SYMBOL = "symbol";
    static final String NAME = "name";
    static final String NSURI = "nsuri";
    static final String ID = "id";
    private transient boolean dirty;
    private transient long lastModified = System.currentTimeMillis();
    private final Map symbols = new HashMap();
    private final Map names = new HashMap();
    private short maxSymbol = (short)-1;

    public SymbolTable() {
    }

    public SymbolTable(Element elem) {
        this.streamFromXML(elem);
    }

    public static String getLookupName(String qname, String namespaceURI) {
        StringBuilder sb = new StringBuilder(128);
        sb.append('[');
        sb.append(namespaceURI);
        sb.append(']');
        sb.append(qname);
        return sb.toString();
    }

    public static short getNormalizedSymbol(SymbolTable symbols, String lookup, NamespaceMap nsMap, boolean create) {
        if (lookup.startsWith("[")) {
            int idx = lookup.indexOf(93);
            String nsURI = lookup.substring(1, idx);
            int cidx = lookup.indexOf(idx + 1, 58);
            String name = cidx != -1 ? lookup.substring(cidx + 1) : lookup.substring(idx + 1);
            return symbols.getSymbol(SymbolTable.getNormalizedLocalName(name, nsURI), nsURI, create);
        }
        int idx = lookup.indexOf(58);
        if (idx != -1) {
            String pfx = lookup.substring(0, idx);
            String nsURI = (String)nsMap.get(pfx);
            if (nsURI != null) {
                String name = lookup.substring(idx + 1);
                return symbols.getSymbol(SymbolTable.getNormalizedLocalName(name, nsURI), nsURI, create);
            }
            return symbols.getSymbol(lookup);
        }
        return symbols.getSymbol(lookup, create);
    }

    public static String getNormalizedLocalName(String localName, String namespaceURI) {
        StringBuilder sb = new StringBuilder(32);
        sb.append("ns");
        sb.append(namespaceURI.hashCode());
        sb.append(':');
        sb.append(localName);
        return sb.toString();
    }

    public static String getNormalizedQName(String qName, String namespaceURI) {
        StringBuilder sb = new StringBuilder(32);
        sb.append("ns");
        sb.append(namespaceURI.hashCode());
        sb.append(':');
        int idx = qName.indexOf(58);
        if (idx != -1) {
            sb.append(qName.substring(idx + 1));
        } else {
            sb.append(qName);
        }
        return sb.toString();
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.lastModified = System.currentTimeMillis();
    }

    public final SymbolInfo getSymbolInfo(String qname, String namespaceURI) {
        String lookupName = SymbolTable.getLookupName(qname, namespaceURI);
        return (SymbolInfo)this.symbols.get(lookupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final short getSymbol(String qname, String namespaceURI, boolean create) {
        String lookupName = SymbolTable.getLookupName(qname, namespaceURI);
        SymbolInfo info = (SymbolInfo)this.symbols.get(lookupName);
        if (info != null) {
            return info.symbol;
        }
        if (create) {
            Map map = this.symbols;
            synchronized (map) {
                short id = this.maxSymbol = (short)(this.maxSymbol + 1);
                info = new SymbolInfo(qname, namespaceURI, id);
                this.symbols.put(lookupName, info);
                this.names.put(new Short(id), info);
                this.setDirty(true);
                return id;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final short getSymbol(String qname, boolean create) {
        SymbolInfo info = (SymbolInfo)this.symbols.get(qname);
        if (info != null) {
            return info.symbol;
        }
        if (create) {
            Map map = this.symbols;
            synchronized (map) {
                short id = this.maxSymbol = (short)(this.maxSymbol + 1);
                info = new SymbolInfo(qname, id);
                this.symbols.put(qname, info);
                this.names.put(new Short(id), info);
                this.setDirty(true);
                return id;
            }
        }
        return -1;
    }

    public final short getSymbol(String qname, String namespaceURI) {
        return this.getSymbol(qname, namespaceURI, false);
    }

    public final short getSymbol(String qname) {
        return this.getSymbol(qname, false);
    }

    public final SymbolInfo getSymbolInfo(short symbol) {
        return (SymbolInfo)this.names.get(new Short(symbol));
    }

    public final String getNamespaceURI(short symbol) {
        SymbolInfo info = this.getSymbolInfo(symbol);
        return info != null ? info.namespaceURI : null;
    }

    public final String getName(short symbol) {
        SymbolInfo info = this.getSymbolInfo(symbol);
        return info != null ? info.qname : null;
    }

    public final long getLastModified() {
        return this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Element streamToXML(Document doc) throws DOMException {
        Element root = doc.createElement(SYMBOLS);
        Map map = this.symbols;
        synchronized (map) {
            for (SymbolInfo info : this.symbols.values()) {
                Element e = doc.createElement(SYMBOL);
                e.setAttribute(NAME, info.qname);
                if (info.namespaceURI != null && info.namespaceURI.length() > 0) {
                    e.setAttribute(NSURI, info.namespaceURI);
                }
                e.setAttribute(ID, Short.toString(info.symbol));
                root.appendChild(e);
            }
        }
        return root;
    }

    public final void streamFromXML(Element element) throws DOMException {
        this.symbols.clear();
        this.names.clear();
        this.maxSymbol = (short)-1;
        NodeList list = element.getElementsByTagName(SYMBOL);
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Short id;
            Element elem = (Element)list.item(i);
            String qname = elem.getAttribute(NAME);
            String namespaceURI = elem.getAttribute(NSURI);
            if (namespaceURI != null && namespaceURI.length() == 0) {
                namespaceURI = null;
            }
            if ((id = new Short(elem.getAttribute(ID))) > this.maxSymbol) {
                this.maxSymbol = id;
            }
            SymbolInfo info = new SymbolInfo(qname, namespaceURI, id);
            if (namespaceURI != null) {
                String lookupName = SymbolTable.getLookupName(qname, namespaceURI);
                this.symbols.put(lookupName, info);
            } else {
                this.symbols.put(qname, info);
            }
            this.names.put(id, info);
        }
    }

    public static final class SymbolInfo
    implements Serializable {
        private String namespaceURI;
        private String qname;
        private short symbol;

        public SymbolInfo(String qname, String namespaceURI, short symbol) {
            this.qname = qname;
            this.namespaceURI = namespaceURI;
            this.symbol = symbol;
        }

        public SymbolInfo(String qname, short symbol) {
            this.qname = qname;
            this.symbol = symbol;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public String getQName() {
            return this.qname;
        }

        public short getSymbolID() {
            return this.symbol;
        }
    }
}

