/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml.sax;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.util.ByteArrayInput;
import org.apache.xindice.xml.SymbolTable;
import org.apache.xindice.xml.XMLCompressedInput;
import org.apache.xindice.xml.dom.DOMCompressor;
import org.apache.xindice.xml.sax.CompressionHandler;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXEventGenerator
implements XMLReader {
    private static final Log log = LogFactory.getLog(SAXEventGenerator.class);
    private static final int XMLNS_MAP_INCREMENT = 5;
    public static final String SAX_NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String SAX_NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private boolean hasSaxNamespaces = true;
    private boolean hasSaxNamespacesPrefixes;
    private SymbolTable symbols;
    private byte[] data;
    private int pos;
    private int len;
    private Map properties = new HashMap();
    private ContentHandler content;
    private CompressionHandler comp;
    private ErrorHandler errors;
    private EntityResolver entities;
    private DTDHandler dtd;
    private boolean interrupt;

    public SAXEventGenerator(SymbolTable symbols, byte[] data) {
        this(symbols, data, 0, data.length);
    }

    public SAXEventGenerator(SymbolTable symbols, byte[] data, int pos, int len) {
        this.symbols = symbols;
        this.data = data;
        this.pos = pos;
        this.len = len;
    }

    public SAXEventGenerator(SymbolTable symbols, Document doc) {
        this.symbols = symbols != null ? symbols : new SymbolTable();
        this.data = DOMCompressor.compress(doc, this.symbols);
        this.pos = 0;
        this.len = this.data.length;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (SAX_NAMESPACES_FEATURE.equals(name)) {
            return this.hasSaxNamespaces;
        }
        if (SAX_NAMESPACE_PREFIXES_FEATURE.equals(name)) {
            return this.hasSaxNamespacesPrefixes;
        }
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (SAX_NAMESPACES_FEATURE.equals(name)) {
            this.hasSaxNamespaces = value;
        } else if (SAX_NAMESPACE_PREFIXES_FEATURE.equals(name)) {
            this.hasSaxNamespacesPrefixes = value;
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.properties.put(name, value);
        if (name.equals("CompressionHandler/1.0") && value instanceof CompressionHandler) {
            this.comp = (CompressionHandler)value;
        }
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entities = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entities;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtd = handler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtd;
    }

    public void setContentHandler(ContentHandler handler) {
        this.content = handler;
    }

    public ContentHandler getContentHandler() {
        return this.content;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errors = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errors;
    }

    public void parse(InputSource input) throws IOException, SAXException {
    }

    public void parse(String systemId) throws IOException, SAXException {
    }

    private String getLocalName(String qname) {
        int idx = qname.indexOf(":");
        if (idx != -1) {
            return qname.substring(idx + 1);
        }
        return qname;
    }

    private boolean isNSAttr(String qName) {
        return "xmlns".equals(qName) || qName.startsWith("xmlns:");
    }

    public boolean processContainer(boolean element, int pos, int len) throws IOException, SAXException {
        ByteArrayInput bis = new ByteArrayInput(this.data, pos, len);
        XMLCompressedInput in = new XMLCompressedInput(bis, this.symbols);
        String elemName = null;
        String localName = null;
        String nsURI = null;
        String[] mappedPrefixes = null;
        int nsMapCount = 0;
        if (element) {
            in.readSignature();
            in.readContentSize();
            short elemSymbol = in.readShort();
            elemName = this.symbols.getName(elemSymbol);
            localName = this.getLocalName(elemName);
            nsURI = this.symbols.getNamespaceURI(elemSymbol);
            int attrCount = in.readAttributeCount();
            AttributesImpl attrs = new AttributesImpl();
            for (int i = 0; i < attrCount; ++i) {
                short symbol = in.readShort();
                short strLen = in.readShort();
                byte[] b = new byte[strLen];
                in.read(b);
                String attrName = this.symbols.getName(symbol);
                String attrURI = this.symbols.getNamespaceURI(symbol);
                String lclName = this.getLocalName(attrName);
                String attrValue = new String(b, "UTF8");
                if (this.isNSAttr(attrName)) {
                    if (mappedPrefixes == null) {
                        mappedPrefixes = new String[5];
                    }
                    if (nsMapCount >= mappedPrefixes.length) {
                        String[] newBuf = new String[mappedPrefixes.length + 5];
                        System.arraycopy(mappedPrefixes, 0, newBuf, 0, mappedPrefixes.length);
                        mappedPrefixes = newBuf;
                    }
                    String prefix = "xmlns".equals(attrName) ? "" : lclName;
                    this.content.startPrefixMapping(prefix, attrValue);
                    mappedPrefixes[nsMapCount++] = prefix;
                    if (!this.hasSaxNamespacesPrefixes) continue;
                    attrs.addAttribute("", "", attrName, "CDATA", attrValue);
                    continue;
                }
                attrs.addAttribute(attrURI != null ? attrURI : "", lclName, attrName, "", attrValue);
            }
            if (this.comp != null) {
                this.comp.symbolID(elemSymbol);
                this.comp.dataLocation(pos, len);
            }
            this.content.startElement(nsURI != null ? nsURI : "", localName, elemName, attrs);
        } else {
            in.readInt();
        }
        while (!this.interrupt && bis.available() > 0) {
            pos = bis.getPos();
            in.readSignature();
            len = in.readContentSize();
            if (len == 0) {
                len = 1;
            }
            short type = in.getNodeType();
            block0 : switch (type) {
                case 1: {
                    this.processContainer(true, pos, len);
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    ByteArrayInput tbis = new ByteArrayInput(this.data, pos, len);
                    XMLCompressedInput tin = new XMLCompressedInput(tbis, this.symbols);
                    tin.readSignature();
                    if (type == 3) {
                        tin.readContentSize();
                    } else {
                        tin.readInt();
                    }
                    byte[] buf = new byte[tbis.available()];
                    tin.read(buf);
                    String value = new String(buf, "UTF-8");
                    switch (type) {
                        case 3: {
                            char[] c = value.toCharArray();
                            this.content.characters(c, 0, c.length);
                            break block0;
                        }
                        case 7: {
                            int i = value.indexOf(32);
                            this.content.processingInstruction(value.substring(0, i), value.substring(i + 1));
                            break block0;
                        }
                        case 4: 
                        case 8: {
                            break block0;
                        }
                    }
                    if (!log.isWarnEnabled()) break;
                    log.warn((Object)("invalid type : " + type));
                    break;
                }
                case 5: {
                    break;
                }
                case 12: {
                    break;
                }
                default: {
                    if (!log.isWarnEnabled()) break;
                    log.warn((Object)("invalid node type : " + type));
                }
            }
            bis.setPos(pos);
            bis.skip(len);
        }
        if (element && !this.interrupt) {
            this.content.endElement(nsURI != null ? nsURI : "", localName, elemName);
            for (int i = 0; i < nsMapCount; ++i) {
                this.content.endPrefixMapping((String)mappedPrefixes[i]);
            }
        }
        return !this.interrupt;
    }

    public boolean start() throws IOException, SAXException {
        if (this.comp != null) {
            this.comp.symbols(this.symbols);
            this.comp.dataBytes(this.data);
        }
        this.content.startDocument();
        boolean result = this.processContainer(false, this.pos, this.len);
        if (result) {
            this.content.endDocument();
        }
        return result;
    }

    public void stop() {
        this.interrupt = true;
    }
}

