/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml.sax;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xmldb.api.modules.XMLResource;

public class SetContentHandler
extends DefaultHandler {
    private static final Log log = LogFactory.getLog(SetContentHandler.class);
    protected XMLResource resource = null;
    protected StringBuilder newContent = null;
    protected Map namespaces = null;

    public SetContentHandler(XMLResource resource) {
        this.resource = resource;
        this.namespaces = new HashMap();
    }

    public void startDocument() throws SAXException {
        this.newContent = new StringBuilder();
        this.newContent.append("<?xml version=\"1.0\"?>");
    }

    public void endDocument() throws SAXException {
        try {
            this.resource.setContent((Object)this.newContent.toString());
        }
        catch (Exception e) {
            log.warn((Object)"Exception in endDocument", (Throwable)e);
            throw new SAXException(e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.put(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaces.remove(prefix);
    }

    private String getLocalName(String qn) {
        if (qn.indexOf(58) != -1) {
            return qn.substring(qn.indexOf(58) + 1);
        }
        return qn;
    }

    private String getQNameAtt(String uri, String localName) throws SAXException {
        String prefix = null;
        if ("".equals(uri)) {
            return localName;
        }
        for (String key : this.namespaces.keySet()) {
            if ("".equals(key) || !this.namespaces.get(key).equals(uri)) continue;
            prefix = key;
            break;
        }
        if (prefix == null) {
            throw new SAXException("No declared prefix for namespace '" + uri + "'.");
        }
        return prefix + ":" + localName;
    }

    private String getQNameElement(String uri, String localName) throws SAXException {
        String prefix = null;
        if ("".equals(uri)) {
            if (this.namespaces.get("") != null) {
                throw new SAXException("default namespace is declared here!");
            }
            return localName;
        }
        for (String key : this.namespaces.keySet()) {
            if (!this.namespaces.get(key).equals(uri)) continue;
            prefix = key;
            break;
        }
        if (prefix == null) {
            throw new SAXException("No declared prefix for namespace '" + uri + "'.");
        }
        return "".equals(prefix) ? localName : prefix + ":" + localName;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.newContent.append("<");
        if ("".equals(qName)) {
            this.newContent.append(this.getQNameElement(uri, localName));
        } else {
            this.newContent.append(qName);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qn = attributes.getQName(i);
            if ("".equals(qn)) {
                qn = this.getQNameAtt(attributes.getURI(i), attributes.getLocalName(i));
            }
            this.newContent.append(" ");
            this.newContent.append(qn);
            this.newContent.append("=");
            this.newContent.append("\"");
            this.newContent.append(attributes.getValue(i));
            this.newContent.append("\"");
            if (qn.equals("xmlns")) {
                this.namespaces.remove("");
            }
            if (!qn.startsWith("xmlns:")) continue;
            String ln = this.getLocalName(qn);
            this.namespaces.remove(ln);
        }
        for (String key : this.namespaces.keySet()) {
            this.newContent.append(" xmlns");
            if (key.length() > 0) {
                this.newContent.append(":");
                this.newContent.append(key);
            }
            this.newContent.append("=");
            this.newContent.append("\"");
            this.newContent.append(this.namespaces.get(key));
            this.newContent.append("\"");
            this.namespaces.remove(key);
        }
        this.newContent.append(">");
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.newContent.append("</");
        if ("".equals(qName)) {
            qName = this.getQNameElement(uri, localName);
        }
        this.newContent.append(qName);
        this.newContent.append(">");
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        block7: for (int i = 0; i < length; ++i) {
            char c = ch[start + i];
            switch (c) {
                case '&': {
                    this.newContent.append("&amp;");
                    continue block7;
                }
                case '<': {
                    this.newContent.append("&lt;");
                    continue block7;
                }
                case '>': {
                    this.newContent.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    this.newContent.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    this.newContent.append("&apos;");
                    continue block7;
                }
                default: {
                    if (c > '\u007f') {
                        this.newContent.append("&#" + c + ";");
                        continue block7;
                    }
                    this.newContent.append(c);
                }
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        for (int i = 0; i < length; ++i) {
            this.newContent.append(ch[start + i]);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.newContent.append("<?");
        this.newContent.append(target);
        this.newContent.append(" ");
        if (data != null) {
            this.newContent.append(data);
        }
        this.newContent.append("?>");
    }

    public void skippedEntity(String name) throws SAXException {
    }
}

