/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.bvt.disk;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.core.bvt.IBVColumnReader;
import com.ibm.cognos.aurora.core.bvt.disk.DiskBVColumn;
import com.ibm.cognos.aurora.core.bvt.disk.DiskIndexReader;
import com.ibm.cognos.aurora.core.io.FileChannelDataInputStream;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DiskBVColumnReader
implements IBVColumnReader {
    private final DiskBVColumn mColumn;
    private final DiskIndexReader mIndexReader;
    private final FileChannelDataInputStream mDataInput;
    private long mCurrentIndex = -1L;

    public DiskBVColumnReader(DiskBVColumn column, DiskIndexReader index, File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        this.mColumn = column;
        this.mIndexReader = index;
        this.mDataInput = new FileChannelDataInputStream(raf.getChannel());
        this.mDataInput.position(0L);
    }

    @Override
    public boolean isRandomAccess() {
        return this.mColumn.isRandomAccess();
    }

    @Override
    public IValue at(long index) throws IOException {
        if (!this.mColumn.isRandomAccess()) {
            throw new UnsupportedOperationException();
        }
        if (index < 0L || index >= this.mColumn.getRecordCount()) {
            throw new IndexOutOfBoundsException();
        }
        long pos = this.mIndexReader.positionOf(index);
        this.mDataInput.position(pos);
        this.mCurrentIndex = index;
        return ValueFactory.decodeBinary((DataInput)this.mDataInput, null);
    }

    @Override
    public IValue next() throws IOException {
        if (this.mCurrentIndex + 1L >= this.mColumn.getRecordCount()) {
            return null;
        }
        IValue v = ValueFactory.decodeBinary((DataInput)this.mDataInput, null);
        ++this.mCurrentIndex;
        return v;
    }

    @Override
    public void reset() throws IOException {
        this.mDataInput.position(0L);
        this.mCurrentIndex = -1L;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.isRandomAccess()) {
                this.mIndexReader.close();
            }
        }
        finally {
            this.mDataInput.close();
        }
    }
}

