/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.bvt.heap;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.core.bvt.IBVColumnReader;
import java.io.IOException;
import java.util.List;

public class HeapBVColumnReader
implements IBVColumnReader {
    private final List<IValue> mElements;
    private int mIndex = -1;

    public HeapBVColumnReader(List<IValue> elements) {
        this.mElements = elements;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public IValue at(long index) throws IOException {
        if (index < 0L || index >= (long)this.mElements.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.mIndex = (int)index;
        return this.mElements.get(this.mIndex);
    }

    @Override
    public IValue next() throws IOException {
        if (this.mIndex + 1 >= this.mElements.size()) {
            return null;
        }
        return this.mElements.get(++this.mIndex);
    }

    @Override
    public void reset() throws IOException {
        this.mIndex = -1;
    }

    @Override
    public void close() throws IOException {
    }
}

