/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.bvt.hybrid;

import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.aurora.core.bvt.IBVColumn;
import com.ibm.cognos.aurora.core.bvt.IBVColumnAppender;
import com.ibm.cognos.aurora.core.bvt.IBVColumnReader;
import com.ibm.cognos.aurora.core.bvt.disk.DiskBVColumn;
import com.ibm.cognos.aurora.core.bvt.heap.HeapBVColumn;
import com.ibm.cognos.aurora.core.bvt.hybrid.HybridBVColumnAppender;
import com.ibm.cognos.aurora.core.bvt.hybrid.HybridBVTable;
import java.io.IOException;

public class HybridBVColumn
implements IBVColumn {
    private final HybridBVTable mTable;
    protected HeapBVColumn mHeapColumn;
    protected DiskBVColumn mDiskColumn;

    public HybridBVColumn(HybridBVTable table, HeapBVColumn heapColumn, DiskBVColumn diskColumn) {
        this.mTable = table;
        this.mHeapColumn = heapColumn;
        this.mDiskColumn = diskColumn;
    }

    @Override
    public boolean isRandomAccess() {
        return this.mDiskColumn.isRandomAccess();
    }

    @Override
    public long getRecordCount() {
        if (this.mTable.isSpilledOver()) {
            return this.mDiskColumn.getRecordCount();
        }
        return this.mHeapColumn.getRecordCount();
    }

    @Override
    public IBVColumnAppender openAppender() throws IOException {
        if (this.mTable.isSpilledOver()) {
            return this.mDiskColumn.openAppender();
        }
        return new HybridBVColumnAppender(this.mHeapColumn, this.mDiskColumn);
    }

    @Override
    public IBVColumnReader openReader() throws IOException {
        if (this.mTable.isSpilledOver()) {
            return this.mDiskColumn.openReader();
        }
        return this.mHeapColumn.openReader();
    }

    @Override
    public IValueIterator openIterator() throws IOException {
        if (this.mTable.isSpilledOver()) {
            return this.mDiskColumn.openIterator();
        }
        return this.mHeapColumn.openIterator();
    }

    @Override
    public void copyFrom(IBVColumn source) throws IOException {
        if (this.mTable.isSpilledOver()) {
            this.mDiskColumn.copyFrom(source);
        } else {
            this.mHeapColumn.copyFrom(source);
        }
    }

    @Override
    public void clear() throws IOException {
        if (this.mTable.isSpilledOver()) {
            this.mDiskColumn.clear();
        } else {
            this.mHeapColumn.clear();
        }
    }

    @Override
    public void dispose() {
        this.mHeapColumn = null;
        this.mDiskColumn = null;
    }

    void spillOver() {
        this.mHeapColumn = null;
    }
}

