/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.bvt.union;

import com.ibm.cognos.aurora.api.query.data.IValueTupleIterator;
import com.ibm.cognos.aurora.core.bvt.BVTableIteratorAdapter;
import com.ibm.cognos.aurora.core.bvt.DefaultBVTableReader;
import com.ibm.cognos.aurora.core.bvt.IBVColumn;
import com.ibm.cognos.aurora.core.bvt.IBVColumnReader;
import com.ibm.cognos.aurora.core.bvt.IBVTable;
import com.ibm.cognos.aurora.core.bvt.IBVTableAppender;
import com.ibm.cognos.aurora.core.bvt.IBVTableReader;
import com.ibm.cognos.aurora.core.bvt.union.UnionBVColumn;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class UnionBVTable
implements IBVTable {
    private final List<IBVTable> mSubTables;
    private final List<UnionBVColumn> mColumns;
    private final long mRowCount;
    private final int mColumnCount;

    public UnionBVTable(List<IBVTable> subTables) {
        if (subTables.isEmpty()) {
            throw new IllegalArgumentException("No tables were specified");
        }
        this.mSubTables = subTables;
        this.mColumnCount = subTables.get(0).numColumns();
        long rowCount = 0L;
        for (IBVTable t : subTables) {
            if (t.numColumns() != this.mColumnCount) {
                throw new IllegalArgumentException("Tables have inconsistent column count");
            }
            rowCount += t.numRows();
        }
        this.mRowCount = rowCount;
        this.mColumns = new ArrayList<UnionBVColumn>(this.mColumnCount);
        for (int i = 0; i < this.mColumnCount; ++i) {
            IBVColumn[] subColumns = new IBVColumn[this.mSubTables.size()];
            for (int j = 0; j < this.mSubTables.size(); ++j) {
                subColumns[j] = this.mSubTables.get(j).getColumn(i);
            }
            this.mColumns.add(new UnionBVColumn(subColumns));
        }
    }

    @Override
    public boolean isRandomAccess() {
        return false;
    }

    @Override
    public long numRows() {
        return this.mRowCount;
    }

    @Override
    public int numColumns() {
        return this.mColumnCount;
    }

    @Override
    public IBVColumn[] getColumns() {
        return this.mColumns.toArray(new IBVColumn[0]);
    }

    @Override
    public IBVColumn getColumn(int index) {
        return this.mColumns.get(index);
    }

    @Override
    public int indexOf(IBVColumn col) {
        return this.mColumns.indexOf(col);
    }

    @Override
    public IBVColumn newColumn() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dropColumn(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dropColumn(IBVColumn col) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IBVTableAppender openAppender() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IBVTableReader openReader() throws IOException {
        IBVColumnReader[] colReaders = new IBVColumnReader[this.mColumnCount];
        for (int i = 0; i < this.mColumnCount; ++i) {
            colReaders[i] = this.mColumns.get(i).openReader();
        }
        return new DefaultBVTableReader(colReaders);
    }

    @Override
    public IValueTupleIterator openIterator() throws IOException {
        return new BVTableIteratorAdapter(this.openReader(), this.mRowCount);
    }

    @Override
    public void clear() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        for (IBVTable t : this.mSubTables) {
            t.dispose();
        }
    }
}

