/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.ast;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.core.expert.ast.IXQENodeFactory;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQEIDGenerator;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeIndex;
import com.ibm.cognos.aurora.core.expert.ast.XQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQEQueryNodeException;
import com.ibm.cognos.aurora.core.expert.exception.XQERuntimeException;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.pool.XQEIntegerPoolForNodeType;
import com.ibm.cognos.aurora.core.xml.XMLWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

public abstract class XQEBaseQueryNode
implements IXQEQueryNode {
    private static final String NODE_TYPE_NAME = "nodeTypeName";
    protected static final String STRING_ID = "id";
    protected static final String STRING_ADD = "add";
    protected static final String STRING_POSITION = "position";
    protected static final String STRING_PARENT = "parent";
    private static final String STRING_DELETE = "delete";
    private static final String STRING_REPLACE = "replace";
    private static final String STRING_NEW = "new";
    protected static final String STRING_NAME = "name";
    protected static final String STRING_NEW_PARENT = "newParent";
    protected static final String STRING_MOVE = "move";
    protected static final String STRING_DELETE_NODES = "deleteNodes";
    protected static final String STRING_COLLAPSE = "collapse";
    protected static final String STRING_SET = "set";
    public static final String PROP_GOVERNORS = "governors";
    protected static final String ERR_MSG_INVALID_CHILD_NODE = "At least one invalid child was found.";
    protected static final String STRING_TRANSFER_DESCENDANTS = "transferDescendants";
    protected static final String ERR_PLAN_FAILED = "Query could not be planned.";
    private static final int INITIAL_CHILD_CAPACITY = 2;
    private Integer mId;
    private PlanningEnvironment environment;
    private IXQEQueryNode mParent;
    private final List<IXQEQueryNode> mChildren = new ArrayList<IXQEQueryNode>(2);
    private boolean mDeleted = false;
    private boolean mNodeChanged = true;
    private boolean mHasValidChildren = false;
    protected int mNodeType = -1;
    private static final String STRING_VISITED = "visited";
    private static final String STRING_NODE_ID = "nodeId";

    protected XQEBaseQueryNode() {
    }

    @Override
    public String getNodeTypeName() {
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        return name;
    }

    @Override
    public final Integer getId() {
        return this.mId;
    }

    @Override
    public abstract int getType();

    @Override
    public Integer getTypeObject() {
        return XQEIntegerPoolForNodeType.getInteger(this.getType());
    }

    @Override
    public void setNodeId(Integer id) {
        this.mId = id;
    }

    @Override
    public void setPlanningEnvironment(PlanningEnvironment theEnvironment) {
        this.environment = theEnvironment;
        if (this.environment == null) {
            return;
        }
        XQETrace traceObj = this.environment.getTrace();
        if (traceObj.isEnable(256)) {
            traceObj.beginElement("createNode", this.mId);
            traceObj.attribute(NODE_TYPE_NAME, this.getNodeTypeName());
            traceObj.endElement();
        }
    }

    @Override
    public final int getNumberChildren() {
        return this.mChildren.size();
    }

    @Override
    public final int getNumberChildrenOfType(int aType) {
        int nChildrenOfType = 0;
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            if (child.getNodeType() != aType) continue;
            ++nChildrenOfType;
        }
        return nChildrenOfType;
    }

    @Override
    public final int getNumberChildrenOfTypes(int[] types) {
        int nChildrenOfType = 0;
        block0: for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            for (int type : types) {
                if (child.getNodeType() != type) continue;
                ++nChildrenOfType;
                continue block0;
            }
        }
        return nChildrenOfType;
    }

    @Override
    public final int getNumberChildrenOfCategory(int category) {
        int nChildrenOfCategory = 0;
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            if (child.getNodeType() != category && !child.isOfCategory(category)) continue;
            ++nChildrenOfCategory;
        }
        return nChildrenOfCategory;
    }

    @Override
    public final int getNumberNodes() {
        int num = 1;
        for (IXQEQueryNode child : this.getChildList()) {
            num += child.getNumberNodes();
        }
        return num;
    }

    @Override
    public final IXQEQueryNode getParent() {
        return this.mParent;
    }

    @Override
    public final int getNodeType() {
        return this.mNodeType;
    }

    @Override
    public final IXQEQueryNode getChild(int position) {
        return this.mChildren.get(position);
    }

    @Override
    public final IXQEQueryNode[] getChildren() {
        IXQEQueryNode[] nodes = new IXQEQueryNode[this.mChildren.size()];
        return this.mChildren.toArray(nodes);
    }

    private List<IXQEQueryNode> getChildList() {
        return this.mChildren;
    }

    @Override
    public Iterator<IXQEQueryNode> getChildrenIterator() {
        return this.mChildren.iterator();
    }

    @Override
    public final IXQEQueryNode[] getChildrenOfTypeOrdered(int type) {
        List<IXQEQueryNode> childrenOfType = this.getChildrenOfTypeOrderedList(type);
        return childrenOfType.toArray(new IXQEQueryNode[childrenOfType.size()]);
    }

    private List<IXQEQueryNode> getChildrenOfTypeOrderedList(int type) {
        ArrayList<IXQEQueryNode> childrenOfType = new ArrayList<IXQEQueryNode>();
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            if (child.getNodeType() != type) continue;
            childrenOfType.add(child);
        }
        return childrenOfType;
    }

    @Override
    public final IXQEQueryNode[] getDescendantsOfType(int type, boolean includeSelf) {
        List<IXQEQueryNode> descendantsOfType = this.getDescendantsOfTypeAsList(type, includeSelf);
        return descendantsOfType.toArray(new IXQEQueryNode[descendantsOfType.size()]);
    }

    private List<IXQEQueryNode> getDescendantsOfTypeAsList(int type, boolean includeSelf) {
        List<IXQEQueryNode> descendantsOfType = null;
        if (this.isInNodeIndex()) {
            descendantsOfType = this.environment.getNodeIndex().getDescendantsOfType(type, this);
            if (includeSelf && this.getNodeType() == type) {
                descendantsOfType.add(this);
            }
        } else {
            descendantsOfType = this.getDescendantsOfTypeOrdered(type, includeSelf);
        }
        return descendantsOfType;
    }

    private boolean isInNodeIndex() {
        XQENodeIndex nodeIndex = this.environment.getNodeIndex();
        return nodeIndex != null && nodeIndex.getNodeByID(this.getId()) != null;
    }

    @Override
    public final IXQEQueryNode[] getDescendantsOfTypes(int[] types, boolean includeSelf) {
        List<IXQEQueryNode> descendantsOfTypes = this.getDescendantsOfTypesAsList(types, includeSelf);
        return descendantsOfTypes.toArray(new IXQEQueryNode[descendantsOfTypes.size()]);
    }

    private List<IXQEQueryNode> getDescendantsOfTypesAsList(int[] types, boolean includeSelf) {
        ArrayList<IXQEQueryNode> descendantsOfTypes = new ArrayList<IXQEQueryNode>();
        for (int type : types) {
            List<IXQEQueryNode> descendantsOfType = this.getDescendantsOfTypeAsList(type, false);
            if (includeSelf && this.getNodeType() == type) {
                descendantsOfType.add(this);
            }
            descendantsOfTypes.addAll(descendantsOfType);
        }
        return descendantsOfTypes;
    }

    @Override
    public IXQEQueryNode[] getDescendantsOfTypes(int[] types, boolean includeSelf, int excludeDescendantsUnderType) {
        List<IXQEQueryNode> descendants = this.getDescendantsOfTypesAsList(types, includeSelf);
        this.filterDescendantsByType(descendants, excludeDescendantsUnderType);
        return descendants.toArray(new IXQEQueryNode[descendants.size()]);
    }

    private void filterDescendantsByType(List<IXQEQueryNode> descendants, int nodeType) {
        IXQEQueryNode parent = null;
        Iterator<IXQEQueryNode> it = descendants.iterator();
        block0: while (it.hasNext()) {
            IXQEQueryNode descendant;
            for (parent = descendant = it.next(); parent != this; parent = parent.getParent()) {
                if (parent.getType() != nodeType) continue;
                it.remove();
                continue block0;
            }
        }
    }

    @Override
    public IXQEQueryNode[] getDescendantsOfType(int type, boolean includeSelf, int excludeDescendantsUnderType) {
        List<IXQEQueryNode> descendants = this.getDescendantsOfTypeAsList(type, includeSelf);
        this.filterDescendantsByType(descendants, excludeDescendantsUnderType);
        return descendants.toArray(new IXQEQueryNode[descendants.size()]);
    }

    @Override
    public final List<IXQEQueryNode> getDescendantsOfTypeOrdered(int type, boolean includeSelf) {
        ArrayList<IXQEQueryNode> descendantsOfTypeOrdered = new ArrayList<IXQEQueryNode>();
        this.getDescendantsOfTypeOrdered(descendantsOfTypeOrdered, type, includeSelf);
        return descendantsOfTypeOrdered;
    }

    private void getDescendantsOfTypeOrdered(List<IXQEQueryNode> descendants, int type, boolean includeSelf) {
        if (includeSelf && this.getNodeType() == type) {
            descendants.add(this);
        }
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            ((XQEBaseQueryNode)child).getDescendantsOfTypeOrdered(descendants, type, true);
        }
    }

    @Override
    public final List<IXQEQueryNode> getDescendantsOfTypesOrdered(int[] types, boolean includeSelf) {
        ArrayList<IXQEQueryNode> descendantsOfTypesOrdered = new ArrayList<IXQEQueryNode>();
        this.getDescendantsOfTypesOrdered(descendantsOfTypesOrdered, types, includeSelf);
        return descendantsOfTypesOrdered;
    }

    private void getDescendantsOfTypesOrdered(List<IXQEQueryNode> descendants, int[] types, boolean includeSelf) {
        if (includeSelf && ArrayUtils.contains((int[])types, (int)this.getNodeType())) {
            descendants.add(this);
        }
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            ((XQEBaseQueryNode)child).getDescendantsOfTypesOrdered(descendants, types, true);
        }
    }

    @Override
    public final List<IXQEQueryNode> getDescendantsOfTypeOrdered(int type, int anchorType) {
        ArrayList<IXQEQueryNode> descendantsOfTypeOrdered = new ArrayList<IXQEQueryNode>();
        this.getDescendantsOfTypeOrdered(descendantsOfTypeOrdered, type, anchorType);
        return descendantsOfTypeOrdered;
    }

    private void getDescendantsOfTypeOrdered(List<IXQEQueryNode> descendants, int type, int anchorType) {
        if (this.getNodeType() == type) {
            descendants.add(this);
        }
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            if (child.getNodeType() == anchorType) continue;
            ((XQEBaseQueryNode)child).getDescendantsOfTypeOrdered(descendants, type, anchorType);
        }
    }

    public final List<IXQEQueryNode> getDescendantsOfTypeOrdered(int type, IXQEQueryNode anchorNode) {
        ArrayList<IXQEQueryNode> descendantsOfTypeOrdered = new ArrayList<IXQEQueryNode>();
        this.getDescendantsOfTypeOrdered(descendantsOfTypeOrdered, type, anchorNode);
        return descendantsOfTypeOrdered;
    }

    private void getDescendantsOfTypeOrdered(List<IXQEQueryNode> descendants, int type, IXQEQueryNode anchorNode) {
        if (this.getNodeType() == type) {
            descendants.add(this);
        }
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            if (child == anchorNode) continue;
            ((XQEBaseQueryNode)child).getDescendantsOfTypeOrdered(descendants, type, anchorNode);
        }
    }

    @Override
    public final List<IXQEQueryNode> getFirstDescendantsOfTypeOrdered(int type, boolean includeSelf) {
        ArrayList<IXQEQueryNode> descendantsOfTypeOrdered = new ArrayList<IXQEQueryNode>();
        this.getFirstDescendantsOfTypeOrdered(descendantsOfTypeOrdered, type, includeSelf);
        return descendantsOfTypeOrdered;
    }

    private void getFirstDescendantsOfTypeOrdered(List<IXQEQueryNode> descendants, int type, boolean includeSelf) {
        if (includeSelf && this.getNodeType() == type) {
            descendants.add(this);
            return;
        }
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            ((XQEBaseQueryNode)child).getFirstDescendantsOfTypeOrdered(descendants, type, true);
        }
    }

    @Override
    public final IXQEQueryNode getFirstDescendantOfTypeOrdered(int type, boolean includeSelf) {
        if (includeSelf && this.getNodeType() == type) {
            return this;
        }
        IXQEQueryNode node = null;
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            node = ((XQEBaseQueryNode)child).getFirstDescendantOfTypeOrdered(type, true);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    @Override
    public final IXQEQueryNode getFirstChildByType(int type) {
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            if (child.getNodeType() != type) continue;
            return child;
        }
        return null;
    }

    @Override
    public final IXQEQueryNode getFirstChildNotOfCategory(int category) {
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            if (child.isOfCategory(category)) continue;
            return child;
        }
        return null;
    }

    @Override
    public int getNodeCostMetric() {
        return 0;
    }

    @Override
    public int getCostMetric() {
        return 0;
    }

    @Override
    public final IXQEQueryNode[] getChildrenOfType(int aType) {
        return this.getChildrenOfTypeOrdered(aType);
    }

    @Override
    public final IXQEQueryNode[] getChildrenOfTypes(int[] types) {
        ArrayList<IXQEQueryNode> childrenOfTypes = new ArrayList<IXQEQueryNode>();
        for (int type : types) {
            List<IXQEQueryNode> childrenOfType = this.getChildrenOfTypeOrderedList(type);
            childrenOfTypes.addAll(childrenOfType);
        }
        return childrenOfTypes.toArray(new XQEQueryNode[childrenOfTypes.size()]);
    }

    @Override
    public IXQEQueryNode[] getChildrenOfTypesOrdered(int[] types) {
        ArrayList<IXQEQueryNode> childrenOfTypes = new ArrayList<IXQEQueryNode>();
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            if (!ArrayUtils.contains((int[])types, (int)child.getNodeType())) continue;
            childrenOfTypes.add(child);
        }
        return childrenOfTypes.toArray(new XQEBaseQueryNode[childrenOfTypes.size()]);
    }

    @Override
    public final IXQEQueryNode[] getChildrenOfCategory(int category) {
        ArrayList<IXQEQueryNode> nodeList = new ArrayList<IXQEQueryNode>();
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            if (child.getNodeType() != category && !child.isOfCategory(category)) continue;
            nodeList.add(child);
        }
        IXQEQueryNode[] finalNodeArray = new XQEBaseQueryNode[nodeList.size()];
        finalNodeArray = nodeList.toArray(finalNodeArray);
        return finalNodeArray;
    }

    @Override
    public final List<IXQEQueryNode> getDescendantsOfCategory(int category, boolean includeSelf) {
        return this.getDescendantsOfCategoryOrdered(category, includeSelf);
    }

    @Override
    public final IXQEQueryNode getFirstDescendantOfCategory(int category, boolean includeSelf) {
        if (includeSelf && this.isOfCategory(category)) {
            return this;
        }
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            IXQEQueryNode aNode = ((XQEBaseQueryNode)child).getFirstDescendantOfCategory(category, true);
            if (aNode == null) continue;
            return aNode;
        }
        return null;
    }

    @Override
    public final List<IXQEQueryNode> getDescendantsOfCategoryOrdered(int category, boolean includeSelf) {
        ArrayList<IXQEQueryNode> descendantsOfCategoryOrdered = new ArrayList<IXQEQueryNode>();
        this.getDescendantsOfCategoryOrdered(descendantsOfCategoryOrdered, category, includeSelf);
        return descendantsOfCategoryOrdered;
    }

    private void getDescendantsOfCategoryOrdered(List<IXQEQueryNode> descendants, int category, boolean includeSelf) {
        if (includeSelf && this.isOfCategory(category)) {
            descendants.add(this);
        }
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            ((XQEBaseQueryNode)child).getDescendantsOfCategoryOrdered(descendants, category, true);
        }
    }

    @Override
    public final IXQEQueryNode getAncestorOfType(int aType) {
        IXQEQueryNode parent;
        for (parent = this.mParent; parent != null && parent.getNodeType() != aType; parent = parent.getParent()) {
        }
        return parent;
    }

    public final IXQEQueryNode getAncestorOfType(int[] types) {
        IXQEQueryNode parent;
        for (parent = this.mParent; parent != null && !ArrayUtils.contains((int[])types, (int)parent.getNodeType()); parent = parent.getParent()) {
        }
        return parent;
    }

    @Override
    public final IXQEQueryNode[] getAncestorsOfType(int aType) {
        ArrayList<IXQEQueryNode> ancestorsOfType = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getNodeType() != aType) continue;
            ancestorsOfType.add(parent);
        }
        return ancestorsOfType.toArray(new XQEBaseQueryNode[ancestorsOfType.size()]);
    }

    @Override
    public final IXQEQueryNode[] getAncestorsOfTypes(int[] types) {
        ArrayList<IXQEQueryNode> ancestorsOfTypes = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!ArrayUtils.contains((int[])types, (int)parent.getNodeType())) continue;
            ancestorsOfTypes.add(parent);
        }
        return ancestorsOfTypes.toArray(new XQEBaseQueryNode[ancestorsOfTypes.size()]);
    }

    @Override
    public boolean isWithinScope(int ancestorType, int anchorType) {
        for (IXQEQueryNode parent = this.mParent; parent != null && parent.getNodeType() != anchorType; parent = parent.getParent()) {
            if (parent.getNodeType() != ancestorType) continue;
            return true;
        }
        return false;
    }

    @Override
    public final IXQEQueryNode[] getAncestorsOfCategory(int category) {
        ArrayList<IXQEQueryNode> ancestorsOfCategory = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode parent = this.mParent; parent != null; parent = parent.getParent()) {
            if (!parent.isOfCategory(category)) continue;
            ancestorsOfCategory.add(parent);
        }
        return ancestorsOfCategory.toArray(new XQEBaseQueryNode[ancestorsOfCategory.size()]);
    }

    @Override
    public final IXQEQueryNode[] getAncestorsOfCategories(int[] categories) {
        ArrayList<IXQEQueryNode> ancestorsOfCategories = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode parent = this.mParent; parent != null; parent = parent.getParent()) {
            if (!parent.isOfCategories(categories)) continue;
            ancestorsOfCategories.add(parent);
        }
        return ancestorsOfCategories.toArray(new XQEBaseQueryNode[0]);
    }

    @Override
    public int[] getRequiredCategoriesForChildAtIndex(int index) {
        return new int[0];
    }

    @Override
    public final int getPositionOfChild(IXQEQueryNode child) {
        return this.mChildren.indexOf(child);
    }

    @Override
    public final int getSubtreeIndexForDescendant(IXQEQueryNode descendant) {
        IXQEQueryNode child = descendant;
        for (IXQEQueryNode parent = descendant.getParent(); parent != null; parent = parent.getParent()) {
            if (parent == this) {
                return parent.getPositionOfChild(child);
            }
            child = parent;
        }
        return -1;
    }

    @Override
    public Map<String, Object> getProperties() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPropertyValue(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getPropertyValue(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeProperty(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean getBooleanPropertyValue(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer getIntegerPropertyValue(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float getFloatPropertyValue(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double getDoublePropertyValue(String key) {
        throw new UnsupportedOperationException();
    }

    public XQENodeIndex getNodeIndex() {
        return this.environment.getNodeIndex();
    }

    @Override
    public void setNodeIndex(XQENodeIndex index) {
    }

    @Override
    public String getPropertyValueAsXML(String propertyName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int isValidPlannedQuery() {
        int status = -1;
        XQEBaseQueryNode node = null;
        for (int i = 0; i < this.getNumberChildren() && status == -1; ++i) {
            node = (XQEBaseQueryNode)this.getChild(i);
            status = node.isValidPlannedQuery();
        }
        if (status != -1) {
            return status;
        }
        if (node == null) {
            status = this.mId;
        }
        if (status == -1 && !this.validateChildCategories()) {
            status = this.mId;
        }
        return status;
    }

    @Override
    public void copyContentTo(IXQENodeFactory nodeFactory, IXQEQueryNode node) {
        this.copyLineageToNode(node);
    }

    @Override
    public void resolveValueOfQueryNodeProperties(Map<IXQEQueryNode, IXQEQueryNode> map) {
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            child.resolveValueOfQueryNodeProperties(map);
        }
    }

    public void deserialize(String expression) {
    }

    public String serialize() {
        return null;
    }

    public void dumpProperties(XQETrace trace) {
    }

    @Override
    public final void dump(XQETrace trace) {
        this.dump(trace, true);
    }

    @Override
    public void dump(XQETrace trace, boolean includeNodeID) {
        Integer nodeID = -1;
        if (includeNodeID) {
            nodeID = this.mId;
        }
        trace.beginElement(this.getNodeTypeName(), nodeID);
        this.dumpProperties(trace);
        this.dumpExtraInfo(trace);
        for (IXQEQueryNode child : this.getChildList()) {
            child.dump(trace, includeNodeID);
        }
        trace.endElement();
    }

    @Override
    public String dumpToString() {
        if (this.getId() != null) {
            return this.dumpToString(true);
        }
        return this.dumpToString(false);
    }

    @Override
    public String dumpToString(boolean includeNodeID) {
        XQETrace trace = new XQETrace();
        trace.setNodeIDGenerator(new XQEIDGenerator());
        trace.setTraceLevelAll();
        trace.setIndentString(" ");
        StringWriter stringWriter = new StringWriter();
        trace.addStream(stringWriter);
        this.dump(trace, includeNodeID);
        return stringWriter.toString();
    }

    public void dumpExtraInfo(XQETrace trace) {
    }

    @Override
    public void writeFormattedXML(XMLWriter writer) {
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            child.writeFormattedXML(writer);
        }
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            child.dumpFormattedXMLQuery(trace);
        }
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            child.writeFormattedText(buffer);
        }
    }

    @Override
    public void writeFormattedText() {
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            child.writeFormattedText();
        }
    }

    @Override
    public boolean isOfCategory(int category) {
        return false;
    }

    @Override
    public boolean isOfCategories(int[] categories) {
        for (int category : categories) {
            if (!this.isOfCategory(category)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOfTypes(int[] types) {
        for (int type : types) {
            if (this.getNodeType() != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isParentOf(IXQEQueryNode node) {
        return node.getParent() == this;
    }

    @Override
    public boolean isParentOfTypes(int[] types) {
        IXQEQueryNode parent = this.getParent();
        if (parent != null) {
            int parentType = parent.getNodeType();
            for (int type : types) {
                if (parentType != type) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAncestor(IXQEQueryNode ancestor) {
        if (ancestor == null) {
            return false;
        }
        boolean isDescendant = false;
        IXQEQueryNode parent = this.mParent;
        while (parent != null) {
            if (parent == ancestor) {
                isDescendant = true;
                break;
            }
            parent = ((XQEBaseQueryNode)parent).mParent;
        }
        return isDescendant;
    }

    public boolean isAncestor(IXQEQueryNode ancestor, int anchorType) {
        if (ancestor == null) {
            return false;
        }
        boolean isDescendant = false;
        for (IXQEQueryNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent == ancestor) {
                isDescendant = true;
                break;
            }
            if (parent.getNodeType() == anchorType) break;
        }
        return isDescendant;
    }

    @Override
    public final boolean isDescendantOfNodeInSubtree(IXQEQueryNode ancestor, int subTreeIndex) {
        IXQEQueryNode child = this;
        for (IXQEQueryNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent == ancestor) {
                return parent.getPositionOfChild(child) == subTreeIndex;
            }
            child = parent;
        }
        return false;
    }

    @Override
    public boolean isDescendantOfChildAtIndexForNodeOfType(int type, int childIndex, boolean checkAllAncestors) {
        return this.getParentWhereDescendantOfChildAtIndexForNodeOfType(type, childIndex, checkAllAncestors) != null;
    }

    @Override
    public boolean isDescendantOfChildAtIndexForNodeOfCategory(int category, int childIndex, boolean checkAllAncestors) {
        IXQEQueryNode child = this;
        for (IXQEQueryNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.isOfCategory(category)) {
                if (parent.getPositionOfChild(child) == childIndex) {
                    return true;
                }
                if (!checkAllAncestors) {
                    return false;
                }
            }
            child = parent;
        }
        return false;
    }

    @Override
    public IXQEQueryNode getParentWhereDescendantOfChildAtIndexForNodeOfType(int type, int childIndex, boolean checkAllAncestors) {
        IXQEQueryNode child = this;
        for (IXQEQueryNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getNodeType() == type) {
                if (parent.getPositionOfChild(child) == childIndex) {
                    return parent;
                }
                if (!checkAllAncestors) {
                    return null;
                }
            }
            child = parent;
        }
        return null;
    }

    @Override
    public IXQEQueryNode getAncestorOfTypes(int[] ancestorType) {
        if (this.mParent != null) {
            for (int type : ancestorType) {
                if (this.mParent.getNodeType() != type) continue;
                return this.mParent;
            }
            return this.mParent.getAncestorOfTypes(ancestorType);
        }
        return null;
    }

    @Override
    public IXQEQueryNode getAncestorOfCategory(int category) {
        if (this.mParent != null) {
            if (this.mParent.isOfCategory(category)) {
                return this.mParent;
            }
            return this.mParent.getAncestorOfCategory(category);
        }
        return null;
    }

    @Override
    public IXQEQueryNode getAncestorOfCategories(int[] categories) {
        if (this.mParent != null) {
            if (this.mParent.isOfCategories(categories)) {
                return this.mParent;
            }
            return this.mParent.getAncestorOfCategories(categories);
        }
        return null;
    }

    @Override
    public final void addChildNonIndexed(IXQEQueryNode node) {
        this.ensureNodeHasNotBeenDeleted(STRING_ADD, node);
        this.mChildren.add(node);
        node.setParent(this);
    }

    @Override
    public IXQEQueryNode detachFirstChild() {
        return this.detachChild(0);
    }

    @Override
    public IXQEQueryNode detachSecondChild() {
        return this.detachChild(1);
    }

    @Override
    public final void detachChildrenExceptAtPosition(int position) {
        if (this.getNumberChildren() == 0) {
            return;
        }
        if (position < 0 || position >= this.getNumberChildren()) {
            this.detachChildren();
            return;
        }
        IXQEQueryNode node = this.detachChild(position);
        this.detachChildren();
        this.addChild(node);
    }

    @Override
    public final void detachChildrenExceptFirst() {
        this.detachChildrenExceptAtPosition(0);
    }

    @Override
    public final void detachChildren() {
        XQETrace traceObj = this.environment.getTrace();
        boolean trace = traceObj.isEnable(256);
        if (trace) {
            traceObj.beginElement(STRING_DELETE_NODES, -1);
            traceObj.attribute(STRING_PARENT, this.mId);
        }
        for (IXQEQueryNode child : this.getChildList()) {
            if (trace) {
                traceObj.beginElement(STRING_DELETE, child.getId());
                traceObj.attribute(STRING_PARENT, this.mId);
            }
            child.removeFromIndex();
            ((XQEBaseQueryNode)child).addToListOfDetachedNodes();
            ((XQEBaseQueryNode)child).addLineageTarget(this, true);
            ((XQEBaseQueryNode)child).setNodeChanged(true);
            child.setParent(null);
            if (!trace) continue;
            traceObj.endElement();
        }
        this.mChildren.clear();
        if (trace) {
            traceObj.endElement();
        }
        this.setTreeHasBeenModified();
    }

    @Override
    public IXQEQueryNode detach() {
        if (this.getParent() != null) {
            this.getParent().detachChild(this);
        } else {
            this.removeFromIndex();
            this.addToListOfDetachedNodes();
        }
        return this;
    }

    @Override
    public final IXQEQueryNode detachChild(IXQEQueryNode node) {
        return this.detachChild(node, true);
    }

    private IXQEQueryNode detachChild(IXQEQueryNode node, boolean transferLineage) {
        int currentPosition;
        XQETrace traceObj = this.environment.getTrace();
        boolean trace = traceObj.isEnable(256);
        if (trace) {
            traceObj.beginElement(STRING_DELETE, node.getId());
            traceObj.attribute(STRING_PARENT, this.mId);
        }
        if ((currentPosition = this.mChildren.indexOf(node)) >= 0) {
            this.mChildren.remove(currentPosition);
            node.removeFromIndex();
            ((XQEBaseQueryNode)node).addToListOfDetachedNodes();
            if (transferLineage) {
                ((XQEBaseQueryNode)node).addLineageTarget(this, true);
            }
            node.setParent(null);
            this.setNodeChanged(true);
        }
        if (trace) {
            traceObj.endElement();
        }
        this.setTreeHasBeenModified();
        if (currentPosition >= 0) {
            return node;
        }
        return null;
    }

    @Override
    public final IXQEQueryNode detachChild(int index) {
        return this.detachChild(this.getChild(index));
    }

    protected void moveChildrenToNode(IXQEQueryNode target, int position) {
        if (this.mChildren.isEmpty()) {
            this.transferLineageToNode(this.getParent());
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            ((XQEBaseQueryNode)target).addChildForInternalUseOnly(this.mChildren.get(i), false, position);
            this.copyLineageToNode(this.mChildren.get(i));
        }
        this.mChildren.clear();
    }

    @Override
    public final IXQEQueryNode extract() {
        XQETrace traceObj = this.environment.getTrace();
        boolean trace = traceObj.isEnable(256);
        if (trace) {
            traceObj.beginElement(STRING_COLLAPSE, this.mId);
        }
        if (this.getParent() != null) {
            this.establishLineageTransferForExtractedNode(this.getParent());
            this.moveChildrenToNode(this.getParent(), this.getParent().getPositionOfChild(this));
            ((XQEBaseQueryNode)this.getParent()).detachChild(this, false);
        }
        this.addToListOfDetachedNodes();
        if (trace) {
            traceObj.endElement();
        }
        this.setTreeHasBeenModified();
        return this;
    }

    protected void establishLineageTransferForExtractedNode(IXQEQueryNode targetNode) {
    }

    @Override
    public final void addChild(IXQEQueryNode node) {
        XQETrace traceObj = this.environment.getTrace();
        boolean trace = traceObj.isEnable(256);
        if (trace) {
            traceObj.beginElement(STRING_ADD, node.getId());
            traceObj.attribute("parentId", this.mId);
        }
        this.ensureNodeHasNotBeenDeleted(STRING_ADD, node);
        ((XQEBaseQueryNode)node).removeFromListOfDetachedNodes();
        this.mChildren.add(node);
        node.setParent(this);
        if (this.isInNodeIndex()) {
            node.addToIndex();
        }
        if (trace) {
            traceObj.endElement();
        }
        this.setTreeHasBeenModified();
        this.setNodeChanged(true);
    }

    @Override
    public final void addChild(IXQEQueryNode node, int position) {
        boolean trace;
        XQETrace traceObj = this.environment.getTrace();
        boolean bl = trace = traceObj != null && traceObj.isEnable(256);
        if (trace) {
            traceObj.beginElement(STRING_ADD, node.getId());
            traceObj.attribute(STRING_PARENT, this.mId);
            traceObj.attribute(STRING_POSITION, position);
        }
        if (position <= 0) {
            this.mChildren.add(0, node);
        } else if (position >= this.mChildren.size()) {
            this.mChildren.add(node);
        } else {
            this.mChildren.add(position, node);
        }
        this.setNodeChanged(true);
        this.ensureNodeHasNotBeenDeleted(STRING_ADD, node);
        ((XQEBaseQueryNode)node).removeFromListOfDetachedNodes();
        node.setParent(this);
        if (this.isInNodeIndex()) {
            node.addToIndex();
        }
        this.setTreeHasBeenModified();
        if (trace) {
            traceObj.endElement();
        }
    }

    @Override
    public final void addChildBeforeNode(IXQEQueryNode newNode, IXQEQueryNode node) {
        this.addChild(newNode, this.getPositionOfChild(node));
    }

    @Override
    public final void addChildAfterNode(IXQEQueryNode newNode, IXQEQueryNode node) {
        this.addChild(newNode, this.getPositionOfChild(node) + 1);
    }

    @Override
    public final void addChildren(IXQEQueryNode[] nodes, int position) {
        XQETrace traceObj = this.environment.getTrace();
        boolean trace = traceObj.isEnable(256);
        if (trace) {
            traceObj.beginElement("addNodes", -1);
            traceObj.attribute(STRING_PARENT, this.mId);
            traceObj.attribute(STRING_POSITION, position);
        }
        for (int idx = nodes.length - 1; idx >= 0; --idx) {
            this.addChild(nodes[idx], position);
        }
        if (trace) {
            traceObj.endElement();
        }
        this.setTreeHasBeenModified();
    }

    @Override
    public final void setChild(IXQEQueryNode node) {
        XQETrace traceObj = this.environment.getTrace();
        boolean trace = traceObj.isEnable(256);
        if (trace) {
            traceObj.beginElement(STRING_SET, -1);
            traceObj.attribute(STRING_PARENT, this.mId);
        }
        this.ensureNodeHasNotBeenDeleted(STRING_SET, node);
        this.detachChildren();
        this.addChild(node);
        if (trace) {
            traceObj.endElement();
        }
        this.setTreeHasBeenModified();
    }

    @Override
    public final void setParent(IXQEQueryNode node) {
        this.ensureNodeHasNotBeenDeleted("setParent", node);
        if (node != null) {
            ((XQEBaseQueryNode)node).removeFromListOfDetachedNodes();
        }
        this.mParent = node;
        this.setTreeHasBeenModified();
    }

    private void removeChild(IXQEQueryNode child) {
        int currentPosition = this.mChildren.indexOf(child);
        if (currentPosition >= 0) {
            this.mChildren.remove(currentPosition);
            child.setParent(null);
            this.setNodeChanged(true);
        }
    }

    protected void setIsDeleted() {
        this.mDeleted = true;
    }

    protected boolean getIsDeleted() {
        return this.mDeleted;
    }

    @Override
    public final IXQEQueryNode exchangeChildNode(IXQEQueryNode oldChild, IXQEQueryNode newChild) {
        IXQEQueryNode node = this.exchangeChildNode(oldChild, newChild, false);
        return node;
    }

    @Override
    public final IXQEQueryNode exchange(IXQEQueryNode newNode, boolean transferDescendants) {
        IXQEQueryNode node = this.getParent().exchangeChildNode(this, newNode, transferDescendants);
        return node;
    }

    @Override
    public final IXQEQueryNode exchange(IXQEQueryNode newNode) {
        IXQEQueryNode node = this.getParent().exchangeChildNode(this, newNode, false);
        return node;
    }

    @Override
    public final IXQEQueryNode exchangeChildNode(IXQEQueryNode oldChild, IXQEQueryNode newChild, boolean transferDescendants) {
        XQETrace traceObj = this.environment.getTrace();
        boolean trace = traceObj.isEnable(256);
        if (trace) {
            traceObj.beginElement(STRING_REPLACE, oldChild.getId());
            traceObj.attribute(STRING_NEW, newChild.getId());
            traceObj.attribute(STRING_PARENT, this.mId);
            traceObj.attribute(STRING_TRANSFER_DESCENDANTS, transferDescendants);
        }
        this.ensureNodeHasNotBeenDeleted(STRING_REPLACE, newChild);
        int position = this.getPositionOfChild(oldChild);
        if (position >= 0) {
            ((XQEBaseQueryNode)oldChild).copyLineageToNode(newChild);
            if (transferDescendants) {
                ((XQEBaseQueryNode)oldChild).transferChildrenToNode(newChild, false);
            } else {
                ((XQEBaseQueryNode)oldChild).establishLineageTransferForExtractedNode(this);
            }
            this.detachChild(oldChild, false);
            ((XQEBaseQueryNode)oldChild).addToListOfDetachedNodes();
            this.addChild(newChild, position);
        }
        if (trace) {
            traceObj.endElement();
        }
        this.setTreeHasBeenModified();
        if (position >= 0) {
            return oldChild;
        }
        return null;
    }

    private void transferChildrenToNode(IXQEQueryNode node, boolean addToIndex) {
        for (int i = 0; i < this.mChildren.size(); ++i) {
            ((XQEBaseQueryNode)node).addChildForInternalUseOnly(this.mChildren.get(i), addToIndex, -1);
        }
        this.mChildren.clear();
    }

    protected void addChildForInternalUseOnly(IXQEQueryNode node, boolean addToIndex, int position) {
        if (position == -1) {
            this.mChildren.add(node);
        } else {
            this.mChildren.add(position, node);
        }
        node.setParent(this);
        if (addToIndex) {
            node.addToIndex();
        }
        this.setNodeChanged(true);
    }

    protected void addChildForParsersOnly(IXQEQueryNode child, int position) {
        if (position < this.getNumberChildren()) {
            this.mChildren.set(position, child);
        } else {
            int d = position - this.getNumberChildren();
            for (int j = 0; j < d; ++j) {
                this.mChildren.add(null);
            }
            this.mChildren.add(child);
        }
    }

    @Override
    public final void move(IXQEQueryNode newParent) {
        this.move(newParent, -1);
    }

    @Override
    public final void move(IXQEQueryNode newParent, int position) {
        XQETrace traceObj = this.environment.getTrace();
        boolean trace = traceObj.isEnable(256);
        if (trace) {
            traceObj.beginElement(STRING_MOVE, this.mId);
            traceObj.attribute(STRING_PARENT, this.mId);
            traceObj.attribute(STRING_NEW_PARENT, newParent.getId());
        }
        ((XQEBaseQueryNode)this.mParent).removeChild(this);
        if (position >= 0) {
            newParent.addChild(this, position);
        } else {
            newParent.addChild(this);
        }
        if (trace) {
            traceObj.endElement();
        }
        this.setTreeHasBeenModified();
    }

    @Override
    public void moveNodeOnly(IXQEQueryNode newParent) {
        this.moveNodeOnly(newParent, -1);
    }

    @Override
    public void moveNodeOnly(IXQEQueryNode newParent, int position) {
        XQETrace traceObj = this.environment.getTrace();
        boolean trace = traceObj.isEnable(256);
        if (trace) {
            traceObj.beginElement(STRING_MOVE, this.mId);
            traceObj.attribute(STRING_PARENT, this.mId);
            traceObj.attribute(STRING_NEW_PARENT, newParent.getId());
        }
        IXQEQueryNode parent = this.mParent;
        if (this.mParent != null) {
            this.mParent.detachChild(this);
            this.transferChildrenToNode(parent, true);
        }
        if (position >= 0) {
            newParent.addChild(this, position);
        } else {
            newParent.addChild(this);
        }
        if (trace) {
            traceObj.endElement();
        }
        this.setTreeHasBeenModified();
    }

    protected void insertChild(IXQEQueryNode child, IXQEQueryNode newNode) {
        int position = this.getPositionOfChild(child);
        this.addChildForInternalUseOnly(newNode, true, position);
        this.mChildren.remove(child);
    }

    @Override
    public final void insertParent(IXQEQueryNode newParent) {
        XQETrace traceObj = this.environment.getTrace();
        boolean trace = traceObj.isEnable(256);
        if (trace) {
            traceObj.beginElement("insert", newParent.getId());
            if (this.mParent != null) {
                traceObj.attribute(STRING_PARENT, this.mParent.getId());
                traceObj.attribute(STRING_POSITION, this.mParent.getPositionOfChild(this));
            }
        }
        if (this.mParent != null) {
            ((XQEBaseQueryNode)this.mParent).insertChild(this, newParent);
        }
        boolean addToIndex = this.mParent == null;
        ((XQEBaseQueryNode)newParent).addChildForInternalUseOnly(this, addToIndex, -1);
        if (trace) {
            traceObj.endElement();
        }
        this.setTreeHasBeenModified();
    }

    protected void ensureNodeHasNotBeenDeleted(String methodName, IXQEQueryNode node) {
        if (node != null && ((XQEBaseQueryNode)node).getIsDeleted()) {
            String id = node.getId() != null ? node.getId().toString() : "no identifier assigned";
            throw new XQEQueryNodeException(CoreMessageKeys.AST_DeletedNodeReused, methodName, id);
        }
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node) {
        boolean status = false;
        if (this == node) {
            return true;
        }
        if (this.getNodeType() == node.getNodeType() && this.mChildren.size() == node.getNumberChildren() && this.isSameSyntaxProperties(node)) {
            status = true;
            for (int idx = 0; status && idx < this.getNumberChildren(); ++idx) {
                status = ((XQEBaseQueryNode)this.getChild(idx)).isSameExpression(node.getChild(idx));
            }
        }
        return status;
    }

    public boolean isSameSyntaxProperties(IXQEQueryNode node) {
        String[] compareSyntaxProperties;
        String[] syntaxProperties = this.getSyntaxProperties();
        if (syntaxProperties.length != (compareSyntaxProperties = node.getSyntaxProperties()).length) {
            return false;
        }
        for (String syntaxProperty : syntaxProperties) {
            Object prop = this.getPropertyValue(syntaxProperty);
            Object compareProp = node.getPropertyValue(syntaxProperty);
            if (prop == null && compareProp != null) {
                return false;
            }
            if (prop != null && compareProp == null) {
                return false;
            }
            if (prop == null || compareProp == null || prop.equals(compareProp)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[0];
    }

    @Override
    public boolean validateChildCategories() {
        return false;
    }

    @Override
    public int getMinimumNumberChildren() {
        return 0;
    }

    public void setLineage(IXQEQueryNode lineage) {
    }

    public void setLineage(IXQEQueryNode[] lineage) {
    }

    public void setLineage(ArrayList<IXQEQueryNode> lineage) {
    }

    @Override
    public void deleteLineage(boolean deleteChildLineage) {
    }

    @Override
    public void initializeLineage(IXQEQueryNode target) {
    }

    @Override
    public void dumpLineage(XQETrace trace) {
    }

    @Override
    public void throwInternalError(String errMsg) {
        throw new XQERuntimeException(CoreMessageKeys.PLN_XQEQueryNodeInternalError, this.getNodeTypeName(), (Object)errMsg);
    }

    public void throwInternalError(String errMsg, Throwable cause) {
        throw new XQERuntimeException(CoreMessageKeys.PLN_XQEQueryNodeInternalError, cause, (Object)this.getNodeTypeName(), (Object)errMsg);
    }

    public String[] getChecksumProperties() {
        return this.getSyntaxProperties();
    }

    @Override
    public boolean isQueryNode() {
        return true;
    }

    @Override
    public void setAsRootOfSubtree(String name, String subTreeType) {
    }

    @Override
    public void setAsRootOfSubtree(String name, String subTreeType, int leafNodeDelimiter) {
    }

    @Override
    public void removeSubtreeDefinition() {
    }

    @Override
    public boolean getIsRootOfSubtree() {
        return false;
    }

    @Override
    public void addToIndex() {
        XQENodeIndex index = this.environment.getNodeIndex();
        if (index != null) {
            for (int i = 0; i < this.mChildren.size(); ++i) {
                IXQEQueryNode child = this.mChildren.get(i);
                child.addToIndex();
            }
            index.addNode(this);
        }
        this.setTreeHasBeenModified();
    }

    @Override
    public void removeFromIndex() {
        for (int i = 0; i < this.mChildren.size(); ++i) {
            IXQEQueryNode child = this.mChildren.get(i);
            child.removeFromIndex();
        }
        this.environment.getNodeIndex().removeNode(this);
    }

    protected void setTreeHasBeenModified() {
        if (this.environment != null) {
            this.environment.setTreeHasBeenModified();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getNodeTypeName());
        sb.append("(nodeId=");
        sb.append(this.getId());
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void throwOnInvalidChildCategories() {
        if (!this.validateChildCategories()) {
            throw new XQERuntimeException(CoreMessageKeys.PLN_InvalidChildNode, this.getNodeTypeName());
        }
    }

    @Override
    public void nodeVisited() {
        XQETrace traceObj = this.environment.getTrace();
        if (!traceObj.isEnable(256)) {
            return;
        }
        traceObj.beginElement(STRING_VISITED, -1);
        traceObj.attribute(STRING_NODE_ID, this.getId());
        traceObj.endElement();
    }

    protected void copyLineageToNode(IXQEQueryNode target) {
    }

    protected void transferLineageToNode(IXQEQueryNode target) {
    }

    protected void transferLineageToNode(IXQEQueryNode target, boolean includeSelf) {
    }

    protected void addToListOfDetachedNodes() {
    }

    protected void removeFromListOfDetachedNodes() {
    }

    public void cleanUpNode() {
        this.setIsDeleted();
        this.setParent(null);
    }

    protected void addLineageTarget(IXQEQueryNode node, boolean includeChildren) {
    }

    protected ArrayList<IXQEQueryNode> getLineageTargets() {
        return null;
    }

    @Override
    public ArrayList<IXQEQueryNode> getLineage() {
        return null;
    }

    public PlanningEnvironment getPlanningEnvironment() {
        return this.environment;
    }

    @Override
    public boolean hasDescendantOfType(int type, boolean includeSelf) {
        return this.getNodeIndex().hasDescendantOfType(this, type, includeSelf);
    }

    @Override
    public boolean hasChildOfType(int type) {
        return this.getFirstChildByType(type) != null;
    }

    public boolean hasValidChildren() {
        return this.mHasValidChildren;
    }

    public void setHasValidChildren(boolean value) {
        this.mHasValidChildren = value;
    }

    public boolean isNodeChanged() {
        return this.mNodeChanged;
    }

    public void setNodeChanged(boolean value) {
        this.mNodeChanged = value;
    }

    @Override
    public void saveNodeType(int type) {
        this.mNodeType = type;
    }
}

