/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.ast;

import com.ibm.cognos.aurora.core.expert.ast.IXQENodeFactory;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.IXQEReference;
import com.ibm.cognos.aurora.core.expert.ast.XQEBaseQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQEIDGenerator;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeIndex;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeTypeEnum;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import java.util.HashMap;
import java.util.Map;

public abstract class XQENodeFactory
implements IXQENodeFactory {
    protected XQEIDGenerator mIdGenerator;
    protected PlanningEnvironment environment;
    protected XQETrace mTrace;

    @Override
    public final IXQEQueryNode createNode(int type) {
        IXQEQueryNode node = this.componentCreateNode(type);
        if (node != null) {
            node.setNodeId(this.mIdGenerator.getNextID());
            node.setPlanningEnvironment(this.environment);
            node.saveNodeType(type);
        }
        return node;
    }

    public final IXQEQueryNode createXNode(int type) {
        IXQEQueryNode node = this.componentCreateNode(type);
        if (node != null) {
            node.setNodeId(this.mIdGenerator.getNextID());
            node.setPlanningEnvironment(this.environment);
            node.saveNodeType(type);
        }
        return node;
    }

    protected abstract IXQEQueryNode componentCreateNode(int var1);

    @Override
    public IXQEQueryNode createNode(String name) {
        return null;
    }

    @Override
    public IXQEQueryNode createNode(int type, IXQEQueryNode node) {
        IXQEQueryNode result = this.createNode(type);
        if (node != null) {
            ((XQEBaseQueryNode)node).copyLineageToNode(result);
        }
        return result;
    }

    @Override
    public XQENodeIndex getNodeIndex() {
        return this.environment.getNodeIndex();
    }

    @Override
    public void setPlanningEnvironment(PlanningEnvironment theEnvironment) {
        this.environment = theEnvironment;
    }

    @Override
    public void setTrace(XQETrace trace) {
        this.mTrace = trace;
    }

    @Override
    public IXQEQueryNode deepCopyNode(IXQEQueryNode node) {
        HashMap<IXQEQueryNode, IXQEQueryNode> mapOriginalToNew = new HashMap<IXQEQueryNode, IXQEQueryNode>();
        IXQEQueryNode copiedNode = this.deepCopyNode(node, mapOriginalToNew);
        for (Map.Entry origToNewEntry : mapOriginalToNew.entrySet()) {
            IXQEQueryNode newDef;
            IXQEQueryNode originalRef = (IXQEQueryNode)origToNewEntry.getKey();
            if (!(originalRef instanceof IXQEReference) || (newDef = (IXQEQueryNode)mapOriginalToNew.get(((IXQEReference)originalRef).getDefinition())) == null) continue;
            ((IXQEReference)origToNewEntry.getValue()).setDefinition(newDef);
        }
        copiedNode.resolveValueOfQueryNodeProperties(mapOriginalToNew);
        return copiedNode;
    }

    private IXQEQueryNode deepCopyNode(IXQEQueryNode node, Map<IXQEQueryNode, IXQEQueryNode> mapOriginalToNew) {
        IXQEQueryNode copiedNode = this.copyNode(node);
        IXQEQueryNode newChild = null;
        mapOriginalToNew.put(node, copiedNode);
        for (IXQEQueryNode child : node.getChildren()) {
            newChild = this.deepCopyNode(child, mapOriginalToNew);
            copiedNode.addChildNonIndexed(newChild);
        }
        return copiedNode;
    }

    public IXQEQueryNode deepCopyNodeNonIndexed(IXQEQueryNode node) {
        IXQEQueryNode copiedNode = this.copyNode(node);
        copiedNode.setNodeIndex(null);
        IXQEQueryNode newChild = null;
        for (IXQEQueryNode child : node.getChildren()) {
            newChild = this.deepCopyNodeNonIndexed(child);
            copiedNode.addChildNonIndexed(newChild);
        }
        return copiedNode;
    }

    public IXQEQueryNode deepCopyNodeIndexed(IXQEQueryNode node) {
        IXQEQueryNode copiedNode = this.copyNode(node);
        copiedNode.addToIndex();
        for (IXQEQueryNode child : node.getChildren()) {
            IXQEQueryNode newChild = this.deepCopyNodeIndexed(child);
            copiedNode.addChild(newChild);
        }
        return copiedNode;
    }

    @Override
    public IXQEQueryNode copyNode(IXQEQueryNode node) {
        IXQEQueryNode copiedNode = this.createNode(node.getType());
        if (node.getType() == copiedNode.getType()) {
            node.copyContentTo(this, copiedNode);
        }
        return copiedNode;
    }

    @Override
    public String getNodeTypeName(int type) {
        return XQENodeTypeEnum.getNodeTypeName(type);
    }

    @Override
    public abstract int getLowNodeID();

    @Override
    public abstract int getHighNodeID();

    public void setNodeIDGenerator(XQEIDGenerator idGenerator) {
        this.mIdGenerator = idGenerator;
    }

    public XQEIDGenerator getNodeIdGenerator() {
        return this.mIdGenerator;
    }

    public int getLastNodeIDGenerated() {
        return this.mIdGenerator.getLastID();
    }
}

