/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.ast;

import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQEQueryNode;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class XQENodeIndex {
    public static final int QUERYTREE_UNLIMITED_DEPTH = 0;
    private static final String NODE_ID = "id";
    private static final int NODE_LIMIT_FOR_DISTANCE_SEARCH = 50;
    private Map<Integer, Map<Integer, IXQEQueryNode>> mTypeMap = new HashMap<Integer, Map<Integer, IXQEQueryNode>>();
    private Map<Integer, IXQEQueryNode> mIdMap = new HashMap<Integer, IXQEQueryNode>();

    public void removeNode(IXQEQueryNode node) {
        Integer id = node.getId();
        Integer type = node.getTypeObject();
        this.mIdMap.remove(id);
        Map<Integer, IXQEQueryNode> map = this.mTypeMap.get(type);
        if (map != null) {
            map.remove(id);
        }
    }

    public void addNode(IXQEQueryNode node) {
        Integer id = node.getId();
        Integer type = node.getTypeObject();
        this.mIdMap.put(id, node);
        Map<Integer, IXQEQueryNode> map = this.mTypeMap.get(type);
        if (map == null) {
            map = new HashMap<Integer, IXQEQueryNode>();
            this.mTypeMap.put(type, map);
        }
        map.put(id, node);
    }

    public IXQEQueryNode getNodeByID(Integer id) {
        return this.mIdMap.get(id);
    }

    public IXQEQueryNode[] getNodesByType(int nodeType) {
        IXQEQueryNode[] nodeArray = null;
        Collection<IXQEQueryNode> nodes = this.getNodesCollectionByType(nodeType);
        if (nodes == null) {
            nodeArray = new IXQEQueryNode[]{};
        } else {
            nodeArray = new IXQEQueryNode[nodes.size()];
            nodeArray = nodes.toArray(nodeArray);
        }
        return nodeArray;
    }

    private Collection<IXQEQueryNode> getNodesCollectionByType(int nodeType) {
        Integer key = nodeType;
        Map<Integer, IXQEQueryNode> map = this.mTypeMap.get(key);
        if (map != null) {
            return map.values();
        }
        return null;
    }

    public boolean hasNodeOfType(Integer nodeType) {
        Map<Integer, IXQEQueryNode> map = this.mTypeMap.get(nodeType);
        if (map != null) {
            return !map.isEmpty();
        }
        return false;
    }

    public List<IXQEQueryNode> getDescendantsOfTypeByDistance(int nodeType, IXQEQueryNode ancestor, int maxSearchDistance) {
        if (ancestor == null) {
            return null;
        }
        Collection<IXQEQueryNode> nodesForType = this.getNodesCollectionByType(nodeType);
        if (nodesForType == null) {
            return new LinkedList<IXQEQueryNode>();
        }
        if (maxSearchDistance == 0 && nodesForType.size() >= 50) {
            return ancestor.getDescendantsOfTypeOrdered(nodeType, false);
        }
        return this.filterOutByAncestorAndDistance(ancestor, nodesForType, maxSearchDistance);
    }

    private List<IXQEQueryNode> filterOutByAncestorAndDistance(IXQEQueryNode ancestor, Collection<IXQEQueryNode> inputNodes, int maxSearchDistance) {
        ArrayList<IXQEQueryNode> filteredList = new ArrayList<IXQEQueryNode>();
        block0: for (IXQEQueryNode node : inputNodes) {
            IXQEQueryNode parent = node.getParent();
            int j = 1;
            while (parent != null) {
                if (parent == ancestor) {
                    filteredList.add(node);
                    continue block0;
                }
                parent = parent.getParent();
                if (maxSearchDistance > 0 && j == maxSearchDistance) continue block0;
                ++j;
            }
        }
        return filteredList;
    }

    public List<IXQEQueryNode> getDescendantsOfType(int nodeType, IXQEQueryNode ancestor) {
        return this.getDescendantsOfTypeByDistance(nodeType, ancestor, 0);
    }

    public XQEQueryNode[] getChildrenOfType(int nodeType, XQEQueryNode parent) {
        List<IXQEQueryNode> childrenOfType = this.getDescendantsOfTypeByDistance(nodeType, parent, 1);
        return childrenOfType.toArray(new XQEQueryNode[childrenOfType.size()]);
    }

    public boolean nodeTypeIsDescendantOfOtherNode(int childNodeType, XQEQueryNode ancestor) {
        if (ancestor == null) {
            return false;
        }
        boolean exists = false;
        for (IXQEQueryNode child : this.getNodesByType(childNodeType)) {
            if (!child.isAncestor(ancestor)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public int[] getNumberOfChildrenOfNodesOfTypeInSubtree(int nodeType, XQEQueryNode subtreeRoot) {
        if (subtreeRoot == null) {
            return null;
        }
        IXQEQueryNode[] nodeArray = this.getNodesByType(nodeType);
        int[] numChildren = new int[nodeArray.length];
        int i = 0;
        for (IXQEQueryNode node : this.getNodesByType(nodeType)) {
            numChildren[i++] = node.isAncestor(subtreeRoot) ? node.getNumberChildren() : 0;
        }
        return numChildren;
    }

    public int[] getNumberOfNodesOfTypeInSubtreesOfType(int nodeType, int subtreeRootType) {
        return this.getNumberOfNodesOfTypeInSubtrees(nodeType, this.getNodesByType(subtreeRootType));
    }

    public int[] getNumberOfNodesOfTypeInSubtrees(int nodeType, IXQEQueryNode[] roots) {
        if (roots == null) {
            return null;
        }
        int[] numberOfNodes = new int[roots.length];
        IXQEQueryNode[] nodes = this.getNodesByType(nodeType);
        for (int j = 0; j < roots.length; ++j) {
            numberOfNodes[j] = 0;
        }
        block1: for (int i = 0; i < nodes.length; ++i) {
            for (int j = 0; j < roots.length; ++j) {
                if (!nodes[j].isAncestor(roots[j])) continue;
                int n = j;
                numberOfNodes[n] = numberOfNodes[n] + 1;
                continue block1;
            }
        }
        return numberOfNodes;
    }

    public IXQEQueryNode validateIndex(IXQEQueryNode node, XQETrace trace) {
        IXQEQueryNode invalidNode1 = this.validateNodesAreInIndex(node, trace);
        IXQEQueryNode invalidNode2 = this.validateNodesAreInTree(node, trace);
        if (invalidNode1 == null) {
            invalidNode1 = invalidNode2;
        }
        return invalidNode1;
    }

    private IXQEQueryNode validateNodesAreInIndex(IXQEQueryNode node, XQETrace trace) {
        IXQEQueryNode invalidNode = null;
        IXQEQueryNode[] children = node.getChildren();
        if (children != null) {
            for (IXQEQueryNode child : children) {
                invalidNode = this.validateNodesAreInIndex(child, trace);
            }
        }
        boolean hasKey = this.mIdMap.containsKey(node.getId());
        if (node.getParent() != null && !hasKey) {
            trace.beginElement("nodeInTreeNotInIndex", -1);
            trace.attribute(NODE_ID, node.getId());
            trace.endElement();
            invalidNode = node;
        }
        return invalidNode;
    }

    private IXQEQueryNode validateNodesAreInTree(IXQEQueryNode root, XQETrace trace) {
        IXQEQueryNode invalidNode = null;
        for (IXQEQueryNode node : this.mIdMap.values()) {
            if (node.isAncestor(root)) continue;
            trace.beginElement("nodeInIndexNotInTree", -1);
            trace.attribute(NODE_ID, node.getId());
            trace.endElement();
            invalidNode = node;
        }
        return invalidNode;
    }

    public int getNumberOfNodesInIndex() {
        return this.mIdMap.size();
    }

    public boolean hasDescendantOfType(IXQEQueryNode node, int type, boolean includeSelf) {
        if (node == null) {
            return false;
        }
        if (includeSelf && node.getType() == type) {
            return true;
        }
        Collection<IXQEQueryNode> nodesForType = this.getNodesCollectionByType(type);
        if (nodesForType == null || nodesForType.size() == 0) {
            return false;
        }
        if (nodesForType.size() >= 50) {
            return node.getFirstDescendantOfTypeOrdered(type, includeSelf) != null;
        }
        for (IXQEQueryNode n : nodesForType) {
            for (IXQEQueryNode parent = n.getParent(); parent != null; parent = parent.getParent()) {
                if (parent != node) continue;
                return true;
            }
        }
        return false;
    }
}

