/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.config;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.core.expert.config.ConfigFileException;
import com.ibm.cognos.aurora.core.expert.config.ServiceEnumeration;
import com.ibm.cognos.aurora.core.expert.config.XQEConfigurationEvent;
import com.ibm.cognos.aurora.core.expert.config.XQEConfigurationListener;
import com.ibm.cognos.aurora.core.expert.config.XQESubConfiguration;
import com.ibm.cognos.aurora.core.pool.XQEIntegerPool;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;

public class XQEConfiguration {
    public static final String XML_VALUE_TRUE = "true";
    public static final String XML_VALUE_FALSE = "false";
    public static final int MS_IN_SECOND = 1000;
    public static final int S_IN_MINUTE = 60;
    public static final String XML_ATTRIBUTE_NAME = "[@name]";
    public static final String XML_ATTRIBUTE_PRIORITY = "[@priority]";
    public static final String XML_ATTRIBUTE_VALUE = "[@value]";
    public static final String XML_ATTRIBUTE_ENABLED = "[@enabled]";
    public static final String CACHE_QUERY_PLANS_KEY = "general.cacheQueryPlans";
    public static final String LOCK_WAIT_TIME = "general.lockWaitTimeInMs[@value]";
    public static final long LOCK_WAIT_TIME_DEFAULT = 1000L;
    public static final String EXCESSIVE_COLLECTION_THRESHOLD = "general.gc.excessiveCollectionThreshold";
    public static final double EXCESSIVE_COLLECTION_THRESHOLD_DEFAULT = 0.6;
    public static final String EXCESSIVE_COLLECTION_CHECK_PERIOD = "general.gc.excessiveCollectionCheckPeriod";
    public static final long EXCESSIVE_COLLECTION_CHECK_PERIOD_DEFAULT = 60000L;
    public static final String EXCESSIVE_COLLECTION_SYSTEM_DUMP_ENABLED = "general.gc.excessiveCollectionSystemDumpEnabled";
    public static final boolean EXCESSIVE_COLLECTION_SYSTEM_DUMP_ENABLED_DEFAULT = false;
    private static final String DOT = ".";
    private static final String DIAGNOSTIC_PROPERTY = "diagnostics";
    private static final String ELEMENT_LEVEL = "[@level]";
    private static final String ELEMENT_LOGGER = "[@appender]";
    private static final String DEFAULT_LEVEL_PROPERTY = "diagnostics[@level]";
    private static final String DEFAULT_APPENDER_PROPERTY = "diagnostics[@appender]";
    private static final String DIAG_ENABLED_PROPERTY = "diagnostics[@enabled]";
    private static final String APPENDER_ELEMENT = ".appenders.appender";
    private static final String COMPONENT_ELEMENT = ".components.component";
    public static final String CONFIG_DIRECTORY_KEY = "aurora.xqe_config_dir";
    public static final String BIN_DIRECTORY_KEY = "aurora.xqe_bin_dir";
    public static final String TEMP_DIRECTORY_KEY = "aurora.temp_dir";
    public static final String DATA_DIRECTORY_KEY = "aurora.data_dir";
    public static final String LOGS_DIRECTORY_KEY = "aurora.logs_dir";
    public static final String DEFAULT_TEMP_DIRECTORY = "../temp";
    public static final String DEFAULT_CONFIGURATION_DIRECTORY = "../configuration";
    public static final String DEFAULT_DATA_DIRECTORY = "../data";
    public static final String DEFAULT_BIN_DIRECTORY = ".";
    public static final String DEFAULT_LOGS_DIRECTORY = "../logs";
    public static final String SERVICE_SUBFOLDER_NAME = "aurora";
    public static final String CUSTOM_CONFIG_FILE_SUFFIX = ".config.custom.xml";
    public static final String CONFIG_FILE_SUFFIX = ".config.xml";
    public static final String DEV_CONFIG_FILE_SUFFIX = ".config.dev.xml";
    private static final String LOG_CONFIG_FILE_NAME = "xqe.diagnosticlogging.xml";
    private final String configDirectory;
    private final String xqeTempDirectory;
    private final String xqeDataDirectory;
    private static String xqeLogsDirectory;
    private final CompositeConfiguration configuration;
    private final XMLConfiguration dominantConfiguration;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XMLConfiguration loadConfigFromFile(String fullFileName) {
        XMLConfiguration xmlConfiguration;
        try {
            this.rwLock.writeLock().lock();
            try {
                File cFile = new File(fullFileName);
                if (!cFile.exists()) {
                    throw new ConfigFileException(CoreMessageKeys.CFG_FileExistError, null, fullFileName);
                }
                xmlConfiguration = new XMLConfiguration(fullFileName);
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }
        catch (ConfigurationException e) {
            throw new ConfigFileException(CoreMessageKeys.CFG_FileLoadError, (Throwable)e, fullFileName);
        }
        return xmlConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XQEConfiguration(Properties properties) {
        ServiceEnumeration serviceType = ServiceEnumeration.AURORA;
        this.configDirectory = properties.getProperty(CONFIG_DIRECTORY_KEY, DEFAULT_CONFIGURATION_DIRECTORY);
        String tempDirectory = properties.getProperty(TEMP_DIRECTORY_KEY, DEFAULT_TEMP_DIRECTORY);
        String dataDirectory = properties.getProperty(DATA_DIRECTORY_KEY, DEFAULT_DATA_DIRECTORY);
        this.xqeTempDirectory = tempDirectory + File.separator + SERVICE_SUBFOLDER_NAME;
        File f = new File(this.xqeTempDirectory);
        f.mkdirs();
        this.xqeDataDirectory = dataDirectory + File.separator + SERVICE_SUBFOLDER_NAME;
        f = new File(this.xqeDataDirectory);
        f.mkdirs();
        this.configuration = new CompositeConfiguration();
        String typeName = serviceType.name().toLowerCase();
        StringBuffer defaultConfig = new StringBuffer(this.configDirectory);
        defaultConfig.append(File.separator);
        defaultConfig.append(typeName);
        defaultConfig.append(CONFIG_FILE_SUFFIX);
        File defaultConfigFile = new File(defaultConfig.toString());
        StringBuffer customizedConfig = new StringBuffer(this.configDirectory);
        customizedConfig.append(File.separator);
        customizedConfig.append(serviceType.name().toLowerCase());
        customizedConfig.append(CUSTOM_CONFIG_FILE_SUFFIX);
        File customizedConfigFile = new File(customizedConfig.toString());
        StringBuffer devConfig = new StringBuffer(this.configDirectory);
        devConfig.append(File.separator);
        devConfig.append(typeName);
        devConfig.append(DEV_CONFIG_FILE_SUFFIX);
        File devConfigFile = new File(devConfig.toString());
        StringBuffer logSettings = new StringBuffer(this.configDirectory);
        logSettings.append(File.separator);
        logSettings.append(LOG_CONFIG_FILE_NAME);
        File logConfigFile = new File(logSettings.toString());
        if (devConfigFile.exists()) {
            XMLConfiguration devConfiguration = this.loadConfigFromFile(devConfig.toString());
            this.configuration.addConfiguration((Configuration)devConfiguration);
        }
        if (logConfigFile.exists()) {
            XMLConfiguration loggingConfiguration = this.loadConfigFromFile(logSettings.toString());
            this.configuration.addConfiguration((Configuration)loggingConfiguration);
        }
        if (customizedConfigFile.exists()) {
            XMLConfiguration custConfiguration = this.loadConfigFromFile(customizedConfig.toString());
            this.configuration.addConfiguration((Configuration)custConfiguration);
        }
        if (!defaultConfigFile.exists()) {
            throw new ConfigFileException(CoreMessageKeys.CFG_FileExistError, null, defaultConfig.toString());
        }
        XMLConfiguration defaultConfiguration = this.loadConfigFromFile(defaultConfig.toString());
        this.configuration.addConfiguration((Configuration)defaultConfiguration);
        if (this.configuration.getNumberOfConfigurations() < 2) {
            XMLConfiguration dummyConfiguration = new XMLConfiguration();
            this.configuration.addConfiguration((Configuration)dummyConfiguration);
        }
        this.dominantConfiguration = (XMLConfiguration)this.configuration.getConfiguration(0);
        String xqeConfiguration = "XQEConfiguration.";
        Properties systemProperties = System.getProperties();
        for (Object property : systemProperties.keySet()) {
            String key = (String)property;
            if (!key.startsWith("XQEConfiguration.")) continue;
            String xqeConfigurationKey = key.substring("XQEConfiguration.".length());
            this.dominantConfiguration.setProperty(xqeConfigurationKey, (Object)System.getProperty(key));
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (xqeLogsDirectory == null) {
                String logsDirectory = properties.getProperty(LOGS_DIRECTORY_KEY, DEFAULT_LOGS_DIRECTORY);
                logsDirectory = this.configuration.getString("general.logsFolder[@value]", logsDirectory);
                xqeLogsDirectory = logsDirectory + File.separator + SERVICE_SUBFOLDER_NAME;
                f = new File(xqeLogsDirectory);
                f.mkdirs();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XQESubConfiguration getChildren(String key) {
        XQESubConfiguration subConfiguration = null;
        this.rwLock.readLock().lock();
        try {
            List children = null;
            for (int i = 0; i < this.configuration.getNumberOfConfigurations(); ++i) {
                XMLConfiguration xmlcfg;
                Configuration cfg = this.configuration.getConfiguration(i);
                if (!(cfg instanceof XMLConfiguration) || (children = (xmlcfg = (XMLConfiguration)cfg).configurationsAt(key)) == null || children.isEmpty()) continue;
                XQESubConfiguration xQESubConfiguration = subConfiguration = new XQESubConfiguration(ServiceEnumeration.AURORA, children);
                return xQESubConfiguration;
            }
            if (children != null) {
                XQESubConfiguration xQESubConfiguration = new XQESubConfiguration(ServiceEnumeration.AURORA, children);
                return xQESubConfiguration;
            }
            XQESubConfiguration xQESubConfiguration = null;
            return xQESubConfiguration;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public XQESubConfiguration getConfigForXQEODPComponent(String providerName) {
        XQESubConfiguration config = this.getChildren("components.component");
        while (config.hasNext()) {
            config.next();
            String name = config.getString(XML_ATTRIBUTE_NAME, "");
            if (!name.equals(providerName)) continue;
            XQESubConfiguration subConfig = config.getChildren(".");
            return subConfig;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBooleanProperty(String key, boolean defaultValue) {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.configuration.getBoolean(key, defaultValue);
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getBooleanProperty(String key, Boolean defaultValue) {
        this.rwLock.readLock().lock();
        try {
            Boolean bl = this.configuration.getBoolean(key, defaultValue);
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByteProperty(String key, byte defaultValue) {
        this.rwLock.readLock().lock();
        try {
            byte by = this.configuration.getByte(key, defaultValue);
            return by;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Byte getByteProperty(String key, Byte defaultValue) {
        this.rwLock.readLock().lock();
        try {
            Byte by = this.configuration.getByte(key, defaultValue);
            return by;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShortProperty(String key, short defaultValue) {
        this.rwLock.readLock().lock();
        try {
            short s = this.configuration.getShort(key, defaultValue);
            return s;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Short getShortProperty(String key, Short defaultValue) {
        this.rwLock.readLock().lock();
        try {
            Short s = this.configuration.getShort(key, defaultValue);
            return s;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntProperty(String key, int defaultValue) {
        this.rwLock.readLock().lock();
        try {
            int n = this.configuration.getInt(key, defaultValue);
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getIntegerProperty(String key, Integer defaultValue) {
        this.rwLock.readLock().lock();
        try {
            Integer n = this.configuration.getInteger(key, defaultValue);
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLongProperty(String key, long defaultValue) {
        this.rwLock.readLock().lock();
        try {
            long l = this.configuration.getLong(key, defaultValue);
            return l;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getLongProperty(String key, Long defaultValue) {
        this.rwLock.readLock().lock();
        try {
            Long l = this.configuration.getLong(key, defaultValue);
            return l;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloatProperty(String key, float defaultValue) {
        this.rwLock.readLock().lock();
        try {
            float f = this.configuration.getFloat(key, defaultValue);
            return f;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Float getFloatProperty(String key, Float defaultValue) {
        this.rwLock.readLock().lock();
        try {
            Float f = this.configuration.getFloat(key, defaultValue);
            return f;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDoubleProperty(String key, double defaultValue) {
        this.rwLock.readLock().lock();
        try {
            double d = this.configuration.getDouble(key, defaultValue);
            return d;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getDoubleProperty(String key, Double defaultValue) {
        this.rwLock.readLock().lock();
        try {
            Double d = this.configuration.getDouble(key, defaultValue);
            return d;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringProperty(String key, String defaultValue) {
        this.rwLock.readLock().lock();
        try {
            String string = this.configuration.getString(key, defaultValue);
            return string;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPropertyValue(String key, Object defaultValue) {
        this.rwLock.readLock().lock();
        try {
            Object value = this.configuration.getProperty(key);
            if (null == value) {
                Object object = defaultValue;
                return object;
            }
            Object object = value;
            return object;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void load(Properties properties) {
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            Object key = entry.getKey();
            if (!(key instanceof String)) continue;
            this.setProperty((String)key, (String)entry.getValue());
        }
    }

    private void setPropertyValue(String key, Object value) {
        this.rwLock.writeLock().lock();
        try {
            this.dominantConfiguration.setProperty(key, value);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void setProperty(String key, int value) {
        this.setPropertyValue(key, XQEIntegerPool.getInteger(value));
    }

    public void setProperty(String key, double value) {
        this.setPropertyValue(key, new Double(value));
    }

    public void setProperty(String key, String value) {
        this.setPropertyValue(key, value);
    }

    public String getXqeDataDirectory() {
        return this.xqeDataDirectory;
    }

    public String getXqeTempDirectory() {
        return this.xqeTempDirectory;
    }

    public String getXqeLogsDirectory() {
        return xqeLogsDirectory;
    }

    public String getConfigDirectory() {
        return this.configDirectory;
    }

    public void saveConfiguration() throws ConfigFileException {
        try {
            this.dominantConfiguration.save();
        }
        catch (ConfigurationException e) {
            throw new ConfigFileException(CoreMessageKeys.CFG_FileSaveError, (Throwable)e, this.dominantConfiguration.getFileName());
        }
    }

    public void registerConfigurationListener(XQEConfigurationListener l) {
        if (this.configuration == null) {
            return;
        }
        ConfigurationChangeListener listener = new ConfigurationChangeListener(l);
        this.dominantConfiguration.addConfigurationListener((ConfigurationListener)listener);
    }

    protected void lockWrite() {
        this.rwLock.writeLock().lock();
    }

    protected void releaseWrite() {
        this.rwLock.writeLock().unlock();
    }

    protected void lockRead() {
        this.rwLock.readLock().lock();
    }

    protected void releaseRead() {
        this.rwLock.readLock().unlock();
    }

    public void clearPropertyValue(String key) {
        this.rwLock.writeLock().lock();
        try {
            this.configuration.clearProperty(key);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public AbstractConfiguration getConfigForTesting() {
        return this.configuration;
    }

    public boolean isCryptoEnabled() {
        return true;
    }

    public boolean isFunctionPoolEnabled() {
        return true;
    }

    public boolean isXQEAgentEnabled() {
        return true;
    }

    public void update(Properties properties) {
        this.update(properties, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Properties properties, boolean override) {
        this.rwLock.writeLock().lock();
        try {
            for (Map.Entry<Object, Object> property : properties.entrySet()) {
                String key = null;
                String value = null;
                if (property.getKey() instanceof String) {
                    key = (String)property.getKey();
                }
                if (property.getValue() instanceof String) {
                    value = (String)property.getValue();
                }
                if (!override && this.dominantConfiguration.containsKey(key)) continue;
                this.dominantConfiguration.setProperty(key, (Object)value);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public boolean isParallelismEnabled() {
        return this.getBooleanProperty("queryExecution.parallelism[@enabled]", false);
    }

    public int getMaxDop() {
        int dop = this.getIntProperty("queryExecution.parallelism.maxDop[@value]", 1);
        if (dop == 0) {
            dop = Runtime.getRuntime().availableProcessors();
        }
        return dop;
    }

    public XQESubConfiguration getLoggingAppenders() {
        String key = "diagnostics." + (Object)((Object)ServiceEnumeration.AURORA) + APPENDER_ELEMENT;
        return this.getChildren(key);
    }

    public String getDefaultLoggingLevel() {
        return this.getStringProperty(DEFAULT_LEVEL_PROPERTY, "error");
    }

    public String getDefaultLoggingAppender() {
        return this.getStringProperty(DEFAULT_APPENDER_PROPERTY, "file");
    }

    public boolean getLoggingEnabled() {
        return this.getBooleanProperty(DIAG_ENABLED_PROPERTY, true);
    }

    public XQESubConfiguration getLoggingComponents() {
        String key = "diagnostics." + (Object)((Object)ServiceEnumeration.AURORA) + COMPONENT_ELEMENT;
        return this.getChildren(key);
    }

    private class ConfigurationChangeListener
    implements ConfigurationListener {
        XQEConfigurationListener listener = null;

        public ConfigurationChangeListener(XQEConfigurationListener l) {
            this.listener = l;
        }

        public void configurationChanged(ConfigurationEvent event) {
            XQEConfigurationEvent e = new XQEConfigurationEvent(event);
            this.listener.configurationChanged(e);
        }
    }
}

