/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.config;

import com.ibm.cognos.aurora.core.expert.config.ServiceEnumeration;
import com.ibm.cognos.aurora.core.expert.config.XQEConfiguration;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class XQEConfigurationManager {
    private static XQEConfigurationManager instance;
    private final Map<ServiceEnumeration, XQEConfiguration> configs;
    private final ReadWriteLock configLock = new ReentrantReadWriteLock();

    private XQEConfigurationManager() {
        this.configs = new TreeMap<ServiceEnumeration, XQEConfiguration>();
    }

    public static synchronized XQEConfigurationManager getInstance() {
        if (instance == null) {
            instance = new XQEConfigurationManager();
        }
        return instance;
    }

    public XQEConfiguration getConfiguration(ServiceEnumeration serviceType) {
        this.configLock.readLock().lock();
        try {
            XQEConfiguration xQEConfiguration = this.configs.get((Object)serviceType);
            return xQEConfiguration;
        }
        finally {
            this.configLock.readLock().unlock();
        }
    }

    public void add(ServiceEnumeration serviceType, XQEConfiguration newConfig) {
        this.configLock.writeLock().lock();
        try {
            if (newConfig == null) {
                throw new RuntimeException("The configuration object cannot be null");
            }
            this.configs.put(serviceType, newConfig);
        }
        finally {
            this.configLock.writeLock().unlock();
        }
    }

    public void remove(ServiceEnumeration serviceType) {
        this.configLock.writeLock().lock();
        try {
            this.configs.remove((Object)serviceType);
        }
        finally {
            this.configLock.writeLock().unlock();
        }
    }
}

