/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.config;

import com.ibm.cognos.aurora.core.expert.config.ServiceEnumeration;
import com.ibm.cognos.aurora.core.expert.config.XQEConfiguration;
import com.ibm.cognos.aurora.core.expert.config.XQEConfigurationManager;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;

public class XQESubConfiguration {
    protected List<?> mSubTrees;
    protected Iterator<?> mIterator;
    HierarchicalConfiguration mConfiguration;
    XQEConfiguration mParentConfiguration;
    private final ServiceEnumeration mServiceType;

    public XQESubConfiguration(ServiceEnumeration type, List<?> subTrees) {
        this.mServiceType = type;
        this.mSubTrees = subTrees;
        this.mIterator = this.mSubTrees.iterator();
        this.mParentConfiguration = XQEConfigurationManager.getInstance().getConfiguration(type);
    }

    public boolean hasNext() {
        return this.mIterator.hasNext();
    }

    public void next() {
        this.mConfiguration = (HierarchicalConfiguration)this.mIterator.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key, String defaultValue) {
        String value;
        this.mParentConfiguration.lockRead();
        try {
            value = this.mConfiguration.getString(key, defaultValue);
        }
        finally {
            this.mParentConfiguration.releaseRead();
        }
        return value;
    }

    public String[] getStringArray(String key) {
        String[] value;
        this.mParentConfiguration.lockRead();
        try {
            value = this.mConfiguration.getStringArray(key);
        }
        finally {
            this.mParentConfiguration.releaseRead();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getBoolean(String key, Boolean defaultValue) {
        Boolean value;
        this.mParentConfiguration.lockRead();
        try {
            value = this.mConfiguration.getBoolean(key, defaultValue);
        }
        finally {
            this.mParentConfiguration.releaseRead();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getInteger(String key, Integer defaultValue) {
        Integer value;
        this.mParentConfiguration.lockRead();
        try {
            value = this.mConfiguration.getInteger(key, defaultValue);
        }
        finally {
            this.mParentConfiguration.releaseRead();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getLong(String key, Long defaultValue) {
        Long value;
        this.mParentConfiguration.lockRead();
        try {
            value = this.mConfiguration.getLong(key, defaultValue);
        }
        finally {
            this.mParentConfiguration.releaseRead();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getDouble(String key, Double defaultValue) {
        Double value;
        this.mParentConfiguration.lockRead();
        try {
            value = this.mConfiguration.getDouble(key, defaultValue);
        }
        finally {
            this.mParentConfiguration.releaseRead();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XQESubConfiguration getChildren(String key) {
        this.mParentConfiguration.lockRead();
        XQESubConfiguration subConfiguration = null;
        try {
            List children = this.mConfiguration.configurationsAt(key);
            if (children != null) {
                subConfiguration = new XQESubConfiguration(this.mServiceType, children);
            }
        }
        finally {
            this.mParentConfiguration.releaseRead();
        }
        return subConfiguration;
    }

    public void index(int index) {
        this.mConfiguration = (HierarchicalConfiguration)this.mSubTrees.get(index);
    }

    public int getSize() {
        return this.mSubTrees.size();
    }

    public void setString(String key, String value) {
        this.mParentConfiguration.lockWrite();
        try {
            this.mConfiguration.setProperty(key, (Object)value);
        }
        finally {
            this.mParentConfiguration.releaseWrite();
        }
    }

    public void setInteger(String key, Integer value) {
        this.mParentConfiguration.lockWrite();
        try {
            this.mConfiguration.setProperty(key, (Object)value);
        }
        finally {
            this.mParentConfiguration.releaseWrite();
        }
    }

    public void setDouble(String key, Double value) {
        this.mParentConfiguration.lockWrite();
        try {
            this.mConfiguration.setProperty(key, (Object)value);
        }
        finally {
            this.mParentConfiguration.releaseWrite();
        }
    }
}

