/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.inference;

import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.inference.RulePass;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRuleLibrary;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractRuleLibraryManager {
    public static final int ALL_PASSES = -1;
    protected static final String STRING_PASS_NUMBER = "passNumber";
    protected static final String STRING_PASS = "pass";
    protected List<AbstractRuleLibrary> transformationLibraries;
    protected int mMaximumPassNumber = 0;
    protected RulePass transformsAllPasses = new RulePass();
    protected Map<Integer, RulePass> transformsByPass = new HashMap<Integer, RulePass>();
    protected Map<Integer, List<AbstractRuleLibrary>> passLibraries = new HashMap<Integer, List<AbstractRuleLibrary>>();
    protected boolean passLibraryMapPopulated;
    protected int mPassNumber = 0;
    protected List<AbstractRuleLibrary> mLibraryList = new ArrayList<AbstractRuleLibrary>();

    protected AbstractRuleLibraryManager() {
        this.loadTransformationLibraries();
        this.createIndexes();
        this.mergeIndexes();
        this.constructNodeTypeIndexes();
    }

    private void constructNodeTypeIndexes() {
        for (AbstractRuleLibrary library : this.transformationLibraries) {
            List<AbstractRule> transformations = library.getTransformations();
            for (AbstractRule transformation : transformations) {
                int[] passNumbers;
                int[] nodeTypes = transformation.getTypes();
                for (int passNumber : passNumbers = transformation.getPassNumbers()) {
                    RulePass passTransformations = this.getTransformations(passNumber);
                    if (transformations == null) continue;
                    for (int nodeType : nodeTypes) {
                        List<AbstractRule> passTransformationList = passTransformations.getTransformationsForNodeType(nodeType);
                        if (!passTransformationList.isEmpty()) continue;
                        passTransformations.createTransformationListForNodeType(XQEIntegerPool.getInteger(nodeType));
                    }
                }
            }
        }
    }

    private void mergeIndexes() {
        Set<Map.Entry<Integer, RulePass>> entrySetMap = this.transformsByPass.entrySet();
        for (Map.Entry<Integer, RulePass> anEntry : entrySetMap) {
            RulePass passTransformations;
            passTransformations.setContainsBottomUpTransformations((passTransformations = anEntry.getValue()).getContainsBottomUpTransformations() || this.transformsAllPasses.getContainsBottomUpTransformations());
            passTransformations.setContainsIndexedTransformations(passTransformations.getContainsIndexedTransformations() || this.transformsAllPasses.getContainsIndexedTransformations());
            passTransformations.setContainsTopDownTransformations(passTransformations.getContainsTopDownTransformations() || this.transformsAllPasses.getContainsTopDownTransformations());
            Map<Integer, List<AbstractRule>> transformationMap = passTransformations.getTransformationMap();
            transformationMap.putAll(this.transformsAllPasses.getTransformationMap());
        }
    }

    protected abstract void loadTransformationLibraries();

    public RulePass getTransformations(int passNumber) {
        return this.transformsByPass.get(XQEIntegerPool.getInteger(passNumber));
    }

    private void createIndexes() {
        for (AbstractRuleLibrary library : this.transformationLibraries) {
            this.createIndexesFromLibrary(library);
        }
    }

    public void dumpTransformations(XQETrace trace) {
        trace.beginElement("TransformationLibraryContents", -1);
        if (this.transformsByPass.size() > 0) {
            trace.beginElement("passSpecificTransformations", -1);
            trace.attribute("maximumPassNumber", this.mMaximumPassNumber);
            for (int i = 0; i <= this.mMaximumPassNumber; ++i) {
                Integer key = XQEIntegerPool.getInteger(i);
                RulePass passTransformations = this.transformsByPass.get(key);
                if (passTransformations == null) continue;
                trace.beginElement(STRING_PASS, -1);
                trace.attribute(STRING_PASS_NUMBER, i);
                trace.endElement();
            }
            trace.endElement();
        }
        trace.endElement();
    }

    private void createIndexesFromLibrary(AbstractRuleLibrary library) {
        List<AbstractRule> transformations = library.getTransformations();
        for (AbstractRule aTransformation : transformations) {
            this.indexByPass(aTransformation);
        }
    }

    private void indexByPass(AbstractRule aTransformation) {
        int[] passes;
        for (int pass : passes = aTransformation.getPassNumbers()) {
            Integer key = XQEIntegerPool.getInteger(pass);
            if (pass > this.mMaximumPassNumber) {
                this.mMaximumPassNumber = pass;
            }
            RulePass passTransformations = null;
            if (pass == -1) {
                passTransformations = this.transformsAllPasses;
            } else {
                passTransformations = this.transformsByPass.get(key);
                if (passTransformations == null) {
                    passTransformations = new RulePass();
                    this.transformsByPass.put(key, passTransformations);
                }
            }
            this.indexByType(aTransformation, passTransformations);
        }
    }

    private void indexByType(AbstractRule aTransformation, RulePass passTransformations) {
        int[] types;
        Map<Integer, List<AbstractRule>> transformationMap = passTransformations.getTransformationMap();
        List<AbstractRule> mapTransformationList = null;
        block5: for (int type : types = aTransformation.getTypes()) {
            Integer key = XQEIntegerPool.getInteger(type);
            mapTransformationList = transformationMap.get(key);
            if (mapTransformationList == null) {
                mapTransformationList = new ArrayList<AbstractRule>();
                transformationMap.put(key, mapTransformationList);
            }
            mapTransformationList.add(aTransformation);
            switch (aTransformation.getMode()) {
                case TOP_DOWN: {
                    passTransformations.setContainsTopDownTransformations(true);
                    continue block5;
                }
                case BOTTOM_UP: {
                    passTransformations.setContainsBottomUpTransformations(true);
                    continue block5;
                }
                case INDEXED: {
                    passTransformations.setContainsIndexedTransformations(true);
                    continue block5;
                }
                default: {
                    passTransformations.setContainsIndexedTransformations(true);
                }
            }
        }
    }

    public RulePass getTransformsAllPasses() {
        return this.transformsAllPasses;
    }

    public void dumpAllTransformations(XQETrace trace, PlanningEnvironment environment) {
        int maxPassNumber = this.getMaximumPassNumber();
        for (int i = 0; i < maxPassNumber; ++i) {
            this.dumpPassTransformations(trace, environment, i);
        }
    }

    private void dumpPassTransformations(XQETrace trace, PlanningEnvironment environment, int passNumber) {
        RulePass passTransformations = this.getTransformations(passNumber);
        for (Map.Entry<Integer, List<AbstractRule>> mapEntry : passTransformations.getTransformationMap().entrySet()) {
            trace.beginElement("node", -1);
            String nodeName = environment.getNodeFactory().getNodeTypeName(mapEntry.getKey());
            if (nodeName == null) {
                trace.attribute("id", mapEntry.getKey());
            } else {
                trace.attribute("name", nodeName);
            }
            for (AbstractRule transformation : mapEntry.getValue()) {
                transformation.dump(environment.getTrace());
            }
            trace.endElement();
        }
    }

    public List<AbstractRuleLibrary> getPassLibraryMap(int passNumber) {
        this.populatePassLibraryMap();
        Integer pass = new Integer(passNumber);
        return this.passLibraries.get(pass);
    }

    private void populatePassLibraryMap() {
        if (this.passLibraryMapPopulated) {
            return;
        }
        for (int passNumber = 0; passNumber <= this.getMaximumPassNumber(); ++passNumber) {
            HashSet<AbstractRuleLibrary> libraries = new HashSet<AbstractRuleLibrary>();
            RulePass passTransformations = this.getTransformations(passNumber);
            if (passTransformations == null) continue;
            Map<Integer, List<AbstractRule>> transformationMap = this.getTransformations(passNumber).getTransformationMap();
            Set<Map.Entry<Integer, List<AbstractRule>>> setOfTransformationList = transformationMap.entrySet();
            if (setOfTransformationList.size() == 0) {
                this.passLibraryMapPopulated = true;
                return;
            }
            for (Map.Entry<Integer, List<AbstractRule>> entry : setOfTransformationList) {
                List<AbstractRule> listOfTransformations = entry.getValue();
                if (listOfTransformations.size() == 0) continue;
                for (AbstractRule transformation : listOfTransformations) {
                    libraries.add(transformation.getTransformationLibrary());
                }
            }
            ArrayList<AbstractRuleLibrary> listOfLibraries = new ArrayList<AbstractRuleLibrary>();
            for (AbstractRuleLibrary library : libraries) {
                listOfLibraries.add(library);
            }
            this.passLibraries.put(passNumber, listOfLibraries);
        }
        this.passLibraryMapPopulated = true;
    }

    protected void addTransformationLibraryToList(AbstractRuleLibrary transformationLibrary) {
        if (transformationLibrary != null) {
            this.setMaximumPassNumber(transformationLibrary.getFinalPassNumber());
            this.addLibraryToList(transformationLibrary);
        }
    }

    protected void addLibraryToList(AbstractRuleLibrary transformationLibrary) {
        this.getLibraryList().add(transformationLibrary);
    }

    protected List<AbstractRuleLibrary> getLibraryList() {
        return this.mLibraryList;
    }

    protected void setMaximumPassNumber(int passNumber) {
        this.mPassNumber = Math.max(passNumber, this.mPassNumber);
    }

    public int getMaximumPassNumber() {
        return this.mPassNumber;
    }

    protected void addTransformationLibrariesToList(AbstractRuleLibrary library1, AbstractRuleLibrary library2) {
        int passNumber1 = library1.getFinalPassNumber();
        this.addLibraryToList(library1);
        int passNumber2 = library2.getFinalPassNumber();
        this.addLibraryToList(library2);
        this.setMaximumPassNumber(Math.max(passNumber1, passNumber2));
    }
}

