/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.inference;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeIndex;
import com.ibm.cognos.aurora.core.expert.bibusservice.RequestEnvironment;
import com.ibm.cognos.aurora.core.expert.config.ServiceEnumeration;
import com.ibm.cognos.aurora.core.expert.config.XQEConfiguration;
import com.ibm.cognos.aurora.core.expert.config.XQEConfigurationManager;
import com.ibm.cognos.aurora.core.expert.inference.AbstractRuleLibraryManager;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.inference.QTEEngineException;
import com.ibm.cognos.aurora.core.expert.inference.QueryEngine;
import com.ibm.cognos.aurora.core.expert.inference.RulePass;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRuleLibrary;
import com.ibm.cognos.aurora.core.expert.trace.TraceLogManager;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.pool.XQEIntegerPool;
import com.ibm.cognos.aurora.core.pool.XQEIntegerPoolForNodeType;
import com.ibm.cognos.aurora.core.util.Pair;
import com.ibm.cognos.aurora.core.xml.XMLWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;

public final class InferenceEngine {
    public static final int TRACE_QUERY_NODE_CHANGES = 256;
    public static final int TRACE_QUERY_EXECUTION = 512;
    public static final int TRACE_ITERATOR_PROFILING = 1024;
    public static final int TRACE_COMPLEX_NODE_PROPERTIES = 64;
    public static final int TRACE_RUNTREE = 128;
    public static final int TRACE_RUNTREE_EXECUTION = 2048;
    public static final int TRACE_QUERY_PLANNING = 1;
    public static final int TRACE_WHY_TRANSFORMATION_APPLIED = 2;
    public static final int TRACE_WHY_TRANSFORMATION_NOT_APPLIED = 4;
    public static final int TRACE_TREE_AFTER_TRANSFORMATION = 8;
    public static final Integer DUMMY_NODEID = -1;
    private static final String STRING_QUERY = "query";
    private static final String STRING_PASS = "pass";
    private static final String STRING_PASS_NUMBER = "passNumber";
    private static final String STRING_N_TRANSFORMS_APPLIED = "nTransformsApplied";
    public static final String STRING_NAME = "name";
    public static final String STRING_NODE_TYPE = "nodeType";
    private static final String STRING_CHECKSUM_FILE_NAME = "CheckSum-";
    private static final String STRING_XQE_RANDOMIZE_TRANSFORMATIONS = "_XQE_RANDOMIZE_TRANSFORMATIONS";
    private static final int DEFAULT_QUERY_NODE_MULTIPLIER_LIMIT = 0;
    private static final int DEFAULT_QUERY_PLANNING_TIME_LIMIT = 0;
    private static final ILogger logger = LoggerManager.getLogger("ATHENA.core.aurora_core");
    private Map<Integer, List<AbstractRule>> mNodesTransformedInCurrentPass;
    private final AbstractRuleLibraryManager libraryManager;

    public InferenceEngine(AbstractRuleLibraryManager libraryMgr) {
        this.libraryManager = libraryMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyTransformations(IXQEQueryNode root, PlanningEnvironment environment) throws QTEEngineException {
        this.initializeTransformationEnvironment(root, environment);
        environment.resetTreeHasBeenModified();
        boolean status = true;
        XQETrace trace = environment.getTrace();
        boolean queryTracing = this.isAnyTrackingEnabled(trace);
        if (queryTracing) {
            this.beginTracingQueryTransformations(environment, trace);
            this.traceInitialQuery(root, trace);
        }
        Writer planningTraceWriter = environment.getCurrentTraceWriter();
        try {
            if (this.libraryManager == null) {
                throw new IllegalStateException();
            }
            int maxPassNumber = this.libraryManager.getMaximumPassNumber();
            boolean calculatedMaximumNumberOfNodes = false;
            RulePass passTransformations = null;
            long startTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.AURORA);
            boolean logCheckSumBeforeEachPass = configuration.getBooleanProperty("queryPlanning.logCheckSumBeforeEachPass[@enabled]", false);
            for (int passNumber = 0; passNumber <= maxPassNumber; ++passNumber) {
                if (queryTracing) {
                    this.tracePassNumber(trace, passNumber, environment);
                }
                if (logCheckSumBeforeEachPass) {
                    String xqeLogsFolder = configuration.getXqeLogsDirectory();
                    StringBuffer checkSumFileName = new StringBuffer(xqeLogsFolder);
                    checkSumFileName.append(File.separator).append(STRING_CHECKSUM_FILE_NAME);
                    int magicNumber = 1000;
                    String sPassNumber = Integer.valueOf(1000 + passNumber).toString();
                    checkSumFileName.append(sPassNumber.substring(1));
                    checkSumFileName.append(".xml");
                    FileUtils.deleteQuietly((File)new File(checkSumFileName.toString()));
                    XMLWriter xmlWriter = InferenceEngine.createXMLWriterToFile(checkSumFileName.toString());
                    xmlWriter.flush();
                }
                int numTransformsAppliedPerPass = 0;
                trace.beginElement(1, STRING_PASS, -1);
                trace.attribute(1, STRING_PASS_NUMBER, passNumber);
                try {
                    passTransformations = this.libraryManager.getTransformations(passNumber);
                    if (passTransformations == null || !passTransformations.targetNodeExists(environment.getNodeIndex())) continue;
                    this.traceLibrariesAssociatedWithPass(trace, passNumber);
                    this.initializeListOfTransformedNodesInCurrentPass(environment);
                    int numTransformsAppliedPerIteration = -1;
                    int iteration = 0;
                    while (0 != numTransformsAppliedPerIteration) {
                        if (calculatedMaximumNumberOfNodes) {
                            this.checkThatMaximumNumberOfNodesNotExceeded(environment);
                        } else if (this.treeActuallyContainsNodes(environment)) {
                            calculatedMaximumNumberOfNodes = true;
                            environment.setMaximumNumberOfNodesInQueryTree(this.calculateMaximumNumberOfNodesInQueryTree(environment));
                        }
                        this.checkIfQueryPlanningLimitExceeded(environment, startTime);
                        trace.beginElement(1, "passIteration", -1);
                        trace.attribute(1, "iteration", iteration);
                        try {
                            numTransformsAppliedPerIteration = this.transformationIteration(passNumber, iteration, environment);
                            numTransformsAppliedPerPass += numTransformsAppliedPerIteration;
                        }
                        finally {
                            if ((trace.getTraceLevel() & 1) != 0) {
                                trace.property(1, STRING_N_TRANSFORMS_APPLIED, numTransformsAppliedPerIteration);
                                if (0 != numTransformsAppliedPerIteration) {
                                    trace.beginElement(STRING_QUERY, -1);
                                    root.dump(trace);
                                    trace.endElement();
                                }
                            }
                            trace.endElement(1);
                        }
                        ++iteration;
                    }
                    continue;
                }
                finally {
                    trace.property(1, STRING_N_TRANSFORMS_APPLIED, numTransformsAppliedPerPass);
                    trace.endElement(1);
                    trace.flush();
                    if (passTransformations == null) {
                        trace.deleteDeferredTraceStatements();
                    }
                }
            }
        }
        finally {
            if (planningTraceWriter != null) {
                this.setCurrentTraceWriter(trace, environment, planningTraceWriter);
            }
            if (queryTracing) {
                this.traceFinalQuery(root, trace);
                this.endTracingQueryTransformations(trace);
                if (!(QueryEngine.isRuntreeLoggingEnabled(trace) || QueryEngine.isExecutionLoggingEnabled(trace) || QueryEngine.isProfilingEnabled(trace))) {
                    TraceLogManager.getInstance().closeTrace(environment.getRequestEnvironment());
                }
            }
        }
        environment.releaseQueryLineage();
        return status;
    }

    private void loadRandomizeConfigurationSettings(PlanningEnvironment environment, XQEConfiguration configuration) {
        boolean randomizeTransforms = configuration.getBooleanProperty("queryPlanning.randomizeTransformations[@enabled]", false);
        Map<String, String> envVars = System.getenv();
        if (envVars.containsKey(STRING_XQE_RANDOMIZE_TRANSFORMATIONS) && envVars.get(STRING_XQE_RANDOMIZE_TRANSFORMATIONS).equalsIgnoreCase("Y") || randomizeTransforms) {
            environment.setRandomizeTransformations(true);
            RequestEnvironment reqEnv = environment.getRequestEnvironment();
            if (!reqEnv.isRandomSeedSet()) {
                int newRandomSeed = configuration.getIntProperty("queryPlanning.randomizeTransformations[@seed]", 0);
                if (newRandomSeed == 0) {
                    Random seedGenerator = new Random();
                    newRandomSeed = seedGenerator.nextInt();
                }
                reqEnv.setRandomSeed(newRandomSeed);
            }
            environment.setRandom(new Random(reqEnv.getRandomSeed()));
        } else {
            environment.setRandomizeTransformations(false);
        }
    }

    private void loadQueryPlanningConfigurationSettings(PlanningEnvironment environment, XQEConfiguration configuration) {
        if (!environment.getLoadingOfConfigurationInformation()) {
            return;
        }
        int queryPlanningTimeLimit = configuration.getIntProperty("queryPlanning.queryPlanningTimeLimit[@value]", 0);
        environment.setQueryPlanningTimeLimit(queryPlanningTimeLimit);
        int queryNodeMultiplierLimit = configuration.getIntProperty("queryPlanning.queryNodeMultiplierLimit[@value]", 0);
        environment.setQueryNodeMultiplierLimit(queryNodeMultiplierLimit);
        boolean enabled = configuration.getBooleanProperty("queryPlanning.checkTransformationAppliedTwice[@value]", false);
        if (enabled) {
            environment.setCheckTransformationAppliedTwiceToNodeInSamePass(0);
        } else {
            environment.setCheckTransformationAppliedTwiceToNodeInSamePass(1);
        }
    }

    private void loadConfigurationInformation(PlanningEnvironment environment) {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.AURORA);
        if (configuration == null) {
            return;
        }
        this.loadRandomizeConfigurationSettings(environment, configuration);
        this.loadQueryPlanningConfigurationSettings(environment, configuration);
    }

    private int transformationIteration(int passNumber, int iterationNumber, PlanningEnvironment environment) {
        int numTransformsApplied = 0;
        RulePass passTransformations = this.libraryManager.getTransformations(passNumber);
        if (passTransformations.getContainsTopDownTransformations()) {
            numTransformsApplied += this.applyTopDownTransformations(passTransformations, environment, iterationNumber);
        }
        if (passTransformations.getContainsBottomUpTransformations()) {
            numTransformsApplied += this.applyBottomUpTransformations(passTransformations, environment, iterationNumber);
        }
        if (passTransformations.getContainsIndexedTransformations()) {
            numTransformsApplied += this.applyIndexedTransformations(passTransformations, environment, iterationNumber);
        }
        return numTransformsApplied;
    }

    private int applyIndexedTransformations(RulePass passTransformations, PlanningEnvironment environment, int iterationNumber) {
        int numTransformsApplied = 0;
        if (passTransformations.getTransformationMap() == null) {
            return numTransformsApplied;
        }
        XQENodeIndex nodeIndex = environment.getNodeIndex();
        Iterator<Map.Entry<Integer, List<AbstractRule>>> transformIterator = null;
        transformIterator = environment.getRandomizeTransformations() ? this.randomizeTransformations(passTransformations.getTransformationMap(), environment) : passTransformations.getTransformationMap().entrySet().iterator();
        while (transformIterator.hasNext()) {
            Map.Entry<Integer, List<AbstractRule>> transformEntry = transformIterator.next();
            int key = transformEntry.getKey();
            IXQEQueryNode[] nodes = null;
            nodes = environment.getRandomizeTransformations() ? this.randomizeNodes(nodeIndex.getNodesByType(key), environment) : nodeIndex.getNodesByType(key);
            if (nodes == null) continue;
            for (IXQEQueryNode node : nodes) {
                if (nodeIndex.getNodeByID(node.getId()) == null || !this.applyApplicableTransformation(passTransformations, node, iterationNumber, AbstractRule.Mode.INDEXED, environment)) continue;
                ++numTransformsApplied;
                numTransformsApplied += this.applyLockedNodeTransformations(passTransformations, iterationNumber, environment);
            }
        }
        return numTransformsApplied;
    }

    private Iterator<Map.Entry<Integer, List<AbstractRule>>> randomizeTransformations(Map<Integer, List<AbstractRule>> transformationMap, PlanningEnvironment environment) {
        ArrayList<Map.Entry<Integer, List<AbstractRule>>> transformList = new ArrayList<Map.Entry<Integer, List<AbstractRule>>>(transformationMap.size());
        Iterator<Map.Entry<Integer, List<AbstractRule>>> transformIterator = transformationMap.entrySet().iterator();
        for (int i = 0; i < transformationMap.size(); ++i) {
            transformList.add(null);
        }
        while (transformIterator.hasNext()) {
            int index;
            do {
                if ((index = environment.getRandom().nextInt()) >= 0) continue;
                index = -index;
            } while (transformList.get(index %= transformationMap.size()) != null);
            transformList.set(index, transformIterator.next());
        }
        return transformList.iterator();
    }

    private IXQEQueryNode[] randomizeNodes(IXQEQueryNode[] nodes, PlanningEnvironment environment) {
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        IXQEQueryNode[] newNodes = new IXQEQueryNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            do {
                int index;
                if ((index = environment.getRandom().nextInt()) >= 0) continue;
                index = -index;
            } while (newNodes[index %= nodes.length] != null);
            newNodes[index] = nodes[i];
        }
        return newNodes;
    }

    private int applyTopDownTransformations(RulePass passTransformations, PlanningEnvironment environment, int iterationNumber) {
        if (passTransformations.getTransformationMap() == null) {
            return 0;
        }
        return this.applyTopDownTransformations(environment.getRoot(), passTransformations, iterationNumber, AbstractRule.Mode.TOP_DOWN, 0, environment);
    }

    private int applyBottomUpTransformations(RulePass passTransformations, PlanningEnvironment environment, int iterationNumber) {
        if (passTransformations.getTransformationMap() == null) {
            return 0;
        }
        return this.applyBottomUpTransformations(environment.getRoot(), passTransformations, iterationNumber, AbstractRule.Mode.BOTTOM_UP, 0, environment);
    }

    private void getNodeListForBottomUpTransformation(IXQEQueryNode node, List<IXQEQueryNode> listOfNodes) {
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            IXQEQueryNode child = node.getChild(i);
            this.getNodeListForBottomUpTransformation(child, listOfNodes);
        }
        listOfNodes.add(node);
    }

    private int applyBottomUpTransformations(IXQEQueryNode node, RulePass passTransformations, int iterationNumber, AbstractRule.Mode mode, int numTransformsApplied, PlanningEnvironment environment) {
        if (node == null) {
            return numTransformsApplied;
        }
        ArrayList<IXQEQueryNode> listOfNodes = new ArrayList<IXQEQueryNode>();
        this.getNodeListForBottomUpTransformation(node, listOfNodes);
        XQENodeIndex nodeIndex = environment.getNodeIndex();
        for (IXQEQueryNode nodeToApply : listOfNodes) {
            if (nodeIndex.getNodeByID(nodeToApply.getId()) == null || !this.applyApplicableTransformation(passTransformations, nodeToApply, iterationNumber, mode, environment)) continue;
            ++numTransformsApplied;
            numTransformsApplied += this.applyLockedNodeTransformations(passTransformations, iterationNumber, environment);
        }
        return numTransformsApplied;
    }

    private int applyTopDownTransformations(IXQEQueryNode node, RulePass passTransformations, int iterationNumber, AbstractRule.Mode mode, int numTransformsApplied, PlanningEnvironment environment) {
        Stack<Pair<IXQEQueryNode, Integer>> plannedAscendants = new Stack<Pair<IXQEQueryNode, Integer>>();
        IXQEQueryNode currentAscendant = null;
        IXQEQueryNode root = node;
        boolean nodeChanged = true;
        XQENodeIndex nodeIndex = environment.getNodeIndex();
        int numChildren = 0;
        while (!plannedAscendants.isEmpty() || root != null) {
            IXQEQueryNode nodeToPlan = null;
            if (root != null) {
                nodeToPlan = root;
                root = null;
            } else {
                Pair pair = (Pair)plannedAscendants.lastElement();
                currentAscendant = (IXQEQueryNode)pair.getFirst();
                if (nodeIndex.getNodeByID(currentAscendant.getId()) == null && currentAscendant.getType() != root.getType()) {
                    plannedAscendants.pop();
                    continue;
                }
                int pendingChildIndex = (Integer)pair.getSecond();
                if (pendingChildIndex < currentAscendant.getNumberChildren()) {
                    nodeToPlan = currentAscendant.getChild(pendingChildIndex);
                }
                pair.setSecond(XQEIntegerPool.getInteger(++pendingChildIndex));
                if (nodeToPlan == null) {
                    plannedAscendants.pop();
                    continue;
                }
            }
            while (nodeToPlan != null) {
                nodeChanged = true;
                IXQEQueryNode currentParent = nodeToPlan.getParent();
                int nodeToPlanPosition = 0;
                if (currentParent != null) {
                    numChildren = currentParent.getNumberChildren();
                    nodeToPlanPosition = currentParent.getPositionOfChild(nodeToPlan);
                }
                while (nodeChanged) {
                    IXQEQueryNode nextSibling = null;
                    int nextChildPosition = nodeToPlanPosition + 1;
                    if (currentParent != null && nextChildPosition < currentParent.getNumberChildren()) {
                        nextSibling = currentParent.getChild(nextChildPosition);
                    }
                    if (this.applyApplicableTransformation(passTransformations, nodeToPlan, iterationNumber, mode, environment)) {
                        ++numTransformsApplied;
                        numTransformsApplied += this.applyLockedNodeTransformations(passTransformations, iterationNumber, environment);
                    } else {
                        nodeChanged = false;
                        continue;
                    }
                    if (nodeIndex.getNodeByID(nodeToPlan.getId()) != null && currentParent != null && currentParent.getNumberChildren() == numChildren) {
                        if (currentParent.getChild(nodeToPlanPosition) == nodeToPlan) {
                            nodeChanged = false;
                        } else {
                            nodeToPlan = currentParent.getChild(nodeToPlanPosition);
                        }
                    } else if (nextSibling != null && currentParent != null && (nodeIndex.getNodeByID(currentParent.getId()) != null || currentParent.getType() != root.getType()) && nodeToPlanPosition < currentParent.getNumberChildren() && nextSibling.equals(currentParent.getChild(nodeToPlanPosition))) {
                        nodeToPlan = nextSibling;
                    } else {
                        nodeChanged = false;
                        if (currentParent != null) {
                            nodeToPlan = null;
                        }
                    }
                    this.checkThatMaximumNumberOfNodesNotExceeded(environment);
                }
                if (nodeToPlan == null) continue;
                if (nodeToPlan.getNumberChildren() > 1) {
                    plannedAscendants.push(new Pair<IXQEQueryNode, Integer>(nodeToPlan, new Integer(1)));
                }
                if (nodeToPlan.getNumberChildren() == 0) {
                    nodeToPlan = null;
                    continue;
                }
                nodeToPlan = nodeToPlan.getChild(0);
            }
        }
        return numTransformsApplied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int applyLockedNodeTransformations(RulePass passTransformations, int iterationNumber, PlanningEnvironment environment) throws QTEEngineException {
        int numTransformsApplied = 0;
        if (!environment.getLockNodeQueryPlanningEnabled()) {
            return numTransformsApplied;
        }
        int lockNodeType = environment.getLockNodeType();
        XQETrace trace = environment.getTrace();
        trace.beginElement(1, "transformationGroup", -1);
        trace.attribute(1, STRING_NODE_TYPE, lockNodeType);
        try {
            IXQEQueryNode[] nodes = environment.getRoot().getDescendantsOfType(lockNodeType, true);
            if (nodes.length == 0) {
                int n = numTransformsApplied;
                return n;
            }
            Integer key = lockNodeType;
            List<AbstractRule> transformList = this.constructTransformationList(passTransformations, key);
            if (transformList.isEmpty()) {
                throw new QTEEngineException(CoreMessageKeys.QTE_NoApplicableTransformationsForLockedNode, environment.getNodeFactory().getNodeTypeName(lockNodeType));
            }
            while (true) {
                int numTransformsAppliedInSubIterations = 0;
                for (AbstractRule transformation : transformList) {
                    if (transformation.getMode() == AbstractRule.Mode.BOTTOM_UP || transformation.getMode() == AbstractRule.Mode.TOP_DOWN) continue;
                    for (int i = 0; i < nodes.length; ++i) {
                        if (!this.applyTransformation(transformation, nodes[i], environment)) continue;
                        ++numTransformsAppliedInSubIterations;
                    }
                }
                if (numTransformsAppliedInSubIterations == 0) {
                    break;
                }
                numTransformsApplied += numTransformsAppliedInSubIterations;
                nodes = environment.getRoot().getDescendantsOfType(lockNodeType, true);
            }
        }
        finally {
            environment.disableLockNodeQueryPlanning();
            trace.endElement(1);
        }
        return numTransformsApplied;
    }

    private boolean applyApplicableTransformation(RulePass passTransformations, IXQEQueryNode node, int iterationNumber, AbstractRule.Mode mode, PlanningEnvironment environment) {
        Integer key = XQEIntegerPoolForNodeType.getInteger(node.getType());
        List<AbstractRule> transformList = this.constructTransformationList(passTransformations, key);
        boolean status = false;
        if (!transformList.isEmpty()) {
            for (int i = 0; i < transformList.size(); ++i) {
                AbstractRule transformation = transformList.get(i);
                if (transformation.getMode() != mode || transformation.getApplicableIterations() == AbstractRule.ApplicableIterations.INITIAL && iterationNumber > 0 || !this.applyTransformation(transformation, node, environment)) continue;
                status = true;
                break;
            }
        }
        return status;
    }

    private List<AbstractRule> constructTransformationList(RulePass passTransformations, int nodeType) {
        return passTransformations.getTransformationsForNodeType(nodeType);
    }

    private boolean applyTransformation(AbstractRule transformation, IXQEQueryNode node, PlanningEnvironment environment) {
        boolean traceTreeAfterTrans;
        XQETrace trace = environment.getTrace();
        boolean traceEnabled = (trace.getTraceLevel() & 1) != 0;
        boolean bl = traceTreeAfterTrans = (trace.getTraceLevel() & 8) != 0;
        if (traceEnabled) {
            if ((trace.getTraceLevel() & 4) == 0) {
                trace.deferTracing();
            }
            trace.beginElement("transformation", -1);
            trace.attribute(STRING_NAME, transformation.getName());
            trace.attribute(STRING_NODE_TYPE, node.getType());
            trace.attribute("nodeId", node.getId());
            trace.attribute("className", transformation.getClass().getName());
            transformation.dumpSpecificationReferences(trace);
        }
        AbstractRuleLibrary transformationLibrary = transformation.getTransformationLibrary();
        boolean passes = false;
        if (transformationLibrary.passesCondition(node, environment, transformation)) {
            passes = transformation.passesQueryCondition(node, environment);
        }
        if (passes && (passes = transformation.passesNodeCondition(node, environment))) {
            trace.traceDeferredStatements();
            trace.beginElement(256, "treeOperations", -1);
            transformation.apply(node, environment);
            trace.endElement(256);
            if (traceEnabled && traceTreeAfterTrans) {
                environment.getRoot().dump(trace);
            }
            this.checkForNoOpTransformationBeingApplied(transformation, environment);
            this.addNodeToListOfTransformedNodesInCurrentPass(environment, node, transformation);
        }
        if (!passes) {
            if ((trace.getTraceLevel() & 4) != 0) {
                trace.traceDeferredStatements();
            } else {
                trace.deleteDeferredTraceStatements();
                return false;
            }
        }
        if (traceEnabled) {
            trace.endElement();
        }
        return passes;
    }

    private void checkForNoOpTransformationBeingApplied(AbstractRule transformation, PlanningEnvironment environment) throws QTEEngineException {
        if (!environment.getTreeHasBeenModified()) {
            StringBuffer transfName = new StringBuffer();
            transfName.append(transformation.getTransformationLibrary().getLibraryName());
            transfName.append(" - ");
            transfName.append(transformation.getClass().getSimpleName());
            throw new QTEEngineException(CoreMessageKeys.QTE_NoOpTransformation, transfName.toString());
        }
        environment.resetTreeHasBeenModified();
    }

    public void validateTreeAfterTransformationApplied(PlanningEnvironment environment, AbstractRule transformation) throws QTEEngineException {
        environment.getNodeIndex();
        IXQEQueryNode node = environment.getRoot();
        int nbrNodes = this.validateChildrenNodes(node, transformation);
        XQENodeIndex nodeIndex = environment.getNodeIndex();
        if (nbrNodes - 1 != nodeIndex.getNumberOfNodesInIndex()) {
            throw new QTEEngineException(CoreMessageKeys.QTE_NodeNotAddedToTree, transformation.getClass().toString());
        }
    }

    private int validateChildrenNodes(IXQEQueryNode node, AbstractRule transformation) throws QTEEngineException {
        int nbrNodes = 1;
        for (IXQEQueryNode childNode : node.getChildren()) {
            if (childNode.getParent() != node) {
                throw new QTEEngineException(CoreMessageKeys.QTE_NodeNotAddedToTree, transformation.getClass().toString());
            }
            nbrNodes += this.validateChildrenNodes(childNode, transformation);
        }
        return nbrNodes;
    }

    private int calculateMaximumNumberOfNodesInQueryTree(PlanningEnvironment environment) {
        return environment.getNodeIndex().getNumberOfNodesInIndex() * environment.getQueryNodeMultiplerLimit();
    }

    private void checkThatMaximumNumberOfNodesNotExceeded(PlanningEnvironment environment) throws QTEEngineException {
        int maximumNumberOfNodes = environment.getMaximumNumberOfNodesInQueryTree();
        if (maximumNumberOfNodes <= 0) {
            return;
        }
        if (environment.getNodeIndex().getNumberOfNodesInIndex() > maximumNumberOfNodes) {
            throw new QTEEngineException(CoreMessageKeys.QTE_MaximumNodesExceeded, new Integer(maximumNumberOfNodes).toString());
        }
    }

    private boolean treeActuallyContainsNodes(PlanningEnvironment environment) {
        return environment.getNodeIndex().getNumberOfNodesInIndex() > 0;
    }

    private void checkIfQueryPlanningLimitExceeded(PlanningEnvironment environment, long startTime) throws QTEEngineException {
        long currentTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        if (environment.getQueryPlanningTimeLimit() > 0L && currentTime - startTime > environment.getQueryPlanningTimeLimit()) {
            throw new QTEEngineException(CoreMessageKeys.QTE_PlanningTimeout, new Integer((int)environment.getQueryPlanningTimeLimit()).toString());
        }
    }

    private boolean isAnyTrackingEnabled(XQETrace trace) {
        return (trace.getTraceLevel() & 7) != 0;
    }

    private void initializeTransformationEnvironment(IXQEQueryNode root, PlanningEnvironment environment) throws QTEEngineException {
        if (root == null) {
            throw new QTEEngineException(CoreMessageKeys.QTE_EmptyQueryTree);
        }
        if (environment == null) {
            throw new QTEEngineException(CoreMessageKeys.QTE_NoPlanningEnvironment);
        }
        environment.setRoot(root);
        environment.constructQueryLineage();
        if ((environment.getTrace().getTraceLevel() & 1) != 0) {
            environment.getTrace().addTraceLevel(256);
        }
        this.loadConfigurationInformation(environment);
    }

    private void beginTracingQueryTransformations(PlanningEnvironment environment, XQETrace trace) {
        trace.beginElement("queryTransformations", -1);
        if (environment.getRandomizeTransformations()) {
            trace.attribute("randomSeed", environment.getRequestEnvironment().getRandomSeed());
        }
    }

    private void endTracingQueryTransformations(XQETrace trace) {
        trace.endElement();
    }

    private void traceInitialQuery(IXQEQueryNode root, XQETrace trace) {
        if ((trace.getTraceLevel() & 1) != 0) {
            trace.beginElement("initialQuery", -1);
            root.dump(trace);
            trace.endElement();
        }
    }

    private void traceFinalQuery(IXQEQueryNode root, XQETrace trace) {
        if ((trace.getTraceLevel() & 1) != 0) {
            trace.beginElement("finalQuery", -1);
            root.dump(trace);
            trace.endElement();
        }
    }

    private void tracePassNumber(XQETrace trace, int passNumber, PlanningEnvironment environment) {
        Writer passLogWriter = TraceLogManager.getInstance().createPlanningPassTraceWriter(environment.getRequestEnvironment(), passNumber);
        this.setCurrentTraceWriter(trace, environment, passLogWriter);
    }

    private void setCurrentTraceWriter(XQETrace trace, PlanningEnvironment reqEnv, Writer writer) {
        trace.removeStream(reqEnv.getCurrentTraceWriter());
        trace.addStream(writer);
        reqEnv.setCurrentTraceWriter(writer);
    }

    private void traceLibrariesAssociatedWithPass(XQETrace trace, int passNumber) {
    }

    private void initializeListOfTransformedNodesInCurrentPass(PlanningEnvironment environment) {
        if (environment.getCheckTransformationAppliedTwiceToNodeInSamePass() != 0) {
            return;
        }
        if (this.mNodesTransformedInCurrentPass == null) {
            this.mNodesTransformedInCurrentPass = new HashMap<Integer, List<AbstractRule>>();
            return;
        }
        this.mNodesTransformedInCurrentPass.clear();
    }

    private void addNodeToListOfTransformedNodesInCurrentPass(PlanningEnvironment environment, IXQEQueryNode node, AbstractRule transformation) {
        if (environment.getCheckTransformationAppliedTwiceToNodeInSamePass() != 0) {
            return;
        }
        List<AbstractRule> list = this.mNodesTransformedInCurrentPass.get(node.getId());
        if (list == null) {
            list = new ArrayList<AbstractRule>();
            list.add(transformation);
            this.mNodesTransformedInCurrentPass.put(node.getId(), list);
            return;
        }
        for (AbstractRule aTransformation : list) {
            if (aTransformation != transformation) continue;
            throw new QTEEngineException(CoreMessageKeys.QTE_TransformationAppliedTwiceToSameNode, transformation.getName(), node.getId().toString());
        }
        list.add(transformation);
    }

    public static XMLWriter createXMLWriterToFile(String fileName) {
        XMLWriter xmlWriter = null;
        try {
            Writer writer = InferenceEngine.createFileWriter(fileName);
            xmlWriter = new XMLWriter();
            xmlWriter.addStream(writer);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), InferenceEngine.class.getName() + "::createXMLWriterToFile()", e);
        }
        return xmlWriter;
    }

    public static Writer createFileWriter(String fileName) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8"));
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), InferenceEngine.class.getName() + "::createFileWriter()", e);
        }
        return writer;
    }
}

