/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.inference;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.smd.ISmartMetadata;
import com.ibm.cognos.aurora.api.util.IIdentifiable;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.bibusservice.RequestEnvironment;
import com.ibm.cognos.aurora.core.expert.exception.XQERuntimeException;
import com.ibm.cognos.aurora.core.expert.inference.ExecutionEnvironment;
import com.ibm.cognos.aurora.core.expert.inference.IPlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.inference.QTEEngineException;
import com.ibm.cognos.aurora.core.expert.inference.SimplePlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.trace.TraceLogManager;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class PlanningEnvironment
extends SimplePlanningEnvironment
implements IPlanningEnvironment {
    public static final long INIITAL_QUERY_PLANNING_TIME_LIMIT = -1L;
    private long queryPlanningTimeLimit = -1L;
    private int queryPlanningMaximumNumberOfNodesInQueryTree = 0;
    public static final int CHECK_TRANSFORM_APPLIED_TWICE_NOT_ESTABLISHED = -1;
    public static final int CHECK_TRANSFORM_APPLIED_TWICE_ENABLED = 0;
    public static final int CHECK_TRANSFORM_APPLIED_TWICE_DISABLED = 1;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private RequestEnvironment requestEnv;
    private boolean planningActive = false;
    private IXQEQueryNode root;
    private IXQEQueryNode queryLineage;
    private XQENodeFactory nodeFactory;
    private boolean randomizeTransformations = false;
    private Random random = null;
    private boolean traceQueryLineage = false;
    private Writer curTraceWriter;
    private int mCheckTransformationAppliedTwicetoNodeInSamePass = -1;
    public static final int INITIAL_QUERY_NODE_MULTIPLIER_LIMIT = -1;
    private int queryNodeMultiplierLimit = -1;
    private int lockNodeType;
    private boolean lockNodeQueryPlanning;
    private boolean mLoadingOfConfigurationInformation = true;
    private Writer logWriter = null;
    private ILogger logger = null;
    protected Map<String, IAssociativeModel> models = new HashMap<String, IAssociativeModel>();
    protected Map<IAssociativeModel, NavigationHelper> navigationHelpers = new HashMap<IAssociativeModel, NavigationHelper>();
    protected IQueryLogicalStorage qls = null;
    protected ISmartMetadata smd = null;

    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public IQueryLogicalStorage getQueryLogicalStorage() {
        return this.qls;
    }

    public void setQueryLogicalStorage(IQueryLogicalStorage queryLogicalStorage) {
        if (null != this.qls) {
            throw new IllegalStateException("The IQueryLogicalStorage is already set");
        }
        this.qls = queryLogicalStorage;
    }

    public ISmartMetadata getSmartMetadata() {
        return this.smd;
    }

    public void setSmartMetadata(ISmartMetadata smartMetadata) {
        if (null != this.smd) {
            throw new IllegalStateException("The ISmartMetadata is already set");
        }
        this.smd = smartMetadata;
    }

    public IAssociativeModel getModel(String fileName) {
        IAssociativeModel model = this.models.get(fileName);
        if (model != null) {
            return model;
        }
        throw new IllegalStateException();
    }

    public NavigationHelper getNavigationHelper(IAssociativeModel model) {
        NavigationHelper navigationHelper = this.navigationHelpers.get(model);
        if (null == navigationHelper) {
            navigationHelper = new NavigationHelper(model);
        }
        return navigationHelper;
    }

    public void setModel(IIdentifiable dataSource, IAssociativeModel associativeModel) {
        this.models.put(dataSource.getName(), associativeModel);
    }

    public void setNodeFactory(XQENodeFactory theNodeFactory) {
        this.nodeFactory = theNodeFactory;
    }

    public XQENodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public void setRoot(IXQEQueryNode theRoot) {
        this.root = theRoot;
    }

    public IXQEQueryNode getRoot() {
        return this.root;
    }

    protected boolean getRandomizeTransformations() {
        return this.randomizeTransformations;
    }

    protected void setRandomizeTransformations(boolean newRandomizeTransformations) {
        this.randomizeTransformations = newRandomizeTransformations;
    }

    protected Random getRandom() {
        return this.random;
    }

    protected void setRandom(Random newRandom) {
        this.random = newRandom;
    }

    private void setRequestEnvironment(RequestEnvironment env) {
        this.requestEnv = env;
    }

    public RequestEnvironment getRequestEnvironment() {
        return this.requestEnv;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        ExecutionEnvironment executionEnvironment = null;
        if (null != this.requestEnv) {
            executionEnvironment = this.requestEnv.getExecutionEnvironment();
        }
        return executionEnvironment;
    }

    public void constructQueryLineage() {
        if (!this.getQueryLineageTrackingEnabled()) {
            return;
        }
        if (this.root == null) {
            return;
        }
        this.queryLineage = this.getNodeFactory().deepCopyNodeNonIndexed(this.root);
        this.root.initializeLineage(this.queryLineage);
    }

    public void releaseQueryLineage() {
        if (!this.getQueryLineageTrackingEnabled()) {
            return;
        }
        this.root.deleteLineage(true);
        this.queryLineage = null;
    }

    public void setTraceQueryLineage(boolean value) {
        this.traceQueryLineage = value;
    }

    public boolean traceQueryLineage() {
        return this.traceQueryLineage;
    }

    public void setQueryPlanningTimeLimit(long planningTimeLimit) {
        this.queryPlanningTimeLimit = planningTimeLimit;
    }

    public long getQueryPlanningTimeLimit() {
        return this.queryPlanningTimeLimit;
    }

    void setMaximumNumberOfNodesInQueryTree(int maximumNumberOfNodesInQueryTree) {
        this.queryPlanningMaximumNumberOfNodesInQueryTree = maximumNumberOfNodesInQueryTree;
    }

    int getMaximumNumberOfNodesInQueryTree() {
        return this.queryPlanningMaximumNumberOfNodesInQueryTree;
    }

    public void setQueryNodeMultiplierLimit(int multiplier) {
        this.queryNodeMultiplierLimit = multiplier;
    }

    public int getQueryNodeMultiplerLimit() {
        return this.queryNodeMultiplierLimit;
    }

    public void enableLockNodeQueryPlanning(int theLockNodeType) {
        if (this.lockNodeQueryPlanning) {
            this.disableLockNodeQueryPlanning();
            throw new QTEEngineException(CoreMessageKeys.QTE_LockedNodeModeAlreadyEnabled, this.getNodeFactory().getNodeTypeName(this.lockNodeType));
        }
        this.lockNodeType = theLockNodeType;
        this.lockNodeQueryPlanning = true;
    }

    public void disableLockNodeQueryPlanning() {
        this.lockNodeQueryPlanning = false;
    }

    public int getLockNodeType() {
        return this.lockNodeType;
    }

    public boolean getLockNodeQueryPlanningEnabled() {
        return this.lockNodeQueryPlanning;
    }

    public int getCheckTransformationAppliedTwiceToNodeInSamePass() {
        return this.mCheckTransformationAppliedTwicetoNodeInSamePass;
    }

    public void setCheckTransformationAppliedTwiceToNodeInSamePass(int setting) {
        this.mCheckTransformationAppliedTwicetoNodeInSamePass = setting;
    }

    public void setLoadingOfConfigurationInformation(boolean allowed) {
        this.mLoadingOfConfigurationInformation = allowed;
    }

    public boolean getLoadingOfConfigurationInformation() {
        return this.mLoadingOfConfigurationInformation;
    }

    public XQETrace openPlanningLog(RequestEnvironment reqEnv) {
        this.logWriter = TraceLogManager.getInstance().createPlanningTraceWriter(reqEnv);
        XQETrace trace = new XQETrace();
        if (this.logWriter != null) {
            trace.addStream(this.logWriter);
            this.setCurrentTraceWriter(this.logWriter);
        }
        this.setTrace(trace);
        return trace;
    }

    public void closePlanningLog() {
        if (this.logWriter != null) {
            try {
                this.logWriter.close();
            }
            catch (IOException ioe) {
                throw XQERuntimeException.wrap(ioe);
            }
        }
    }

    public void setCurrentTraceWriter(Writer writer) {
        this.curTraceWriter = writer;
    }

    public Writer getCurrentTraceWriter() {
        return this.curTraceWriter;
    }

    @Override
    public void setTreeHasBeenModified() {
        if (!this.planningActive && this.getRequestEnvironment() != null) {
            throw new XQERuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "setTreeHasBeenModified on inactive planning environment");
        }
        super.setTreeHasBeenModified();
    }

    public void setPlanningActive(RequestEnvironment reqEnv) {
        this.planningActive = true;
        this.setRequestEnvironment(reqEnv);
    }

    public void setPlanningInactive() {
        this.planningActive = false;
        this.setRequestEnvironment(null);
        super.clearNodeIndex();
    }

    public void initializePlanning() {
    }

    public void finalizePlanning() {
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

