/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.inference;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.util.IIdentifiable;
import com.ibm.cognos.aurora.core.expert.ast.IXQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQENodeFactory;
import com.ibm.cognos.aurora.core.expert.ast.XQEQueryNode;
import com.ibm.cognos.aurora.core.expert.ast.XQEUberNodeFactory;
import com.ibm.cognos.aurora.core.expert.bibusservice.RequestEnvironment;
import com.ibm.cognos.aurora.core.expert.config.ServiceEnumeration;
import com.ibm.cognos.aurora.core.expert.config.XQEConfiguration;
import com.ibm.cognos.aurora.core.expert.config.XQEConfigurationManager;
import com.ibm.cognos.aurora.core.expert.context.ExecutionEnvironmentContext;
import com.ibm.cognos.aurora.core.expert.exception.XQERuntimeException;
import com.ibm.cognos.aurora.core.expert.inference.AbstractRuleLibraryManager;
import com.ibm.cognos.aurora.core.expert.inference.EnvironmentFactory;
import com.ibm.cognos.aurora.core.expert.inference.ExecutionEnvironment;
import com.ibm.cognos.aurora.core.expert.inference.IEnvironmentFactory;
import com.ibm.cognos.aurora.core.expert.inference.InferenceEngine;
import com.ibm.cognos.aurora.core.expert.inference.PlanningEnvironment;
import com.ibm.cognos.aurora.core.expert.inference.QueryEngineLoggingUtils;
import com.ibm.cognos.aurora.core.expert.trace.XQETrace;
import com.ibm.cognos.aurora.core.pool.XQESAXReaderPool;
import java.io.Reader;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class QueryEngine {
    public static final String SERVICE_NAME = "XQE";
    public static final String XML_ELEMENT_ITERATOR_PROFILING_ENABLED = "queryExecution.iteratorProfiling[@enabled]";
    private static final Boolean RUNTREE_EXECUTION_ENABLED_DEFAULT = false;
    private static final Boolean RUNTREE_ENABLED_DEFAULT = true;
    private static final String RUNTREE_EXECUTION_ENABLED = "queryExecution.traceLevels.runTreeExecution[@enabled]";
    private static final String RUNTREE_ENABLED = "queryExecution.traceLevels.runTree[@enabled]";
    private static final String XML_TREE_AFTER_TRANSFORMATION = "queryPlanning.dumpTreeAfterTransformation[@enabled]";
    public static final boolean REGISTER_RSAPIDATASET_INSTANCES = true;
    private final EnvironmentFactory baseEnvironmentFactory = new EnvironmentFactory();
    private final InferenceEngine inferenceEngine;

    public QueryEngine(AbstractRuleLibraryManager libraryManager) {
        this.inferenceEngine = new InferenceEngine(libraryManager);
    }

    public void dispose() {
    }

    public static boolean isRuntreeLoggingEnabled(XQETrace trace) {
        return trace != null && (trace.getTraceLevel() & 0x80) != 0;
    }

    public static boolean isRuntreeExecutionLoggingEnabled(XQETrace trace) {
        return trace != null && (trace.getTraceLevel() & 0x800) != 0;
    }

    public static boolean isRuntreeEnabled(RequestEnvironment reqEnv) {
        return QueryEngineLoggingUtils.isExecutionTraceEnabled(reqEnv);
    }

    public static boolean isExecutionLoggingEnabled(XQETrace trace) {
        return trace != null && (trace.getTraceLevel() & 0x200) != 0;
    }

    public static boolean isExecutionLoggingEnabled(RequestEnvironment reqEnv) {
        if (!QueryEngineLoggingUtils.isExecutionTraceEnabled(reqEnv)) {
            return false;
        }
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.AURORA);
        return config.getBooleanProperty(RUNTREE_EXECUTION_ENABLED, RUNTREE_EXECUTION_ENABLED_DEFAULT);
    }

    public static boolean isProfilingEnabled(XQETrace trace) {
        return trace != null && QueryEngine.isExecutionLoggingEnabled(trace) && (trace.getTraceLevel() & 0x400) != 0;
    }

    public static boolean isProfilingEnabled(RequestEnvironment reqEnvironment) {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.AURORA);
        if (!QueryEngineLoggingUtils.isExecutionTraceEnabled(reqEnvironment)) {
            return false;
        }
        return configuration.getBooleanProperty(XML_ELEMENT_ITERATOR_PROFILING_ENABLED, true);
    }

    public void addQueryExecutionTraceLevels(XQETrace trace, RequestEnvironment reqEnv) {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.AURORA);
        if (!QueryEngineLoggingUtils.isExecutionTraceEnabled(reqEnv)) {
            return;
        }
        trace.addTraceLevel(512);
        if (configuration.getBooleanProperty(XML_ELEMENT_ITERATOR_PROFILING_ENABLED, true)) {
            trace.addTraceLevel(1024);
        }
        if (configuration.getBooleanProperty(RUNTREE_ENABLED, RUNTREE_ENABLED_DEFAULT).booleanValue()) {
            trace.addTraceLevel(128);
        }
        if (configuration.getBooleanProperty(RUNTREE_EXECUTION_ENABLED, RUNTREE_EXECUTION_ENABLED_DEFAULT).booleanValue()) {
            trace.addTraceLevel(2048);
        }
    }

    public void configureRequestEnvironment(RequestEnvironment requestEnvironment) {
        ExecutionEnvironment executionEnvironment = requestEnvironment.getExecutionEnvironment();
        if (null == executionEnvironment) {
            ExecutionEnvironment newExecutionEnvironment = this.createExecutionEnvironment();
            newExecutionEnvironment.setRequestEnvironment(requestEnvironment);
            requestEnvironment.setExecutionEnvironment(newExecutionEnvironment);
        }
        if (requestEnvironment.getEnvFactory() == null) {
            requestEnvironment.setEnvFactory(this.baseEnvironmentFactory);
        }
    }

    private ExecutionEnvironment createExecutionEnvironment() {
        ExecutionEnvironment executionEnvironment = new ExecutionEnvironment();
        return executionEnvironment;
    }

    public void releaseSessionContext(RequestEnvironment reqEnv) {
    }

    public void releaseSessionContext(String sessionContextID) {
    }

    public EnvironmentFactory getBaseEnvironmentFactory() {
        return this.baseEnvironmentFactory;
    }

    public IXQEQueryNode planQuery(IEnvironmentFactory environmentFactory, IAssociativeModel associativeModel, IIdentifiable dataSource, Class<? extends XQENodeFactory> nodeFactoryClass, Reader inputReader) throws Exception {
        return this.planQuery(environmentFactory, associativeModel, dataSource, nodeFactoryClass, null, inputReader);
    }

    public IXQEQueryNode planQuery(IEnvironmentFactory environmentFactory, IAssociativeModel associativeModel, IIdentifiable dataSource, Class<? extends XQENodeFactory> nodeFactoryClass, int startingID, IXQEQueryNode queryTree) throws Exception {
        return this.planQuery(environmentFactory, associativeModel, dataSource, nodeFactoryClass, queryTree, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IXQEQueryNode planQuery(IEnvironmentFactory environmentFactory, IAssociativeModel associativeModel, IIdentifiable dataSource, Class<? extends XQENodeFactory> nodeFactoryClass, IXQEQueryNode queryTree, Reader inputReader) throws Exception {
        if (queryTree == null && inputReader == null) {
            throw new IllegalStateException();
        }
        Document requestDocument = null;
        if (inputReader != null) {
            requestDocument = QueryEngine.readInputRequest(inputReader);
        }
        RequestEnvironment requestEnvironment = new RequestEnvironment();
        String id = "AURORA_";
        requestEnvironment.setRequestID("AURORA_");
        this.configureRequestEnvironment(requestEnvironment);
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(requestEnvironment.getExecutionEnvironment());
        try {
            PlanningEnvironment planEnv = null;
            try {
                planEnv = QueryEngine.setupEnvironment(requestEnvironment, environmentFactory, nodeFactoryClass, true);
                if (null != associativeModel) {
                    planEnv.setModel(dataSource, associativeModel);
                }
                XQENodeFactory nodeFactory = planEnv.getNodeFactory();
                IXQEQueryNode querySpec = null;
                if (null != queryTree) {
                    querySpec = nodeFactory.deepCopyNodeIndexed(queryTree);
                }
                if (requestDocument == null) {
                    planEnv.setRoot(querySpec);
                } else {
                    Element root = requestDocument.getRootElement();
                    if (root != null) {
                        String nodeName = root.getName();
                        IXQEQueryNode node = nodeFactory.createNode(nodeName);
                        planEnv.getNodeIndex().addNode(node);
                        ((XQEQueryNode)node).capture(planEnv, root);
                        planEnv.setRoot(node);
                    }
                }
                this.inferenceEngine.applyTransformations(planEnv.getRoot(), planEnv);
                IXQEQueryNode iXQEQueryNode = planEnv.getRoot();
                if (planEnv != null) {
                    planEnv.closePlanningLog();
                }
                return iXQEQueryNode;
            }
            catch (Throwable throwable) {
                if (planEnv != null) {
                    planEnv.closePlanningLog();
                }
                throw throwable;
            }
        }
        finally {
            executionEnvironmentContext.exit();
        }
    }

    private static Document readInputRequest(Reader reader) throws Exception {
        SAXReader xmlReader = XQESAXReaderPool.getInstance().borrowReader();
        try {
            Document document = xmlReader.read(reader);
            return document;
        }
        finally {
            XQESAXReaderPool.getInstance().returnReader(xmlReader);
        }
    }

    public static PlanningEnvironment setupEnvironment(RequestEnvironment reqEnv, IEnvironmentFactory envFactory, Class<? extends XQENodeFactory> nodeFactoryClass, boolean openPlanLog) {
        PlanningEnvironment environment = envFactory == null ? reqEnv.getEnvFactory().createPlanningEnvironment() : envFactory.createPlanningEnvironment();
        XQETrace trace = null;
        if (openPlanLog) {
            trace = environment.openPlanningLog(reqEnv);
            QueryEngine.addTraceLevels(trace, reqEnv);
        } else {
            trace = new XQETrace();
        }
        XQEUberNodeFactory uberNodeFactory = new XQEUberNodeFactory();
        uberNodeFactory.setTrace(trace);
        uberNodeFactory.setPlanningEnvironment(environment);
        try {
            uberNodeFactory.addNodeFactory(nodeFactoryClass.newInstance());
            XQENodeFactory aFactory = nodeFactoryClass.newInstance();
            uberNodeFactory.addNodeFactory(aFactory);
            uberNodeFactory.setNodeFactory(aFactory);
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        environment.setTrace(trace);
        environment.setNodeFactory(uberNodeFactory);
        environment.setPlanningActive(reqEnv);
        return environment;
    }

    private static void addTraceLevels(XQETrace trace, RequestEnvironment reqEnv) {
        if (trace == null) {
            return;
        }
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.AURORA);
        if (!QueryEngineLoggingUtils.isPlanningTraceEnabled(reqEnv)) {
            trace.resetTraceLevels();
            return;
        }
        trace.addTraceLevel(1);
        if (configuration.getBooleanProperty("queryPlanning.traceLevels.whyTransformationApplied[@enabled]", false)) {
            trace.addTraceLevel(2);
            if (configuration.getBooleanProperty("queryPlanning.traceLevels.whyTransformationNotApplied[@enabled]", false)) {
                trace.addTraceLevel(4);
                if (configuration.getBooleanProperty("queryPlanning.traceLevels.complexNodeProperties[@enabled]", false)) {
                    trace.addTraceLevel(64);
                }
            }
        }
        if (configuration.getBooleanProperty(XML_TREE_AFTER_TRANSFORMATION, true)) {
            trace.addTraceLevel(8);
        }
    }
}

