/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.inference;

import com.ibm.cognos.aurora.core.expert.ast.XQENodeIndex;
import com.ibm.cognos.aurora.core.expert.rules.AbstractRule;
import com.ibm.cognos.aurora.core.pool.XQEIntegerPoolForNodeType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class RulePass {
    private boolean mContainsTopDownTransformations = false;
    private boolean mContainsBottomUpTransformations = false;
    private boolean mContainsIndexedTransformations = false;
    private Map<Integer, List<AbstractRule>> mTransformationMap = new HashMap<Integer, List<AbstractRule>>();
    private Map<Integer, List<AbstractRule>> mTransformationsForNodeType = new HashMap<Integer, List<AbstractRule>>();

    RulePass() {
    }

    void setContainsTopDownTransformations(boolean value) {
        this.mContainsTopDownTransformations = value;
    }

    void setContainsBottomUpTransformations(boolean value) {
        this.mContainsBottomUpTransformations = value;
    }

    void setContainsIndexedTransformations(boolean value) {
        this.mContainsIndexedTransformations = value;
    }

    public boolean getContainsTopDownTransformations() {
        return this.mContainsTopDownTransformations;
    }

    public boolean getContainsBottomUpTransformations() {
        return this.mContainsBottomUpTransformations;
    }

    public boolean getContainsIndexedTransformations() {
        return this.mContainsIndexedTransformations;
    }

    public Map<Integer, List<AbstractRule>> getTransformationMap() {
        return this.mTransformationMap;
    }

    public List<AbstractRule> getTransformationsForNodeType(int nodeType) {
        Integer nodeTypeInteger = XQEIntegerPoolForNodeType.getInteger(nodeType);
        List<AbstractRule> transformsStoredInMap = this.mTransformationsForNodeType.get(nodeTypeInteger);
        if (transformsStoredInMap == null) {
            return Collections.emptyList();
        }
        return transformsStoredInMap;
    }

    protected void createTransformationListForNodeType(Integer nodeTypeInteger) {
        List<AbstractRule> transformsForNode = this.mTransformationMap.get(nodeTypeInteger);
        if (transformsForNode == null) {
            return;
        }
        int listSize = 0;
        if (transformsForNode != null) {
            listSize = transformsForNode.size();
        }
        if (listSize == 0) {
            return;
        }
        ArrayList<AbstractRule> transformsStoredInMap = new ArrayList<AbstractRule>(listSize);
        if (transformsForNode != null) {
            transformsStoredInMap.addAll(transformsForNode);
        }
        this.mTransformationsForNodeType.put(nodeTypeInteger, transformsStoredInMap);
    }

    public boolean targetNodeExists(XQENodeIndex nodeIndex) {
        for (Integer aType : this.getTransformationMap().keySet()) {
            if (!nodeIndex.hasNodeOfType(aType)) continue;
            return true;
        }
        return false;
    }
}

