/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.trace;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.core.expert.bibusservice.RequestEnvironment;
import com.ibm.cognos.aurora.core.expert.config.ServiceEnumeration;
import com.ibm.cognos.aurora.core.expert.config.XQEConfiguration;
import com.ibm.cognos.aurora.core.expert.config.XQEConfigurationManager;
import com.ibm.cognos.aurora.core.expert.exception.XQERuntimeException;
import com.ibm.cognos.aurora.core.expert.inference.QueryEngine;
import com.ibm.cognos.aurora.core.expert.inference.QueryEngineLoggingUtils;
import com.ibm.cognos.aurora.core.expert.trace.IMemento;
import com.ibm.cognos.aurora.core.expert.trace.TraceLogWriter;
import com.ibm.cognos.aurora.core.expert.trace.XMLMemento;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.time.DateFormatUtils;

public final class TraceLogManager {
    private static final String CONTROL_REPLACE = "_";
    private static final TraceLogManager INSTANCE = new TraceLogManager();
    private static final int BUFFER_SIZE = 16384;
    private static final String UNKNOWN = "UNKNOWN";
    private static final String LOG_VERSION = "1.2.0.v10.1";
    private final Map<String, File> directoryMap = Collections.synchronizedMap(new WeakHashMap());
    private final ConcurrentHashMap<String, Manifest> manifestMap = new ConcurrentHashMap();

    public static TraceLogManager getInstance() {
        return INSTANCE;
    }

    private TraceLogManager() {
    }

    public Writer createPlanningTraceWriter(RequestEnvironment reqEnv) {
        return this.createTraceOutputWriter(reqEnv, QueryEngineLoggingUtils.isPlanningTraceEnabled(reqEnv), "planningLog.xml");
    }

    public Writer createPlanningPassTraceWriter(RequestEnvironment reqEnv, int passNumber) {
        Formatter formatter = new Formatter();
        formatter.format("planningLog_pass_%03d.xml", passNumber);
        return this.createTraceOutputWriter(reqEnv, QueryEngineLoggingUtils.isPlanningTraceEnabled(reqEnv), formatter.toString());
    }

    public Writer createRuntreeTraceWriter(RequestEnvironment reqEnv) {
        return this.createTraceOutputWriter(reqEnv, QueryEngineLoggingUtils.isExecutionTraceEnabled(reqEnv), "runtreeLog.xml");
    }

    public Writer createExecutionTraceWriter(RequestEnvironment reqEnv) {
        return this.createTraceOutputWriter(reqEnv, QueryEngineLoggingUtils.isExecutionTraceEnabled(reqEnv), "executionLog.xml");
    }

    public OutputStream createProfilingTraceOutputStream(RequestEnvironment reqEnv) {
        return this.createNextProfilingOutputStream(reqEnv, "profilingLog-");
    }

    private OutputStream createNextProfilingOutputStream(RequestEnvironment reqEnv, String prefix) {
        if (!QueryEngineLoggingUtils.isExecutionTraceEnabled(reqEnv)) {
            return null;
        }
        File logDir = this.getLogDirectory(reqEnv);
        File logFile = null;
        StringBuffer sBuffer = new StringBuffer();
        int idx = 0;
        do {
            sBuffer.setLength(0);
            sBuffer.append(prefix);
            sBuffer.append(idx++);
            sBuffer.append(".xml");
        } while ((logFile = new File(logDir, sBuffer.toString())).exists());
        try {
            return new BufferedOutputStream(new FileOutputStream(logFile));
        }
        catch (FileNotFoundException e) {
            throw XQERuntimeException.wrap(e);
        }
    }

    public void packageTraceOutput(RequestEnvironment reqEnv) {
        if (!QueryEngineLoggingUtils.isTracingEnabled(reqEnv)) {
            return;
        }
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.AURORA);
        if (!configuration.getBooleanProperty("general.compressTraceLogs", false)) {
            return;
        }
        String requestId = reqEnv.getRequestID();
        String subRequestId = reqEnv.getSubRequestID();
        if (requestId == null) {
            throw new XQERuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "RequestId was null");
        }
        if (TraceLogManager.isSubRequest(requestId, subRequestId)) {
            return;
        }
        if (this.directoryMap.get(requestId) == null) {
            throw new XQERuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "No directory found for request " + requestId);
        }
        File logDir = this.getLogDirectory(reqEnv);
        String logArchiveName = logDir.getPath() + ".xql";
        try {
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(logArchiveName)));
            this.addDirectory(zos, logDir, logDir.getName());
            zos.close();
        }
        catch (IOException e) {
            throw XQERuntimeException.wrap(e);
        }
        this.deleteDirectory(logDir);
    }

    public static boolean isSubRequest(String requestId, String subRequestId) {
        return subRequestId != null && !requestId.equals(subRequestId) && requestId.indexOf(subRequestId) != 0;
    }

    private void deleteDirectory(File dir) {
        File[] files;
        if (!dir.exists()) {
            return;
        }
        for (File f : files = dir.listFiles()) {
            if (f.isDirectory()) {
                this.deleteDirectory(f);
                continue;
            }
            f.delete();
        }
        dir.delete();
    }

    private void addDirectory(ZipOutputStream zos, File dir, String baseDirName) {
        File[] files;
        if (!dir.isDirectory()) {
            return;
        }
        byte[] buf = new byte[16384];
        for (File f : files = dir.listFiles()) {
            StringBuffer sb = new StringBuffer(baseDirName);
            sb.append(File.separatorChar);
            sb.append(f.getName());
            if (f.isDirectory()) {
                this.addDirectory(zos, f, sb.toString());
                continue;
            }
            try {
                int len;
                zos.putNextEntry(new ZipEntry(sb.toString()));
                FileInputStream fis = new FileInputStream(f);
                while ((len = fis.read(buf)) > 0) {
                    zos.write(buf, 0, len);
                }
                fis.close();
                zos.closeEntry();
            }
            catch (IOException e) {
                throw XQERuntimeException.wrap(e);
            }
        }
    }

    private File getLogDirectory(RequestEnvironment reqEnv) {
        String requestId = reqEnv.getRequestID();
        String subRequestId = reqEnv.getSubRequestID();
        if (requestId == null) {
            throw new XQERuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "RequestId was null");
        }
        boolean isSubRequest = TraceLogManager.isSubRequest(requestId, subRequestId);
        StringBuffer sb = new StringBuffer();
        File dir = null;
        dir = isSubRequest ? this.directoryMap.get(subRequestId) : this.directoryMap.get(requestId);
        if (dir != null) {
            return dir;
        }
        File fd = null;
        if (isSubRequest) {
            dir = this.directoryMap.get(requestId);
            if (dir == null) {
                dir = this.createRequestDirectory(reqEnv);
            }
            sb.append("subqueries");
            sb.append(File.separatorChar);
            fd = this.createDirectory(dir, subRequestId, sb.toString(), reqEnv);
        } else {
            fd = this.createRequestDirectory(reqEnv);
        }
        return fd;
    }

    private File createRequestDirectory(RequestEnvironment reqEnv) {
        String requestId = reqEnv.getRequestID();
        StringBuffer sb = new StringBuffer();
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.AURORA);
        sb.append(configuration.getXqeLogsDirectory());
        sb.append(File.separatorChar);
        return this.createDirectory(null, requestId, sb.toString(), reqEnv);
    }

    private File createDirectory(File baseDir, String contextId, String path, RequestEnvironment reqEnv) {
        StringBuffer sb = new StringBuffer();
        if (baseDir == null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH'h'mm'm'SS's'");
            Date d = new Date();
            sb.append(dateFormat.format(d));
        } else {
            sb.append(TraceLogManager.escapeName(contextId));
        }
        File dir = null;
        if (baseDir != null) {
            dir = new File(baseDir, path);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            dir = new File(dir, sb.toString());
        } else {
            dir = new File(path, sb.toString());
        }
        dir.mkdirs();
        this.directoryMap.put(contextId, dir);
        this.getOrCreateManifest(contextId, true);
        return dir;
    }

    private void writeElementWithUnknown(XMLMemento memento, String tag, String value) {
        IMemento reportElement = memento.createChild(tag);
        if (value == null) {
            reportElement.putTextData(UNKNOWN);
        } else {
            reportElement.putTextData(value);
        }
    }

    public static String escapeName(String name) {
        return name.replaceAll("[&\\\\/<>\\?\\s\\*:]", CONTROL_REPLACE).replace("\"", CONTROL_REPLACE);
    }

    private Writer createTraceOutputWriter(RequestEnvironment reqEnv, boolean isTracing, String logFileName) {
        if (isTracing) {
            File logDir = this.getLogDirectory(reqEnv);
            File logFile = new File(logDir, logFileName);
            return new TraceLogWriter(logFile);
        }
        return null;
    }

    public void setSubqueryInfo(RequestEnvironment reqEnv, String subqueryType, String subqueryName) {
        this.setManifestProperty(reqEnv, "subqueryName", subqueryName);
        this.setManifestProperty(reqEnv, "subqueryType", subqueryType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeTrace(RequestEnvironment reqEnv) {
        File dir = this.getLogDirectory(reqEnv);
        if (dir == null) {
            throw new XQERuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "No log directory");
        }
        File manifestFile = new File(dir, "manifest.xml");
        if (!manifestFile.exists()) {
            Manifest m;
            String id = reqEnv.getRequestID();
            if (TraceLogManager.isSubRequest(reqEnv.getRequestID(), reqEnv.getSubRequestID())) {
                id = reqEnv.getSubRequestID();
            }
            if ((m = this.getOrCreateManifest(id, false)) == null) {
                throw new XQERuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "No manifest found for request " + id);
            }
            try {
                m.dumpFile(reqEnv, manifestFile);
            }
            finally {
                this.removeManifest(m);
            }
        }
    }

    public void setManifestProperty(RequestEnvironment requestEnvironment, String propertyName, String propertyValue) {
        if (!this.isValidEnvironment(requestEnvironment)) {
            return;
        }
        this.getManifest(requestEnvironment).setProperty(propertyName, propertyValue);
    }

    private Manifest getManifest(RequestEnvironment requestEnvironment) {
        String requestEnvironmentId = requestEnvironment.getRequestID();
        if (TraceLogManager.isSubRequest(requestEnvironment.getRequestID(), requestEnvironment.getSubRequestID())) {
            requestEnvironmentId = requestEnvironment.getSubRequestID();
        }
        return this.getOrCreateManifest(requestEnvironmentId, true);
    }

    private Manifest getOrCreateManifest(String id, boolean create) {
        if (create) {
            Manifest manifest = new Manifest();
            Manifest current = this.manifestMap.putIfAbsent(id, manifest);
            if (current == null) {
                return manifest;
            }
            return current;
        }
        return this.manifestMap.get(id);
    }

    private void removeManifest(Manifest m) {
        this.manifestMap.remove(m);
    }

    private boolean isValidEnvironment(RequestEnvironment requestEnvironment) {
        if (requestEnvironment == null) {
            return false;
        }
        if (requestEnvironment.getRequestID() == null) {
            return false;
        }
        return QueryEngineLoggingUtils.isTracingEnabled(requestEnvironment);
    }

    private class Manifest {
        public static final String SUBQUERY_TYPE = "subqueryType";
        public static final String SUBQUERY_NAME = "subqueryName";
        private final Map<String, String> properties = new HashMap<String, String>();

        private Manifest() {
        }

        void dumpFile(RequestEnvironment reqEnv, File logFileManifest) {
            OutputStreamWriter writer = null;
            try {
                XMLMemento memento = XMLMemento.createWriteRoot("xqetraceInfo");
                IMemento date = memento.createChild("date");
                date.putTextData(DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(new Date()));
                IMemento logVersion = memento.createChild("logVersion");
                logVersion.putTextData(TraceLogManager.LOG_VERSION);
                TraceLogManager.this.writeElementWithUnknown(memento, "requestId", reqEnv.getRequestID());
                if (reqEnv.getSubRequestID() != null) {
                    TraceLogManager.this.writeElementWithUnknown(memento, "subRequestId", reqEnv.getSubRequestID());
                }
                TraceLogManager.this.writeElementWithUnknown(memento, "version", QueryEngine.class.getPackage().getImplementationVersion());
                if (!this.properties.isEmpty()) {
                    IMemento subqueryMememto = memento.createChild("properties");
                    for (String propertyName : this.properties.keySet()) {
                        IMemento subqueryNameMemento = subqueryMememto.createChild(propertyName);
                        subqueryNameMemento.putTextData(this.properties.get(propertyName));
                    }
                }
                writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(logFileManifest)), "UTF-8");
                memento.save(writer);
            }
            catch (IOException e) {
                throw XQERuntimeException.wrap(e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        throw XQERuntimeException.wrap(e);
                    }
                }
            }
        }

        void setProperty(String propertyName, String propertyValue) {
            this.properties.put(propertyName, propertyValue);
        }
    }
}

