/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.trace;

import com.ibm.cognos.aurora.core.xml.XMLWriter;
import java.util.Iterator;
import java.util.Stack;

public final class XQETrace
extends XMLWriter {
    private boolean mPushOntoStack;
    private Stack<XQETraceObject> mTraceStack;
    protected int mTraceLevel = 0;

    public void addTraceLevel(int level) {
        this.mTraceLevel |= level;
    }

    public void removeTraceLevel(int level) {
        this.mTraceLevel &= ~level;
    }

    public int getTraceLevel() {
        return this.mTraceLevel;
    }

    public void resetTraceLevels() {
        this.mTraceLevel = 0;
    }

    public void setTraceLevelAll() {
        this.mTraceLevel = -1;
    }

    public boolean isEnable(int level) {
        return (this.mTraceLevel & level) != 0;
    }

    public void beginElement(int level, String name, int id) {
        if (level == 0 || (level & this.mTraceLevel) != 0) {
            if (this.deferringTraceStatements()) {
                this.push(new XQETraceBeginElement(this, name, id));
            } else {
                super.beginElement(name, id);
            }
        }
    }

    public void beginElement(int level, String name, Integer id) {
        if (level == 0 || (level & this.mTraceLevel) != 0) {
            if (this.deferringTraceStatements()) {
                this.push(new XQETraceBeginElement(this, name, id));
            } else {
                super.beginElement(name, id);
            }
        }
    }

    public void endElement(int level) {
        if (level == 0 || (level & this.mTraceLevel) != 0) {
            if (this.deferringTraceStatements()) {
                this.push(new XQETraceEndElement(this));
            } else {
                super.endElement();
            }
        }
    }

    public void data(int level, String data) {
        if (level == 0 || (level & this.mTraceLevel) != 0) {
            if (this.deferringTraceStatements()) {
                this.push(new XQETraceCData(this, data));
            } else {
                super.data(data);
            }
        }
    }

    public void property(int level, String name, boolean value) {
        if (level == 0 || (level & this.mTraceLevel) != 0) {
            if (this.deferringTraceStatements()) {
                this.push(new XQETraceProperty(this, name, String.valueOf(value)));
            } else {
                super.property(name, value);
            }
        }
    }

    public void property(int level, String name, String value) {
        if (level == 0 || (level & this.mTraceLevel) != 0) {
            if (this.deferringTraceStatements()) {
                this.push(new XQETraceProperty(this, name, value));
            } else {
                super.property(name, value);
            }
        }
    }

    public void property(int level, String name, int value) {
        if (level == 0 || (level & this.mTraceLevel) != 0) {
            if (this.deferringTraceStatements()) {
                this.push(new XQETraceProperty(this, name, String.valueOf(value)));
            } else {
                super.property(name, String.valueOf(value));
            }
        }
    }

    public void property(int level, String name, float value) {
        if (level == 0 || (level & this.mTraceLevel) != 0) {
            if (this.deferringTraceStatements()) {
                this.push(new XQETraceProperty(this, name, String.valueOf(value)));
            } else {
                super.property(name, String.valueOf(value));
            }
        }
    }

    public void property(int level, String name, double value) {
        if (level == 0 || (level & this.mTraceLevel) != 0) {
            if (this.deferringTraceStatements()) {
                this.push(new XQETraceProperty(this, name, String.valueOf(value)));
            } else {
                super.property(name, String.valueOf(value));
            }
        }
    }

    public void attribute(int level, String name, String value) {
        if (level == 0 || (level & this.mTraceLevel) != 0) {
            if (this.deferringTraceStatements()) {
                this.push(new XQETraceAttribute(this, name, value));
            } else {
                super.attribute(name, value);
            }
        }
    }

    public void attribute(int level, String name, int value) {
        if (level == 0 || (level & this.mTraceLevel) != 0) {
            if (this.deferringTraceStatements()) {
                this.push(new XQETraceAttribute(this, name, String.valueOf(value)));
            } else {
                super.attribute(name, String.valueOf(value));
            }
        }
    }

    public void attribute(int level, String name, long value) {
        if (level == 0 || (level & this.mTraceLevel) != 0) {
            if (this.deferringTraceStatements()) {
                this.push(new XQETraceAttribute(this, name, String.valueOf(value)));
            } else {
                super.attribute(name, String.valueOf(value));
            }
        }
    }

    public void attribute(int level, String name, float value) {
        if (level == 0 || (level & this.mTraceLevel) != 0) {
            if (this.deferringTraceStatements()) {
                this.push(new XQETraceAttribute(this, name, String.valueOf(value)));
            } else {
                super.attribute(name, String.valueOf(value));
            }
        }
    }

    public void attribute(int level, String name, double value) {
        if (level == 0 || (level & this.mTraceLevel) != 0) {
            if (this.deferringTraceStatements()) {
                this.push(new XQETraceAttribute(this, name, String.valueOf(value)));
            } else {
                super.attribute(name, String.valueOf(value));
            }
        }
    }

    public void attribute(int level, String name, boolean value) {
        if (level == 0 || (level & this.mTraceLevel) != 0) {
            if (this.deferringTraceStatements()) {
                this.push(new XQETraceAttribute(this, name, String.valueOf(value)));
            } else {
                super.attribute(name, String.valueOf(value));
            }
        }
    }

    public void attribute(int level, String name, Object value) {
        if (level == 0 || (level & this.mTraceLevel) != 0) {
            if (this.deferringTraceStatements()) {
                this.push(new XQETraceAttribute(this, name, String.valueOf(value)));
            } else {
                super.attribute(name, String.valueOf(value));
            }
        }
    }

    @Override
    public void beginElement(String name, Integer id) {
        this.beginElement(0, name, (int)id);
    }

    @Override
    public void beginElement(String name, int id) {
        this.beginElement(0, name, id);
    }

    @Override
    public void beginElement(String name) {
        this.beginElement(0, name, -1);
    }

    @Override
    public void endElement() {
        this.endElement(0);
    }

    @Override
    public void data(String data) {
        this.data(0, data);
    }

    @Override
    public void property(String name, String value) {
        this.property(0, name, value);
    }

    @Override
    public void property(String name, int value) {
        this.property(0, name, value);
    }

    @Override
    public void property(String name, float value) {
        this.property(0, name, value);
    }

    @Override
    public void property(String name, double value) {
        this.property(0, name, value);
    }

    @Override
    public void property(String name, boolean value) {
        this.property(0, name, value);
    }

    @Override
    public void attribute(String name, String value) {
        this.attribute(0, name, value);
    }

    @Override
    public void attribute(String name, int value) {
        this.attribute(0, name, value);
    }

    @Override
    public void attribute(String name, long value) {
        this.attribute(0, name, value);
    }

    @Override
    public void attribute(String name, float value) {
        this.attribute(0, name, value);
    }

    @Override
    public void attribute(String name, double value) {
        this.attribute(0, name, value);
    }

    @Override
    public void attribute(String name, boolean value) {
        this.attribute(0, name, value);
    }

    @Override
    public void attribute(String name, Object value) {
        this.attribute(0, name, value);
    }

    public void deferTracing() {
        this.mPushOntoStack = true;
        if (this.mTraceStack == null) {
            this.mTraceStack = new Stack();
        }
        this.mTraceStack.push(new XQETraceFramePointer());
    }

    private boolean deferringTraceStatements() {
        return this.mPushOntoStack;
    }

    private void push(XQETraceObject object) {
        this.mTraceStack.add(object);
    }

    public void traceDeferredStatements() {
        if (this.mTraceStack == null || this.mTraceStack.size() == 0) {
            return;
        }
        this.mPushOntoStack = false;
        Iterator it = this.mTraceStack.iterator();
        while (it.hasNext()) {
            ((XQETraceObject)it.next()).writeToTrace();
        }
        this.mTraceStack.clear();
    }

    public void deleteDeferredTraceStatements() {
        XQETraceObject object;
        if (this.mTraceStack == null || this.mTraceStack.size() == 0) {
            return;
        }
        while (!(object = this.mTraceStack.pop()).isStackFramePointer()) {
        }
        if (this.mTraceStack.size() == 0) {
            this.mPushOntoStack = false;
        }
    }

    private class XQETraceFramePointer
    extends XQETraceObject {
        protected XQETraceFramePointer() {
            super(null);
        }

        @Override
        protected void writeToTrace() {
        }

        @Override
        protected boolean isStackFramePointer() {
            return true;
        }
    }

    private class XQETraceCData
    extends XQETraceObject {
        XQETraceCData(XQETrace parent, String data) {
            super(parent);
            this.setValue(data);
        }

        @Override
        protected void writeToTrace() {
            this.getParentTraceObject().data(this.getValue());
        }
    }

    private class XQETraceAttribute
    extends XQETraceObject {
        XQETraceAttribute(XQETrace parent, String name, String value) {
            super(parent);
            this.setName(name);
            this.setValue(value);
        }

        @Override
        protected void writeToTrace() {
            this.getParentTraceObject().attribute(this.getName(), this.getValue());
        }
    }

    private class XQETraceProperty
    extends XQETraceObject {
        XQETraceProperty(XQETrace parent, String name, String value) {
            super(parent);
            this.setName(name);
            this.setValue(value);
        }

        @Override
        protected void writeToTrace() {
            this.getParentTraceObject().property(this.getName(), this.getValue());
        }
    }

    private class XQETraceEndElement
    extends XQETraceObject {
        XQETraceEndElement(XQETrace parent) {
            super(parent);
        }

        @Override
        protected void writeToTrace() {
            this.getParentTraceObject().endElement();
        }
    }

    private class XQETraceBeginElement
    extends XQETraceObject {
        private final int mNodeId;

        XQETraceBeginElement(XQETrace parent, String name, int id) {
            super(parent);
            this.setName(name);
            this.mNodeId = id;
        }

        @Override
        protected void writeToTrace() {
            this.getParentTraceObject().beginElement(this.getName(), this.mNodeId);
        }
    }

    private abstract class XQETraceObject {
        private String mName;
        private String mValue;
        private final XQETrace mParent;

        protected XQETraceObject(XQETrace parent) {
            this.mParent = parent;
        }

        protected XQETrace getParentTraceObject() {
            return this.mParent;
        }

        protected void setName(String name) {
            this.mName = name;
        }

        protected String getName() {
            return this.mName;
        }

        protected void setValue(String value) {
            this.mValue = value;
        }

        protected String getValue() {
            return this.mValue;
        }

        protected abstract void writeToTrace();

        protected boolean isStackFramePointer() {
            return false;
        }
    }
}

