/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract;

import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.core.bvt.IBVTableAppender;
import com.ibm.cognos.aurora.core.extract.DataTypeResolver;
import com.ibm.cognos.aurora.core.extract.TabularDataset;
import java.io.IOException;

public class TabularDatasetAppender {
    private final TabularDataset.ColumnInfo[] mColumns;
    private final DataTypeResolver[] mDataTypeResolvers;
    private final IBVTableAppender mTableAppender;

    protected TabularDatasetAppender(TabularDataset.ColumnInfo[] columns, IBVTableAppender tableAppender) {
        this.mColumns = columns;
        this.mTableAppender = tableAppender;
        this.mDataTypeResolvers = new DataTypeResolver[this.mColumns.length];
        for (int i = 0; i < this.mColumns.length; ++i) {
            this.mDataTypeResolvers[i] = new DataTypeResolver(this.mColumns[i]);
        }
    }

    public void appendRow(IValue[] row) {
        try {
            this.mTableAppender.appendRow(row);
        }
        catch (IOException ex) {
            throw new ImportException((Throwable)ex);
        }
        for (int i = 0; i < row.length; ++i) {
            IValue colValue = row[i];
            TabularDataset.ColumnInfo colInfo = this.mColumns[i];
            if (null != colValue && colValue.isOK()) {
                colInfo.incrementNonNullCount(1);
                this.mDataTypeResolvers[i].visit(colValue);
                continue;
            }
            colInfo.incrementNullCount(1);
        }
    }

    public void close() {
        try {
            this.mTableAppender.close();
        }
        catch (IOException ex) {
            throw new ImportException((Throwable)ex);
        }
        for (DataTypeResolver r : this.mDataTypeResolvers) {
            r.resolve();
        }
    }
}

