/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.DateValue;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.TimestampValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.core.extract.ExtractionContext;
import com.ibm.cognos.aurora.core.extract.TabularDataset;
import com.ibm.cognos.aurora.core.extract.TabularDatasetAppender;
import com.ibm.cognos.aurora.core.extract.TabularExtracter;
import com.ibm.cognos.aurora.core.util.UniqueNameSet;
import com.ibm.xml.xapi.XMessageHandler;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.BasicMutableDynamicContext;
import com.ibm.xml.xci.exec.BasicStaticContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.ErrorHandler;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.SourceLocation;
import com.ibm.xml.xci.exec.StaticContext;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class XMLExtracter
extends TabularExtracter {
    private File mLocalDataFile;
    private SessionContext session;
    private ErrorHandler eHandler;
    private StaticContext staticCxt;
    private Executable qExpr;
    private Map<Integer, String> fieldNames = new HashMap<Integer, String>();
    private Map<Integer, BaseDataType> fieldTypes = new HashMap<Integer, BaseDataType>();

    public XMLExtracter(File localDataFile) {
        this.mLocalDataFile = localDataFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractDatasets(ExtractionContext context) {
        context.setDataSourceType("XMLFile");
        UniqueNameSet uniqueFieldNames = new UniqueNameSet();
        this.session = new SessionContext(this.getClass().getClassLoader());
        this.eHandler = new XMLErrorHandler();
        this.staticCxt = new BasicStaticContext(this.session.getTypeRegistry());
        this.staticCxt.setBaseURI(System.getProperty("user.dir"));
        this.staticCxt.setErrorHandler(this.eHandler);
        this.staticCxt.declareNamespace("ns", "http://developer.cognos.com/schemas/xmldata/1/");
        this.staticCxt.setLanguageTypeAndVersion(1);
        BasicMutableDynamicContext dynamicCxt = new BasicMutableDynamicContext(this.session, this.staticCxt);
        dynamicCxt.setErrorHandler(this.eHandler);
        String uri = "file:///" + this.mLocalDataFile.getAbsolutePath();
        String xQuery = String.format("for $r in doc(\"%1$s\")/ns:dataset/ns:metadata/ns:item return $r", uri);
        this.qExpr = this.session.getPreparer(RequestInfo.XQuery).prepare(xQuery, this.staticCxt, -1);
        Cursor result = this.qExpr.execute(null, (DynamicContext)dynamicCxt, Cursor.RANDOM_ACCESS, null);
        TabularDataset ds = context.createDataset("DataTable", "Unknown");
        int fieldIndex = 0;
        do {
            Cursor cursor = result.fork(true);
            cursor.toAttributes(null);
            String itemName = null;
            String itemType = null;
            String itemPrecision = null;
            do {
                String name = cursor.itemName().toString();
                String value = cursor.itemStringValue().toString();
                if (name.equals("name")) {
                    itemName = ExtractionContext.sanitizeLabelText(value);
                    continue;
                }
                if (name.equals("type")) {
                    itemType = value;
                    continue;
                }
                if (name.equals("length") || name.equals("scale") || !name.equals("precision")) continue;
                itemPrecision = value;
            } while (cursor.toNext());
            IDataType dType = DataTypes.fromXSDType((String)itemType, (int)Integer.valueOf(itemPrecision), (int)0);
            String fieldName = uniqueFieldNames.insert(itemName);
            this.fieldNames.put(fieldIndex, fieldName);
            this.fieldTypes.put(fieldIndex, dType.getBaseType());
            ds.addColumn(fieldName, dType);
            cursor.release();
            ++fieldIndex;
        } while (result.toNext());
        xQuery = String.format("for $r in doc(\"%1$s\")/ns:dataset/ns:data/ns:row return $r", uri);
        this.qExpr = this.session.getPreparer(RequestInfo.XQuery).prepare(xQuery, this.staticCxt, -1);
        this.staticCxt.setLanguageTypeAndVersion(3);
        Executable xPathExpr = this.session.getPreparer(RequestInfo.XPath2).prepare("ns:value", this.staticCxt, -1);
        result = this.qExpr.execute(null, (DynamicContext)dynamicCxt, Cursor.RANDOM_ACCESS, null);
        TabularDatasetAppender appender = ds.openAppender();
        IValue[] row = new IValue[ds.numColumns()];
        try {
            do {
                Cursor xPathCursor;
                if ((xPathCursor = result.fork(true)) == null) {
                    return;
                }
                xPathCursor.toSelf();
                Cursor cursor = xPathExpr.execute(xPathCursor, (DynamicContext)dynamicCxt, Cursor.RANDOM_ACCESS, null);
                for (int i = 0; i < row.length; ++i) {
                    row[i] = null;
                }
                fieldIndex = 0;
                do {
                    String data = cursor.itemStringValue().toString();
                    data = ExtractionContext.sanitizeDataText(data);
                    BaseDataType baseDataType = this.fieldTypes.get(fieldIndex);
                    DateValue value = null;
                    switch (baseDataType) {
                        case STRING: {
                            if (data.length() == 0) {
                                value = ValueFactory.createString((int)1);
                                break;
                            }
                            value = ValueFactory.createString((String)data);
                            break;
                        }
                        case INTEGER: {
                            if (data.length() == 0) {
                                value = ValueFactory.createInteger();
                                break;
                            }
                            value = ValueFactory.createInteger((Integer)Integer.valueOf(data));
                            break;
                        }
                        case LONG: {
                            if (data.length() == 0) {
                                value = ValueFactory.createLong();
                                break;
                            }
                            value = ValueFactory.createLong((Long)Long.valueOf(data));
                            break;
                        }
                        case DOUBLE: {
                            if (data.length() == 0) {
                                value = ValueFactory.createDouble();
                                break;
                            }
                            value = ValueFactory.createDouble((Double)Double.valueOf(data));
                            break;
                        }
                        case DATE: {
                            value = ValueFactory.createDate();
                            if (data.length() == 0) break;
                            value.assignFrom(data);
                            break;
                        }
                        case TIME: {
                            value = ValueFactory.createTime();
                            if (data.length() == 0) break;
                            value.assignFrom(data);
                            break;
                        }
                        case TIMESTAMP: {
                            value = new TimestampValue();
                            if (data.length() == 0) break;
                            value.assignFrom(data);
                            break;
                        }
                    }
                    row[fieldIndex] = value;
                    ++fieldIndex;
                } while (cursor.toNext());
                appender.appendRow(row);
                cursor.release();
                xPathCursor.release();
            } while (result.toNext());
        }
        finally {
            appender.close();
        }
    }

    @Override
    public void close() {
    }

    private class XMLErrorHandler
    implements ErrorHandler {
        private XMLErrorHandler() {
        }

        public void report(int id, XMessageHandler.MsgType level, String message, SourceLocation location, boolean terminate) {
            if (terminate) {
                throw new RuntimeException(message);
            }
        }

        public void report(int id, XMessageHandler.MsgType level, Throwable error, SourceLocation location, boolean terminate) {
            if (terminate) {
                throw new RuntimeException(error);
            }
        }
    }
}

