/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract.parser;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.model.value.decor.IValueDecoration;
import com.ibm.cognos.aurora.api.model.value.decor.ValueDecorations;
import com.ibm.cognos.aurora.core.extract.parser.ITextParser;
import com.ibm.cognos.aurora.core.extract.parser.ParseResult;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CurrencyParser
implements ITextParser {
    private static final char NON_BREAK_SPACE = '\u00a0';
    private static final char BREAK_SPACE = ' ';
    private static EnumSet<BaseDataType> NUMBER_TYPES = EnumSet.of(BaseDataType.FLOAT, BaseDataType.DOUBLE, BaseDataType.INTEGER, BaseDataType.LONG, BaseDataType.DECIMAL);
    private static final Pattern CURRENCY_CODE_PAT = Pattern.compile("(?:\\A|[^a-z^A-Z])([a-zA-Z]{3})(?:[^a-z^A-Z]|\\z)");
    private static final Pattern COUNTRY_CODE_PAT = Pattern.compile("(?:\\A|[^a-z^A-Z])([a-zA-Z]{2,3})(?:[^a-z^A-Z]|\\z)");
    private static final Pattern CURRENCY_SYMBOL_PAT = Pattern.compile("\\p{Sc}");
    private static final Map<String, Set<String>> CURRENCY_SYMBOL_TO_COUNTRIES = new HashMap<String, Set<String>>();
    private static final Set<String> ISO_CURRENCY_CODES = new HashSet<String>();
    private static final Set<String> ISO_LOCAL_CURRENCY_SYMBOLS = new HashSet<String>();
    private static final List<String> ISO2_COUNTRIES = new ArrayList<String>();
    private static final List<String> ISO3_COUNTRIES = new ArrayList<String>();
    private final DecimalFormatSymbols mFormatSymbols;
    private final DecimalFormat mFormat;

    public CurrencyParser(ULocale locale) {
        this(locale, null);
    }

    public CurrencyParser(ULocale locale, Currency currency) {
        this.mFormat = (DecimalFormat)DecimalFormat.getCurrencyInstance((ULocale)locale);
        this.mFormat.setParseBigDecimal(true);
        if (null != currency) {
            this.mFormat.setCurrency(currency);
        }
        this.mFormatSymbols = this.mFormat.getDecimalFormatSymbols();
    }

    public static Set<String> getAllLocalCurrencySymbols() {
        return Collections.unmodifiableSet(ISO_LOCAL_CURRENCY_SYMBOLS);
    }

    @Override
    public void parse(String text, ParseResult result) {
        this.parse(text, null, result);
    }

    @Override
    public void parse(String text, EnumSet<BaseDataType> tabooTypes, ParseResult result) {
        result.setValue(null);
        result.getDecorations().clear();
        if (null == text || text.length() == 0) {
            return;
        }
        if (null != tabooTypes && tabooTypes.containsAll(NUMBER_TYPES)) {
            return;
        }
        if ((text = text.trim()).length() == 0) {
            return;
        }
        if (text.charAt(0) == '+') {
            text = text.substring(1);
        }
        if (text.length() == 0) {
            return;
        }
        ParsePosition pos = new ParsePosition(0);
        com.ibm.icu.math.BigDecimal bd = (com.ibm.icu.math.BigDecimal)this.mFormat.parse(text, pos);
        while ((null == bd || pos.getIndex() != text.length()) && pos.getErrorIndex() >= 0 && pos.getErrorIndex() < text.length() && text.charAt(pos.getErrorIndex()) == ' ') {
            StringBuilder buf = new StringBuilder(text);
            buf.setCharAt(pos.getErrorIndex(), '\u00a0');
            text = buf.toString();
            pos.setIndex(0);
            bd = (com.ibm.icu.math.BigDecimal)this.mFormat.parse(text, pos);
        }
        if (null != bd && pos.getIndex() == text.length()) {
            BigDecimal javaBD = bd.toBigDecimal();
            int wholeDigits = javaBD.precision() - javaBD.scale();
            int newPrecision = wholeDigits + 4;
            result.setValue((IValue)ValueFactory.createDecimal((BigDecimal)javaBD.round(new MathContext(newPrecision))));
            result.getDecorations().add((IValueDecoration)ValueDecorations.getCurrencyDecoration((Currency)this.mFormatSymbols.getCurrency()));
            boolean groupingSepFound = false;
            int groupingSepPos = text.indexOf(this.mFormatSymbols.getGroupingSeparator());
            if (groupingSepPos != -1 && groupingSepPos > 0 && groupingSepPos < text.length() - 1 && Character.isDigit(text.charAt(groupingSepPos - 1)) && Character.isDigit(text.charAt(groupingSepPos + 1))) {
                groupingSepFound = true;
                result.getDecorations().add((IValueDecoration)ValueDecorations.geThousandsSeparatorDecoration((char)this.mFormatSymbols.getGroupingSeparator()));
            }
            if (!groupingSepFound && this.mFormatSymbols.getGroupingSeparator() == '\u00a0' && (groupingSepPos = text.indexOf(32)) != -1 && groupingSepPos > 0 && groupingSepPos < text.length() - 1 && Character.isDigit(text.charAt(groupingSepPos - 1)) && Character.isDigit(text.charAt(groupingSepPos + 1))) {
                groupingSepFound = true;
                result.getDecorations().add((IValueDecoration)ValueDecorations.geThousandsSeparatorDecoration((char)this.mFormatSymbols.getGroupingSeparator()));
            }
        }
    }

    public static Set<Currency> extractCurrencies(String text) {
        Set<Currency> currByCode = CurrencyParser.extractCurrenciesByCode(text);
        Set<Currency> currBySymbolCountry = CurrencyParser.extractCurrenciesBySymbolAndCountry(text);
        if (currByCode.isEmpty()) {
            return currBySymbolCountry;
        }
        if (!currBySymbolCountry.isEmpty()) {
            currByCode.retainAll(currBySymbolCountry);
        }
        return currByCode;
    }

    private static Set<Currency> extractCurrenciesByCode(String text) {
        HashSet<Currency> matched = new HashSet<Currency>();
        Matcher m = CURRENCY_CODE_PAT.matcher(text);
        while (m.find()) {
            String match = m.group(1).toUpperCase();
            try {
                if (ISO_CURRENCY_CODES.contains(match)) {
                    matched.add(Currency.getInstance((String)match));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            m.region(m.end(1), m.regionEnd());
        }
        return matched;
    }

    private static Set<Currency> extractCurrenciesBySymbolAndCountry(String text) {
        HashSet<Currency> matched = new HashSet<Currency>();
        Set<String> countriesByCode = CurrencyParser.extractCountriesByCode(text);
        Set<String> countriesBySymbol = CurrencyParser.extractCountriesByCurrencySymbol(text);
        if (!countriesByCode.isEmpty()) {
            for (String country : countriesByCode) {
                ULocale locale = new ULocale("", country);
                Currency cur = Currency.getInstance((ULocale)locale);
                if (!countriesBySymbol.isEmpty() && !countriesBySymbol.contains(country)) continue;
                matched.add(cur);
            }
        } else {
            for (String country : countriesBySymbol) {
                ULocale locale = new ULocale("", country);
                matched.add(Currency.getInstance((ULocale)locale));
            }
        }
        return matched;
    }

    private static Set<String> extractCountriesByCode(String text) {
        HashSet<String> matched = new HashSet<String>();
        Matcher m = COUNTRY_CODE_PAT.matcher(text);
        while (m.find()) {
            String country = m.group(1);
            if (country.length() == 3) {
                int index = ISO3_COUNTRIES.indexOf(country);
                if (index != -1) {
                    matched.add(ISO2_COUNTRIES.get(index));
                }
            } else if (country.length() == 2 && ISO2_COUNTRIES.contains(country)) {
                matched.add(country);
            }
            m.region(m.end(1), m.regionEnd());
        }
        return matched;
    }

    private static Set<String> extractCountriesByCurrencySymbol(String text) {
        HashSet<String> matched = new HashSet<String>();
        Matcher m = CURRENCY_SYMBOL_PAT.matcher(text);
        while (m.find()) {
            String symbol = m.group();
            if (!CURRENCY_SYMBOL_TO_COUNTRIES.containsKey(symbol)) continue;
            matched.addAll((Collection<String>)CURRENCY_SYMBOL_TO_COUNTRIES.get(symbol));
        }
        return matched;
    }

    static {
        for (ULocale locale : Currency.getAvailableULocales()) {
            Currency cur = Currency.getInstance((ULocale)locale);
            if (null == cur) continue;
            ISO_CURRENCY_CODES.add(cur.getCurrencyCode());
            ISO2_COUNTRIES.add(locale.getCountry());
            ISO3_COUNTRIES.add(locale.getISO3Country());
            Set<String> countries = CURRENCY_SYMBOL_TO_COUNTRIES.get(cur.getSymbol(locale));
            if (null == countries) {
                countries = new HashSet<String>();
                CURRENCY_SYMBOL_TO_COUNTRIES.put(cur.getSymbol(locale), countries);
            }
            countries.add(locale.getCountry());
        }
        ISO_LOCAL_CURRENCY_SYMBOLS.addAll(CURRENCY_SYMBOL_TO_COUNTRIES.keySet());
    }
}

