/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract.parser;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.core.extract.parser.DateTimeParser;
import com.ibm.cognos.aurora.core.extract.parser.ParseResult;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.text.ParsePosition;
import java.util.EnumSet;

public class DateParser
extends DateTimeParser {
    private final DateFormat[] mLocalizedFormats = new DateFormat[7];

    public DateParser(ULocale locale) {
        super(locale);
        this.mLocalizedFormats[0] = DateFormat.getDateInstance((Calendar)this.mLocalizedCalendar, (int)3, (ULocale)locale);
        this.mLocalizedFormats[1] = DateFormat.getDateInstance((Calendar)this.mLocalizedCalendar, (int)2, (ULocale)locale);
        this.mLocalizedFormats[2] = DateFormat.getDateInstance((Calendar)this.mLocalizedCalendar, (int)1, (ULocale)locale);
        this.mLocalizedFormats[3] = DateFormat.getDateInstance((Calendar)this.mLocalizedCalendar, (int)0, (ULocale)locale);
        this.mLocalizedFormats[4] = new SimpleDateFormat("dd-MM-yy", locale);
        this.mLocalizedFormats[4].setCalendar(this.mLocalizedCalendar);
        this.mLocalizedFormats[5] = new SimpleDateFormat("dd-MMM-yy", locale);
        this.mLocalizedFormats[5].setCalendar(this.mLocalizedCalendar);
        this.mLocalizedFormats[6] = new SimpleDateFormat("dd/MM/yy", locale);
        this.mLocalizedFormats[6].setCalendar(this.mLocalizedCalendar);
    }

    @Override
    public void parse(String text, EnumSet<BaseDataType> tabooTypes, ParseResult result) {
        result.setValue(null);
        result.getDecorations().clear();
        if (null == text || text.length() == 0) {
            return;
        }
        if (null != tabooTypes && tabooTypes.contains(BaseDataType.DATE)) {
            return;
        }
        text = text.trim();
        ParsePosition pp = new ParsePosition(0);
        if (text.length() == 7) {
            if (this.parseISO8601Date(this.mISO8601_YYYY_MM, text, pp, result)) {
                return;
            }
            if (this.parseISO8601Date(this.mISO8601_YYYYWww, text, pp, result)) {
                return;
            }
        } else if (text.length() == 8) {
            if (this.parseISO8601Date(this.mISO8601_YYYY_DDD, text, pp, result)) {
                return;
            }
            if (this.parseISO8601Date(this.mISO8601_YYYY_Www, text, pp, result)) {
                return;
            }
            if (this.parseISO8601Date(this.mISO8601_YYYYWwwD, text, pp, result)) {
                return;
            }
        } else if (text.length() == 10) {
            if (this.parseISO8601Date(this.mISO8601_YYYY_MM_DD, text, pp, result)) {
                return;
            }
            if (this.parseISO8601Date(this.mISO8601_YYYY_Www_D, text, pp, result)) {
                return;
            }
        }
        for (int i = 0; i < this.mLocalizedFormats.length; ++i) {
            DateFormat format = this.mLocalizedFormats[i];
            if (!this.parseLocalizedDate(format, text, pp, result)) continue;
            if (i > 0) {
                this.mLocalizedFormats[i] = this.mLocalizedFormats[i - 1];
                this.mLocalizedFormats[i - 1] = format;
            }
            return;
        }
    }
}

