/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract.parser;

import com.ibm.cognos.aurora.api.model.value.DateTimeValue;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.core.extract.parser.ITextParser;
import com.ibm.cognos.aurora.core.extract.parser.ParseResult;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.text.ParsePosition;
import java.util.Locale;

public abstract class DateTimeParser
implements ITextParser {
    protected final Calendar mISO8601Calendar = DateTimeValue.getISO8601Calendar();
    protected final Calendar mLocalizedCalendar;
    protected final DateFormat mISO8601_YYYY_MM;
    protected final DateFormat mISO8601_YYYYMMDD;
    protected final DateFormat mISO8601_YYYY_MM_DD;
    protected final DateFormat mISO8601_YYYY_DDD;
    protected final DateFormat mISO8601_YYYYDDD;
    protected final DateFormat mISO8601_YYYY_Www;
    protected final DateFormat mISO8601_YYYYWww;
    protected final DateFormat mISO8601_YYYY_Www_D;
    protected final DateFormat mISO8601_YYYYWwwD;
    protected final DateFormat mISO8601_HH_mm;
    protected final DateFormat mISO8601_HH_mm_ss;
    protected final DateFormat mISO8601_HH_mm_Extended;
    protected final DateFormat mISO8601_HH_mm_ss_Extended;

    public DateTimeParser(ULocale locale) {
        this.mISO8601Calendar.setLenient(false);
        this.mISO8601_YYYY_MM = new SimpleDateFormat("yyyy-MM", Locale.US);
        this.mISO8601_YYYY_MM.setCalendar(this.mISO8601Calendar);
        this.mISO8601_YYYYMMDD = new SimpleDateFormat("yyyyMMdd", Locale.US);
        this.mISO8601_YYYYMMDD.setCalendar(this.mISO8601Calendar);
        this.mISO8601_YYYY_MM_DD = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        this.mISO8601_YYYY_MM_DD.setCalendar(this.mISO8601Calendar);
        this.mISO8601_YYYY_DDD = new SimpleDateFormat("yyyy-DDD", Locale.US);
        this.mISO8601_YYYY_DDD.setCalendar(this.mISO8601Calendar);
        this.mISO8601_YYYYDDD = new SimpleDateFormat("yyyyDDD", Locale.US);
        this.mISO8601_YYYYDDD.setCalendar(this.mISO8601Calendar);
        this.mISO8601_YYYY_Www = new SimpleDateFormat("YYYY-'W'ww", Locale.US);
        this.mISO8601_YYYY_Www.setCalendar(this.mISO8601Calendar);
        this.mISO8601_YYYYWww = new SimpleDateFormat("YYYY'W'ww", Locale.US);
        this.mISO8601_YYYYWww.setCalendar(this.mISO8601Calendar);
        this.mISO8601_YYYY_Www_D = new SimpleDateFormat("YYYY-'W'ww-e", Locale.US);
        this.mISO8601_YYYY_Www_D.setCalendar(this.mISO8601Calendar);
        this.mISO8601_YYYYWwwD = new SimpleDateFormat("YYYY'W'wwe", Locale.US);
        this.mISO8601_YYYYWwwD.setCalendar(this.mISO8601Calendar);
        this.mISO8601_HH_mm = new SimpleDateFormat("HHmm", Locale.US);
        this.mISO8601_HH_mm.setCalendar(this.mISO8601Calendar);
        this.mISO8601_HH_mm_ss = new SimpleDateFormat("HHmmss", Locale.US);
        this.mISO8601_HH_mm_ss.setCalendar(this.mISO8601Calendar);
        this.mISO8601_HH_mm_Extended = new SimpleDateFormat("HH:mm", Locale.US);
        this.mISO8601_HH_mm_Extended.setCalendar(this.mISO8601Calendar);
        this.mISO8601_HH_mm_ss_Extended = new SimpleDateFormat("HH:mm:ss", Locale.US);
        this.mISO8601_HH_mm_ss_Extended.setCalendar(this.mISO8601Calendar);
        this.mLocalizedCalendar = Calendar.getInstance((ULocale)locale);
        this.mLocalizedCalendar.setLenient(false);
    }

    @Override
    public final void parse(String text, ParseResult result) {
        this.parse(text, null, result);
    }

    protected final boolean parseISO8601Timestamp(DateFormat dateFormat, String text, ParsePosition pp, ParseResult result) {
        int tpos = text.indexOf(84);
        if (tpos == -1) {
            return false;
        }
        text = text.trim();
        String dateStr = text.substring(0, tpos);
        String timeStr = text.substring(tpos + 1);
        this.mISO8601Calendar.clear();
        this.mISO8601Calendar.setTimeZone(TimeZone.getDefault());
        if (!DateTimeParser.parseFormat(this.mISO8601Calendar, dateFormat, dateStr, pp)) {
            return false;
        }
        if (this.parseISO8601Time(this.mISO8601_HH_mm, timeStr, pp, null)) {
            result.setValue((IValue)ValueFactory.createTimestamp((Calendar)this.mISO8601Calendar));
            return true;
        }
        if (this.parseISO8601Time(this.mISO8601_HH_mm_Extended, timeStr, pp, null)) {
            result.setValue((IValue)ValueFactory.createTimestamp((Calendar)this.mISO8601Calendar));
            return true;
        }
        if (this.parseISO8601Time(this.mISO8601_HH_mm_ss, timeStr, pp, null)) {
            result.setValue((IValue)ValueFactory.createTimestamp((Calendar)this.mISO8601Calendar));
            return true;
        }
        if (this.parseISO8601Time(this.mISO8601_HH_mm_ss_Extended, timeStr, pp, null)) {
            result.setValue((IValue)ValueFactory.createTimestamp((Calendar)this.mISO8601Calendar));
            return true;
        }
        return false;
    }

    protected final boolean parseISO8601Time(DateFormat format, String text, ParsePosition pp, ParseResult result) {
        int rawOffset;
        this.mISO8601Calendar.clear(11);
        this.mISO8601Calendar.clear(12);
        this.mISO8601Calendar.clear(13);
        this.mISO8601Calendar.clear(14);
        this.mISO8601Calendar.clear(9);
        this.mISO8601Calendar.clear(16);
        this.mISO8601Calendar.setTimeZone(TimeZone.getDefault());
        int tzPos = text.indexOf(90);
        if (-1 != tzPos) {
            this.mISO8601Calendar.setTimeZone(DateTimeValue.TIMEZONE_UTC);
            if (DateTimeParser.parseFormat(this.mISO8601Calendar, format, text.substring(0, tzPos), pp)) {
                if (null != result) {
                    result.setValue((IValue)ValueFactory.createTime((Calendar)this.mISO8601Calendar));
                }
                return true;
            }
        }
        if (-1 != (tzPos = text.indexOf(43)) && Integer.MIN_VALUE != (rawOffset = this.parseISO8601TimeZoneOffset(text.substring(tzPos + 1)))) {
            this.mISO8601Calendar.setTimeZone(DateTimeValue.getTimeZoneFromRawOffset((int)rawOffset));
            if (DateTimeParser.parseFormat(this.mISO8601Calendar, format, text.substring(0, tzPos), pp)) {
                if (null != result) {
                    result.setValue((IValue)ValueFactory.createTime((Calendar)this.mISO8601Calendar));
                }
                return true;
            }
        }
        if (-1 != (tzPos = text.indexOf(45)) && Integer.MIN_VALUE != (rawOffset = this.parseISO8601TimeZoneOffset(text.substring(tzPos + 1)))) {
            this.mISO8601Calendar.setTimeZone(DateTimeValue.getTimeZoneFromRawOffset((int)(-rawOffset)));
            if (DateTimeParser.parseFormat(this.mISO8601Calendar, format, text.substring(0, tzPos), pp)) {
                if (null != result) {
                    result.setValue((IValue)ValueFactory.createTime((Calendar)this.mISO8601Calendar));
                }
                return true;
            }
        }
        if (DateTimeParser.parseFormat(this.mISO8601Calendar, format, text, pp)) {
            if (null != result) {
                result.setValue((IValue)ValueFactory.createTime((Calendar)this.mISO8601Calendar));
            }
            return true;
        }
        return false;
    }

    protected final int parseISO8601TimeZoneOffset(String text) {
        Calendar tempCal = (Calendar)this.mISO8601Calendar.clone();
        tempCal.setTimeZone(DateTimeValue.TIMEZONE_UTC);
        tempCal.setLenient(false);
        ParsePosition pp = new ParsePosition(0);
        tempCal.clear();
        if (DateTimeParser.parseFormat(tempCal, this.mISO8601_HH_mm_Extended, text, pp)) {
            return (int)tempCal.getTimeInMillis();
        }
        tempCal.clear();
        if (DateTimeParser.parseFormat(tempCal, this.mISO8601_HH_mm, text, pp)) {
            return (int)tempCal.getTimeInMillis();
        }
        return Integer.MIN_VALUE;
    }

    protected final boolean parseISO8601Date(DateFormat format, String text, ParsePosition pp, ParseResult result) {
        this.mISO8601Calendar.clear();
        this.mISO8601Calendar.setTimeZone(TimeZone.getDefault());
        if (DateTimeParser.parseFormat(this.mISO8601Calendar, format, text, pp)) {
            if (null != result) {
                result.setValue((IValue)ValueFactory.createDate((Calendar)this.mISO8601Calendar));
            }
            return true;
        }
        return false;
    }

    protected final boolean parseLocalizedDate(DateFormat format, String text, ParsePosition pp, ParseResult result) {
        this.mLocalizedCalendar.clear();
        this.mLocalizedCalendar.setTimeZone(TimeZone.getDefault());
        if (DateTimeParser.parseFormat(this.mLocalizedCalendar, format, text, pp)) {
            if (null != result) {
                result.setValue((IValue)ValueFactory.createDate((Calendar)this.mLocalizedCalendar));
            }
            return true;
        }
        return false;
    }

    protected final boolean parseLocalizedTime(DateFormat format, String text, ParsePosition pp, ParseResult result) {
        this.mLocalizedCalendar.clear();
        this.mLocalizedCalendar.setTimeZone(TimeZone.getDefault());
        if (DateTimeParser.parseFormat(this.mLocalizedCalendar, format, text, pp)) {
            if (null != result) {
                result.setValue((IValue)ValueFactory.createTime((Calendar)this.mLocalizedCalendar));
            }
            return true;
        }
        return false;
    }

    protected final boolean parseLocalizedTimestamp(DateFormat timestampFormat, String text, ParsePosition pp, ParseResult result) {
        this.mLocalizedCalendar.clear();
        this.mLocalizedCalendar.setTimeZone(TimeZone.getDefault());
        if (DateTimeParser.parseFormat(this.mLocalizedCalendar, timestampFormat, text, pp)) {
            if (null != result) {
                result.setValue((IValue)ValueFactory.createTimestamp((Calendar)this.mLocalizedCalendar));
            }
            return true;
        }
        return false;
    }

    protected static final boolean parseFormat(Calendar calendar, DateFormat format, String text, ParsePosition pp) {
        if (text.length() == 0) {
            return false;
        }
        pp.setIndex(0);
        format.parse(text, calendar, pp);
        if (text.length() == pp.getIndex()) {
            try {
                calendar.getTimeInMillis();
                return true;
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
        }
        return false;
    }
}

