/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract.process;

import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.aurora.core.bvt.IBVColumn;
import com.ibm.cognos.aurora.core.bvt.IBVColumnAppender;
import com.ibm.cognos.aurora.core.bvt.IBVTable;
import com.ibm.cognos.aurora.core.extract.TabularDataset;
import com.ibm.cognos.aurora.core.extract.process.ITabularDatasetProcessor;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;

public final class ReconcileISO8601CompactDates
implements ITabularDatasetProcessor {
    private static final int MAX_SAMPLES = 100;
    private static final ILogger logger = LoggerManager.getLogger("ATHENA.core.aurora_core");
    private final Calendar mCalendar;
    private final DateFormat mISO8601_YYYYDDD;
    private final DateFormat mISO8601_YYYYMMDD;

    public ReconcileISO8601CompactDates(ULocale locale, TimeZone tz) {
        this.mCalendar = Calendar.getInstance((TimeZone)tz, (ULocale)locale);
        this.mCalendar.setLenient(false);
        this.mISO8601_YYYYMMDD = new SimpleDateFormat("yyyyMMdd", Locale.US);
        this.mISO8601_YYYYMMDD.setCalendar(this.mCalendar);
        this.mISO8601_YYYYDDD = new SimpleDateFormat("yyyyDDD", Locale.US);
        this.mISO8601_YYYYDDD.setCalendar(this.mCalendar);
    }

    @Override
    public void process(TabularDataset dataset) {
        LinkedList<TabularDataset.ColumnInfo> candidateColumns = new LinkedList<TabularDataset.ColumnInfo>();
        boolean isDebugEnabled = logger.isDebugEnabled();
        for (TabularDataset.ColumnInfo colInfo : dataset.getColumns()) {
            if (!colInfo.getDataType().isInteger() || !this.detectOrdinalDates(dataset, colInfo, isDebugEnabled)) continue;
            candidateColumns.add(colInfo);
        }
        for (TabularDataset.ColumnInfo colInfo : candidateColumns) {
            if (isDebugEnabled) {
                String msg = String.format("Detected possible ISO 6801 ordinal date in integer column (%s) from dataset '%s'; it will be converted", colInfo.getName(), dataset.getDatasetName());
                logger.debug(msg, this.getClass().getName() + "::process()");
            }
            if (this.convertToOrdinalDate(dataset, colInfo, isDebugEnabled)) {
                if (!isDebugEnabled) continue;
                logger.debug("Column conversion succeeded", this.getClass().getName() + "::process()");
                continue;
            }
            if (!isDebugEnabled) continue;
            logger.debug("Column conversion failed", this.getClass().getName() + "::process()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean detectOrdinalDates(TabularDataset dataset, TabularDataset.ColumnInfo colInfo, boolean isDebugEnabled) {
        IBVColumn originalCol = colInfo.getColumnData();
        int sampleCount = 0;
        try {
            IValueIterator iter = originalCol.openIterator();
            ParsePosition pos = new ParsePosition(0);
            try {
                while (iter.hasNext() && sampleCount < 100) {
                    Date dt;
                    IValue v = iter.next();
                    if (!v.isOK() || !v.getType().isInteger()) continue;
                    String strVal = Long.toString(v.longValue());
                    if (strVal.length() == 7) {
                        pos.setIndex(0);
                        dt = this.mISO8601_YYYYDDD.parse(strVal, pos);
                        if (null == dt || pos.getIndex() != strVal.length()) {
                            if (isDebugEnabled) {
                                logger.debug("Could not parse date: " + strVal, this.getClass().getName() + "::detectOrdinalDates()");
                            }
                            boolean bl = false;
                            return bl;
                        }
                    } else if (strVal.length() == 8) {
                        pos.setIndex(0);
                        dt = this.mISO8601_YYYYMMDD.parse(strVal, pos);
                        if (null == dt || pos.getIndex() != strVal.length()) {
                            if (isDebugEnabled) {
                                logger.debug("Could not parse date: " + strVal, this.getClass().getName() + "::detectOrdinalDates()");
                            }
                            boolean bl = false;
                            return bl;
                        }
                    } else {
                        if (isDebugEnabled) {
                            logger.debug("Wrong string length: " + strVal, this.getClass().getName() + "::detectOrdinalDates()");
                        }
                        boolean bl = false;
                        return bl;
                    }
                    ++sampleCount;
                }
            }
            finally {
                iter.close();
            }
        }
        catch (IOException ex) {
            String msg = String.format("Failed to iterate column (%s) from dataset '%s'", colInfo.getName(), dataset.getDatasetName());
            logger.error(msg, this.getClass().getName() + "::detectOrdinalDates()", ex);
            return false;
        }
        if (sampleCount <= 0) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean convertToOrdinalDate(TabularDataset dataset, TabularDataset.ColumnInfo colInfo, boolean isDebugEnabled) {
        IBVTable table = dataset.getTableData();
        IBVColumn originalCol = colInfo.getColumnData();
        IBVColumn tempCol = table.newColumn();
        long nullCount = 0L;
        long nonNullCount = 0L;
        try {
            IValueIterator iter = originalCol.openIterator();
            try {
                IBVColumnAppender appender = tempCol.openAppender();
                try {
                    ParsePosition pos = new ParsePosition(0);
                    while (iter.hasNext()) {
                        IValue v = iter.next();
                        if (v.isOK() && v.getType().isInteger()) {
                            Date dt;
                            String strVal = Long.toString(v.longValue());
                            if (strVal.length() == 7) {
                                pos.setIndex(0);
                                dt = this.mISO8601_YYYYDDD.parse(strVal, pos);
                                if (null == dt || pos.getIndex() != strVal.length()) {
                                    if (isDebugEnabled) {
                                        logger.debug("Could not parse date: " + strVal, this.getClass().getName() + "::convertToOrdinalDate()");
                                    }
                                    boolean bl = false;
                                    return bl;
                                }
                                ++nonNullCount;
                                appender.append((IValue)ValueFactory.createDate((Date)dt));
                                continue;
                            }
                            if (strVal.length() == 8) {
                                pos.setIndex(0);
                                dt = this.mISO8601_YYYYMMDD.parse(strVal, pos);
                                if (null == dt || pos.getIndex() != strVal.length()) {
                                    if (isDebugEnabled) {
                                        logger.debug("Could not parse date: " + strVal, this.getClass().getName() + "::convertToOrdinalDate()");
                                    }
                                    boolean bl = false;
                                    return bl;
                                }
                                ++nonNullCount;
                                appender.append((IValue)ValueFactory.createDate((Date)dt));
                                continue;
                            }
                            if (isDebugEnabled) {
                                logger.debug("Wrong string length: " + strVal, this.getClass().getName() + "::convertToOrdinalDate()");
                            }
                            boolean bl = false;
                            return bl;
                        }
                        ++nullCount;
                        appender.append((IValue)ValueFactory.createDate());
                    }
                }
                finally {
                    appender.close();
                }
            }
            finally {
                iter.close();
            }
            originalCol.copyFrom(tempCol);
            colInfo.setDataType((IDataType)DataTypes.getDateType());
            colInfo.setNullCount(nullCount);
            colInfo.setNonNullCount(nonNullCount);
            return true;
        }
        catch (IOException ex) {
            String msg = String.format("Failed to iterate column (%s) from dataset '%s'", colInfo.getName(), dataset.getDatasetName());
            logger.error(msg, this.getClass().getName() + "::convertToOrdinalDate()", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            table.dropColumn(tempCol);
        }
    }
}

