/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.impl;

import com.ibm.cognos.aurora.core.graph.api.IArc;
import com.ibm.cognos.aurora.core.graph.api.IGraph;
import com.ibm.cognos.aurora.core.graph.api.IVertex;
import com.ibm.cognos.aurora.core.graph.impl.SubGraph;
import com.ibm.cognos.aurora.core.graph.util.IPropertyChangeListener;
import com.ibm.cognos.aurora.core.graph.util.IPropertyContainer;
import com.ibm.cognos.aurora.core.graph.util.WeakListenerList;
import java.util.Set;

public class SubGraphArc
implements IArc {
    private final SubGraph mSubGraph;
    private final IArc mParentArc;
    private final WeakListenerList<IPropertyChangeListener> mPropertyListeners = new WeakListenerList();

    public SubGraphArc(SubGraph subGraph, IArc parentArc) {
        this.mSubGraph = subGraph;
        this.mParentArc = parentArc;
    }

    IArc getParentArc() {
        return this.mParentArc;
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.mParentArc.getPropertyKeys();
    }

    @Override
    public boolean containsPropertyKey(String key) {
        return this.mParentArc.containsPropertyKey(key);
    }

    @Override
    public Object getPropertyValue(String key) {
        return this.mParentArc.getPropertyValue(key);
    }

    @Override
    public <T> T getPropertyValue(String key, Class<T> klass) {
        return this.mParentArc.getPropertyValue(key, klass);
    }

    @Override
    public void setPropertyValue(String key, Object value) {
        this.mParentArc.setPropertyValue(key, value);
    }

    @Override
    public void removeProperty(String key) {
        this.mParentArc.removeProperty(key);
    }

    @Override
    public void copyFrom(IPropertyContainer source) {
        this.mParentArc.copyFrom(source);
    }

    @Override
    public void copyTo(IPropertyContainer target) {
        this.mParentArc.copyTo(target);
    }

    @Override
    public void clearProperties() {
        this.mParentArc.clearProperties();
    }

    @Override
    public void addListener(IPropertyChangeListener listener) {
        this.mPropertyListeners.add(listener);
    }

    @Override
    public void removeListener(IPropertyChangeListener listener) {
        this.mPropertyListeners.remove(listener);
    }

    @Override
    public IGraph getGraph() {
        return this.mSubGraph;
    }

    @Override
    public int getId() {
        return this.mParentArc.getId();
    }

    @Override
    public IVertex getStart() {
        return this.mSubGraph.getVertex(this.mParentArc.getStart().getId());
    }

    @Override
    public IVertex getEnd() {
        return this.mSubGraph.getVertex(this.mParentArc.getEnd().getId());
    }

    @Override
    public String getLabel() {
        return this.mParentArc.getLabel();
    }

    @Override
    public void setLabel(String label) {
        this.mParentArc.setLabel(label);
    }

    public boolean equals(Object o) {
        return this.mParentArc.equals(o);
    }

    public int hashCode() {
        return this.mParentArc.hashCode();
    }

    public String toString() {
        return this.mParentArc.toString();
    }

    protected void dispatchOnPropertyChanged(final String property, final Object oldValue, final Object newValue) {
        WeakListenerList.IListenerDispatcher<IPropertyChangeListener> dispatcher = new WeakListenerList.IListenerDispatcher<IPropertyChangeListener>(){

            @Override
            public void dispatch(IPropertyChangeListener listener) {
                listener.onPropertyChanged(SubGraphArc.this, property, oldValue, newValue);
            }
        };
        this.mPropertyListeners.dispatch(dispatcher);
    }
}

