/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.impl.mem;

import com.ibm.cognos.aurora.core.graph.api.IArc;
import com.ibm.cognos.aurora.core.graph.api.IGraph;
import com.ibm.cognos.aurora.core.graph.api.IGraphChangeListener;
import com.ibm.cognos.aurora.core.graph.api.IRootedGraph;
import com.ibm.cognos.aurora.core.graph.api.IVertex;
import com.ibm.cognos.aurora.core.graph.impl.mem.InMemoryGraph;
import com.ibm.cognos.aurora.core.graph.util.PredecessorMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.PriorityQueue;
import org.apache.commons.lang.mutable.MutableInt;

public class InMemoryRootedGraph
extends InMemoryGraph
implements IRootedGraph {
    private final IVertex mRoot;
    private final PredecessorMap mShortestPathsToRoot = new PredecessorMap();
    private final IGraphChangeListener mPathChangeListener = new RefreshShortestPathsToRoot();

    public InMemoryRootedGraph() {
        this.mRoot = this.newVertex();
        this.mRoot.setLabel("root");
        this.addListener(this.mPathChangeListener);
    }

    @Override
    public void removeVertex(int vertexId) {
        if (vertexId == this.mRoot.getId()) {
            throw new UnsupportedOperationException("Root vertex cannot be removed.");
        }
        super.removeVertex(vertexId);
    }

    @Override
    public IVertex getRoot() {
        return this.mRoot;
    }

    @Override
    public String[] getCanonicalPath(IVertex vertex) {
        LinkedList<IVertex> path = this.mShortestPathsToRoot.pathToSource(vertex);
        if (path.isEmpty() || path.getFirst() != vertex || path.getLast() != this.mRoot) {
            return null;
        }
        String[] pathArray = new String[path.size()];
        Iterator<IVertex> descIter = path.descendingIterator();
        for (int i = 0; i < pathArray.length; ++i) {
            pathArray[i] = descIter.next().getLabel();
        }
        return pathArray;
    }

    @Override
    public IVertex resolvePath(String[] path) {
        if (path.length == 0) {
            return null;
        }
        if (null != path[0] && !path[0].equals(this.mRoot.getLabel())) {
            return null;
        }
        IVertex v = this.mRoot;
        for (int i = 1; i < path.length; ++i) {
            String label = path[i];
            boolean found = false;
            for (IVertex w : v.neighbors()) {
                if (!label.equals(w.getLabel())) continue;
                found = true;
                v = w;
                break;
            }
            if (found) continue;
            return null;
        }
        return v;
    }

    private void computeShortestPathsToRoot() {
        final HashMap<IVertex, MutableInt> dist = new HashMap<IVertex, MutableInt>(this.numVertices());
        Comparator<IVertex> comp = new Comparator<IVertex>(){

            @Override
            public int compare(IVertex v1, IVertex v2) {
                String l2;
                int d2;
                int d1 = ((MutableInt)dist.get(v1)).intValue();
                if (d1 < (d2 = ((MutableInt)dist.get(v2)).intValue())) {
                    return -1;
                }
                if (d1 > d2) {
                    return 1;
                }
                String l1 = v1.getLabel();
                if (null == l1) {
                    l1 = "";
                }
                if (null == (l2 = v2.getLabel())) {
                    l2 = "";
                }
                return l1.compareTo(l2);
            }
        };
        PriorityQueue<IVertex> queue = new PriorityQueue<IVertex>(this.numVertices(), comp);
        for (IVertex v : this.vertices()) {
            dist.put(v, new MutableInt(Integer.MAX_VALUE));
        }
        ((MutableInt)dist.get(this.mRoot)).setValue(0);
        queue.add(this.mRoot);
        this.mShortestPathsToRoot.clear();
        while (!queue.isEmpty()) {
            IVertex u = queue.poll();
            int distToU = ((MutableInt)dist.get(u)).intValue();
            Iterator<IVertex> iterator = u.neighbors().iterator();
            while (iterator.hasNext()) {
                int distThroughU = distToU + 1;
                IVertex v = iterator.next();
                MutableInt distToV = (MutableInt)dist.get(v);
                if (distThroughU >= distToV.intValue()) continue;
                distToV.setValue(distThroughU);
                this.mShortestPathsToRoot.put(v, u);
                queue.add(v);
            }
        }
    }

    private final class RefreshShortestPathsToRoot
    implements IGraphChangeListener {
        private RefreshShortestPathsToRoot() {
        }

        @Override
        public void onVertexAdded(IVertex vertex) {
        }

        @Override
        public void onVertexRemoved(IVertex vertex) {
        }

        @Override
        public void onVertexPropertyChanged(IVertex vertex, String property, Object oldValue, Object newValue) {
        }

        @Override
        public void onArcAdded(IArc arc) {
            InMemoryRootedGraph.this.computeShortestPathsToRoot();
        }

        @Override
        public void onArcRemoved(IArc arc) {
            InMemoryRootedGraph.this.computeShortestPathsToRoot();
        }

        @Override
        public void onArcPropertyChanged(IArc arc, String property, Object oldValue, Object newValue) {
        }

        @Override
        public void onGraphPropertyChanged(IGraph graph, String property, Object oldValue, Object newValue) {
        }
    }
}

