/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.persist.bin;

import com.ibm.cognos.aurora.core.graph.api.IArc;
import com.ibm.cognos.aurora.core.graph.api.IGraph;
import com.ibm.cognos.aurora.core.graph.api.IRootedGraph;
import com.ibm.cognos.aurora.core.graph.api.IVertex;
import com.ibm.cognos.aurora.core.graph.api.action.ArcAddedAction;
import com.ibm.cognos.aurora.core.graph.api.action.VertexAddedAction;
import com.ibm.cognos.aurora.core.graph.persist.IGraphReader;
import com.ibm.cognos.aurora.core.graph.persist.bin.BinaryValueSerializer;
import com.ibm.cognos.aurora.core.graph.util.IPropertyContainer;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BinaryGraphReader
implements IGraphReader {
    private final DataInput mInput;
    private final BinaryValueSerializer mValueSerializer;

    public BinaryGraphReader(InputStream in) {
        this.mInput = new DataInputStream(in);
        this.mValueSerializer = new BinaryValueSerializer();
    }

    public BinaryGraphReader(DataInput in) {
        this.mInput = in;
        this.mValueSerializer = new BinaryValueSerializer();
    }

    public BinaryGraphReader(InputStream in, BinaryValueSerializer valueSerializer) {
        this.mInput = new DataInputStream(in);
        this.mValueSerializer = valueSerializer;
    }

    public BinaryGraphReader(DataInput in, BinaryValueSerializer valueSerializer) {
        this.mInput = in;
        this.mValueSerializer = valueSerializer;
    }

    @Override
    public void readGraph(IGraph graph) throws IOException {
        int i;
        boolean isRooted = graph instanceof IRootedGraph;
        int numVertices = EncodeUtil.readCompressedInt(this.mInput);
        int numArcs = EncodeUtil.readCompressedInt(this.mInput);
        this.readPropertyContainer(graph);
        for (i = 0; i < numVertices; ++i) {
            IVertex vertex;
            int vertexId = this.mInput.readInt();
            if (i == 0 && isRooted) {
                vertex = ((IRootedGraph)graph).getRoot();
            } else {
                graph.redoAction(new VertexAddedAction(vertexId));
                vertex = graph.getVertex(vertexId);
            }
            this.readPropertyContainer(vertex);
        }
        for (i = 0; i < numArcs; ++i) {
            int arcId = this.mInput.readInt();
            int startId = this.mInput.readInt();
            int endId = this.mInput.readInt();
            graph.redoAction(new ArcAddedAction(arcId, startId, endId));
            IArc arc = graph.getArc(arcId);
            this.readPropertyContainer(arc);
        }
    }

    private void readPropertyContainer(IPropertyContainer container) throws IOException {
        int numProps = EncodeUtil.readCompressedInt(this.mInput);
        for (int i = 0; i < numProps; ++i) {
            String key = EncodeUtil.readString(this.mInput);
            Object value = this.mValueSerializer.readValue(this.mInput);
            container.setPropertyValue(key, value);
        }
    }
}

