/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.util;

import com.ibm.cognos.aurora.core.graph.api.IArc;
import com.ibm.cognos.aurora.core.graph.api.IGraph;
import com.ibm.cognos.aurora.core.graph.api.IGraphChangeListener;
import com.ibm.cognos.aurora.core.graph.api.IVertex;
import com.ibm.cognos.aurora.core.graph.api.action.ArcAddedAction;
import com.ibm.cognos.aurora.core.graph.api.action.ArcPropChangedAction;
import com.ibm.cognos.aurora.core.graph.api.action.ArcRemovedAction;
import com.ibm.cognos.aurora.core.graph.api.action.GraphPropChangedAction;
import com.ibm.cognos.aurora.core.graph.api.action.IGraphAction;
import com.ibm.cognos.aurora.core.graph.api.action.VertexAddedAction;
import com.ibm.cognos.aurora.core.graph.api.action.VertexPropChangedAction;
import com.ibm.cognos.aurora.core.graph.api.action.VertexRemovedAction;
import com.ibm.cognos.aurora.core.graph.util.MapPropertyContainer;
import java.util.LinkedList;

public class GraphActionRecorder
implements IGraphChangeListener {
    private final LinkedList<IGraphAction> mActionList = new LinkedList();

    public LinkedList<IGraphAction> getActionList() {
        return this.mActionList;
    }

    @Override
    public void onGraphPropertyChanged(IGraph graph, String property, Object oldValue, Object newValue) {
        this.mActionList.add(new GraphPropChangedAction(property, oldValue, newValue));
    }

    @Override
    public void onVertexAdded(IVertex vertex) {
        this.mActionList.add(new VertexAddedAction(vertex.getId()));
    }

    @Override
    public void onVertexRemoved(IVertex vertex) {
        MapPropertyContainer props = new MapPropertyContainer();
        vertex.copyTo(props);
        this.mActionList.add(new VertexRemovedAction(vertex.getId(), props));
    }

    @Override
    public void onVertexPropertyChanged(IVertex vertex, String property, Object oldValue, Object newValue) {
        this.mActionList.add(new VertexPropChangedAction(vertex.getId(), property, oldValue, newValue));
    }

    @Override
    public void onArcAdded(IArc arc) {
        this.mActionList.add(new ArcAddedAction(arc.getId(), arc.getStart().getId(), arc.getEnd().getId()));
    }

    @Override
    public void onArcRemoved(IArc arc) {
        MapPropertyContainer props = new MapPropertyContainer();
        arc.copyTo(props);
        this.mActionList.add(new ArcRemovedAction(arc.getId(), arc.getStart().getId(), arc.getEnd().getId(), props));
    }

    @Override
    public void onArcPropertyChanged(IArc arc, String property, Object oldValue, Object newValue) {
        this.mActionList.add(new ArcPropChangedAction(arc.getId(), property, oldValue, newValue));
    }
}

