/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.io;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueStatus;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class CSVWriter {
    private final BufferedWriter mWriter;
    private final Character mFieldSeparator;
    private final Character mRecordSeparator;
    private final Character mEncapsulator;
    private final String mNullString;
    private final StringBuilder mRecordBuffer = new StringBuilder();

    public CSVWriter(OutputStream os, Character fieldSeparator, Character recordSeparator, Character encapsulator, String nullString) throws IOException {
        this.mWriter = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        this.mFieldSeparator = fieldSeparator;
        this.mRecordSeparator = recordSeparator;
        this.mEncapsulator = encapsulator;
        this.mNullString = nullString;
    }

    public CSVWriter(File csvFile, String fieldSeparator, String recordSeparator, String encapsulator, String nullString) throws IOException {
        this(csvFile, Character.valueOf(fieldSeparator.charAt(0)), Character.valueOf(recordSeparator.charAt(0)), Character.valueOf(encapsulator.charAt(0)), nullString);
    }

    public CSVWriter(File csvFile, Character fieldSeparator, Character recordSeparator, Character encapsulator, String nullString) throws IOException {
        this(new FileOutputStream(csvFile), fieldSeparator, recordSeparator, encapsulator, nullString);
    }

    public void writeRecord(IValue[] fields) {
        boolean first = true;
        this.mRecordBuffer.delete(0, this.mRecordBuffer.length());
        for (IValue field : fields) {
            if (first) {
                first = false;
            } else {
                this.mRecordBuffer.append(this.mFieldSeparator.charValue());
            }
            if (null == field || field.getStatus() != ValueStatus.OK) {
                this.mRecordBuffer.append(this.mNullString);
                continue;
            }
            this.appendWithEscapesAndEncapsulation(field.toString());
        }
        this.mRecordBuffer.append(this.mRecordSeparator.charValue());
        try {
            this.mWriter.append(this.mRecordBuffer);
        }
        catch (IOException ex) {
            throw new RuntimeException("An IO error occured", ex);
        }
    }

    public void writeRecord(String[] fields) {
        boolean first = true;
        this.mRecordBuffer.delete(0, this.mRecordBuffer.length());
        for (String field : fields) {
            if (first) {
                first = false;
            } else {
                this.mRecordBuffer.append(this.mFieldSeparator.charValue());
            }
            if (null == field) {
                this.mRecordBuffer.append(this.mNullString);
                continue;
            }
            this.appendWithEscapesAndEncapsulation(field);
        }
        this.mRecordBuffer.append(this.mRecordSeparator.charValue());
        try {
            this.mWriter.append(this.mRecordBuffer);
        }
        catch (IOException ex) {
            throw new RuntimeException("An IO error occured", ex);
        }
    }

    public void writeRecord(Object[] fields) {
        boolean first = true;
        this.mRecordBuffer.delete(0, this.mRecordBuffer.length());
        for (Object field : fields) {
            if (first) {
                first = false;
            } else {
                this.mRecordBuffer.append(this.mFieldSeparator.charValue());
            }
            if (null == field) {
                this.mRecordBuffer.append(this.mNullString);
                continue;
            }
            this.appendWithEscapesAndEncapsulation(field.toString());
        }
        this.mRecordBuffer.append(this.mRecordSeparator.charValue());
        try {
            this.mWriter.append(this.mRecordBuffer);
        }
        catch (IOException ex) {
            throw new RuntimeException("An IO error occured", ex);
        }
    }

    private void appendWithEscapesAndEncapsulation(String str) {
        int startPos = this.mRecordBuffer.length();
        boolean needsEncapsulation = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (null != this.mEncapsulator) {
                if (!needsEncapsulation) {
                    boolean bl = needsEncapsulation = c == this.mEncapsulator.charValue() || c == this.mFieldSeparator.charValue() || c == this.mRecordSeparator.charValue();
                }
                if (c == '\"') {
                    this.mRecordBuffer.append("\"\"");
                    continue;
                }
                this.mRecordBuffer.append(c);
                continue;
            }
            this.mRecordBuffer.append(c);
        }
        if (needsEncapsulation) {
            this.mRecordBuffer.append(this.mEncapsulator.charValue());
            this.mRecordBuffer.insert(startPos, this.mEncapsulator.charValue());
        }
    }

    public void flush() {
        try {
            this.mWriter.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException("An IO error occured", ex);
        }
    }

    public void close() {
        try {
            this.mWriter.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("An IO error occured", ex);
        }
    }
}

