/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.io;

import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.cognos.aurora.core.io.FileChannelOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileChannelDataOutputStream
extends FileChannelOutputStream
implements DataOutput {
    public FileChannelDataOutputStream(FileChannel channel) {
        super(channel);
    }

    public FileChannelDataOutputStream(FileChannel channel, int bufferSize) {
        super(channel, bufferSize);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        if (v) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.write(s.charAt(i) & 0xFF);
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.ensureBufferRemaining(2);
        this.mBuffer.putChar((char)(v & 0xFFFF));
        this.mBufferRemaining -= 2L;
        this.mStreamPos += 2L;
    }

    @Override
    public void writeChars(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.ensureBufferRemaining(8);
        this.mBuffer.putDouble(v);
        this.mBufferRemaining -= 8L;
        this.mStreamPos += 8L;
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.ensureBufferRemaining(4);
        this.mBuffer.putFloat(v);
        this.mBufferRemaining -= 4L;
        this.mStreamPos += 4L;
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.ensureBufferRemaining(4);
        this.mBuffer.putInt(v);
        this.mBufferRemaining -= 4L;
        this.mStreamPos += 4L;
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.ensureBufferRemaining(8);
        this.mBuffer.putLong(v);
        this.mBufferRemaining -= 8L;
        this.mStreamPos += 8L;
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.ensureBufferRemaining(2);
        this.mBuffer.putShort((short)(v & 0xFFFF));
        this.mBufferRemaining -= 2L;
        this.mStreamPos += 2L;
    }

    @Override
    public void writeUTF(String s) throws IOException {
        EncodeUtil.writeString(this, s);
    }
}

